/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbConfiguration;
import org.lsst.ccs.drivers.usb.UsbConfigurationDescriptor;
import org.lsst.ccs.drivers.usb.UsbDevice;
import org.lsst.ccs.drivers.usb.UsbDeviceDescriptor;
import org.lsst.ccs.drivers.usb.UsbEndpoint;
import org.lsst.ccs.drivers.usb.UsbEndpointDescriptor;
import org.lsst.ccs.drivers.usb.UsbInterface;
import org.lsst.ccs.drivers.usb.UsbInterfaceDescriptor;

public class UsbLib {
    public static final int SPEED_UNKNOWN = 0;
    public static final int SPEED_LOW = 1;
    public static final int SPEED_FULL = 2;
    public static final int SPEED_HIGH = 3;
    public static final int SPEED_SUPER = 4;
    public static final int CLASS_INTERFACE = 0;
    public static final int CLASS_AUDIO = 1;
    public static final int CLASS_COMM = 2;
    public static final int CLASS_HID = 3;
    public static final int CLASS_PHYSICAL = 5;
    public static final int CLASS_IMAGE = 6;
    public static final int CLASS_PRINTER = 7;
    public static final int CLASS_MASS_STORE = 8;
    public static final int CLASS_HUB = 9;
    public static final int CLASS_DATA = 10;
    public static final int CLASS_SMART_CARD = 11;
    public static final int CLASS_CONTENT_SEC = 13;
    public static final int CLASS_VIDEO = 14;
    public static final int CLASS_HEALTHCARE = 15;
    public static final int CLASS_DIAGNOSTIC = 220;
    public static final int CLASS_WIRELESS = 224;
    public static final int CLASS_MISC = 239;
    public static final int CLASS_APP_SPEC = 254;
    public static final int CLASS_VENDOR_SPEC = 255;
    public static final int CFG_ATTR_SELF_POWER = 64;
    public static final int CFG_ATTR_REMOTE_WAKE = 32;
    public static final int EP_ATTR_CONTROL = 0;
    public static final int EP_ATTR_ISOCHRONOUS = 1;
    public static final int EP_ATTR_BULK = 2;
    public static final int EP_ATTR_INTERRUPT = 3;
    public static final int EP_ATTR_BULK_STREAM = 4;
    public static final int EP_DIRECTION_IN = 128;
    private static long context;
    private static final Set<Long> openDevs;
    private static final CloseThread closeAll;

    static {
        openDevs = Collections.synchronizedSet(new HashSet());
        closeAll = new CloseThread();
        System.loadLibrary("UsbLib");
        Runtime.getRuntime().addShutdownHook(closeAll);
    }

    public static List<UsbDevice> getDevices(int vendor, int product, String serial) throws DriverException {
        long[] devs;
        ArrayList<UsbDevice> devices = new ArrayList<UsbDevice>();
        long[] lArray = devs = UsbLib.getDeviceList(UsbLib.getContext());
        int n = devs.length;
        int n2 = 0;
        while (n2 < n) {
            long dev = lArray[n2];
            boolean match = false;
            long devh = 0L;
            UsbDeviceDescriptor desc = UsbLib.newDeviceDescriptor(dev);
            if (!(vendor != -1 && vendor != desc.idVendor() || product != -1 && product != desc.idProduct())) {
                match = true;
                if (serial != null) {
                    try {
                        devh = UsbLib.openDev(dev);
                        String sn = UsbLib.getStringDescriptorAscii(devh, desc.iSerialNumber());
                        match = sn.contains(serial);
                    }
                    catch (DriverException driverException) {
                        match = false;
                    }
                }
            }
            if (match) {
                devices.add(new UsbDevice(dev, devh, desc));
            } else {
                if (devh != 0L) {
                    UsbLib.closeDev(devh);
                }
                UsbLib.unrefDevice(dev);
            }
            ++n2;
        }
        return devices;
    }

    public static UsbDevice getDevice(int vendor, int product, String serial, int index) throws DriverException {
        long[] devs;
        UsbDevice devc = null;
        long[] lArray = devs = UsbLib.getDeviceList(UsbLib.getContext());
        int n = devs.length;
        int n2 = 0;
        while (n2 < n) {
            long dev = lArray[n2];
            boolean match = false;
            long devh = 0L;
            UsbDeviceDescriptor desc = UsbLib.newDeviceDescriptor(dev);
            if (!(index < 0 || vendor != -1 && vendor != desc.idVendor() || product != -1 && product != desc.idProduct())) {
                match = true;
                if (serial != null) {
                    try {
                        devh = UsbLib.openDev(dev);
                        String sn = UsbLib.getStringDescriptorAscii(devh, desc.iSerialNumber());
                        match = sn.contains(serial);
                    }
                    catch (DriverException driverException) {
                        match = false;
                    }
                }
            }
            if (match && index-- == 0) {
                devc = new UsbDevice(dev, devh, desc);
            } else {
                if (devh != 0L) {
                    UsbLib.closeDev(devh);
                }
                UsbLib.unrefDevice(dev);
            }
            ++n2;
        }
        return devc;
    }

    static long openDev(long dev) throws DriverException {
        long devh = UsbLib.open(dev);
        openDevs.add(devh);
        return devh;
    }

    static void closeDev(long devh) {
        openDevs.remove(devh);
        UsbLib.close(devh);
    }

    public static UsbConfiguration buildConfiguration(long cdesc, UsbDevice devc) {
        long[] ifchs = UsbLib.getInterfaces(cdesc);
        ArrayList<List<UsbInterface>> ifcs = new ArrayList<List<UsbInterface>>();
        long[] lArray = ifchs;
        int n = ifchs.length;
        int n2 = 0;
        while (n2 < n) {
            long ifch = lArray[n2];
            long[] alths = UsbLib.getAltSettingDescriptors(ifch);
            ArrayList<UsbInterface> alts = new ArrayList<UsbInterface>();
            long[] lArray2 = alths;
            int n3 = alths.length;
            int n4 = 0;
            while (n4 < n3) {
                long alth = lArray2[n4];
                long[] ephs = UsbLib.getEndpointDescriptors(alth);
                ArrayList<UsbEndpoint> eps = new ArrayList<UsbEndpoint>();
                long[] lArray3 = ephs;
                int n5 = ephs.length;
                int n6 = 0;
                while (n6 < n5) {
                    long eph = lArray3[n6];
                    eps.add(new UsbEndpoint(UsbLib.newEndpointDescriptor(eph), devc));
                    ++n6;
                }
                alts.add(new UsbInterface(UsbLib.newInterfaceDescriptor(alth), alts, eps, devc));
                ++n4;
            }
            ifcs.add(alts);
            ++n2;
        }
        return new UsbConfiguration(UsbLib.newConfigurationDescriptor(cdesc), ifcs, devc);
    }

    static long getContext() throws DriverException {
        if (context == 0L) {
            context = UsbLib.init();
        }
        return context;
    }

    static native long init() throws DriverException;

    static native void exit(long var0);

    public static native long[] getDeviceList(long var0) throws DriverException;

    public static native int getBusNumber(long var0);

    public static native int getPortNumber(long var0);

    public static native int getDeviceAddress(long var0);

    public static native int getDeviceSpeed(long var0);

    public static native int getMaxPacketSize(long var0, int var2);

    public static native void unrefDevice(long var0);

    public static native long open(long var0) throws DriverException;

    public static native void close(long var0);

    public static native int getConfiguration(long var0) throws DriverException;

    public static native void setConfiguration(long var0, int var2) throws DriverException;

    public static native void claimInterface(long var0, int var2) throws DriverException;

    public static native void releaseInterface(long var0, int var2) throws DriverException;

    public static native void setInterfaceAltSetting(long var0, int var2, int var3) throws DriverException;

    public static native boolean kernelDriverActive(long var0, int var2) throws DriverException;

    public static native void detachKernelDriver(long var0, int var2) throws DriverException;

    public static native void attachKernelDriver(long var0, int var2) throws DriverException;

    public static native void setAutoDetachKernelDriver(long var0, boolean var2) throws DriverException;

    public static native void clearHalt(long var0, int var2) throws DriverException;

    public static native void resetDevice(long var0) throws DriverException;

    public static native UsbDeviceDescriptor newDeviceDescriptor(long var0) throws DriverException;

    public static native long getActiveConfigDescriptor(long var0) throws DriverException;

    public static native long getConfigDescriptor(long var0, int var2) throws DriverException;

    public static native long getConfigDescriptorByValue(long var0, int var2) throws DriverException;

    public static native void freeConfigDescriptor(long var0);

    public static native UsbConfigurationDescriptor newConfigurationDescriptor(long var0);

    public static native long[] getInterfaces(long var0);

    public static native long[] getAltSettingDescriptors(long var0);

    public static native UsbInterfaceDescriptor newInterfaceDescriptor(long var0);

    public static native long[] getEndpointDescriptors(long var0);

    public static native UsbEndpointDescriptor newEndpointDescriptor(long var0);

    public static native String getStringDescriptorAscii(long var0, int var2) throws DriverException;

    public static native int controlTransfer(long var0, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws DriverException;

    public static native int bulkTransfer(long var0, int var2, byte[] var3, int var4, int var5, int var6) throws DriverException;

    public static native int interruptTransfer(long var0, int var2, byte[] var3, int var4, int var5, int var6) throws DriverException;

    private static class CloseThread
    extends Thread {
        private CloseThread() {
        }

        @Override
        public void run() {
            for (Long devh : openDevs) {
                UsbLib.close(devh);
            }
        }
    }
}

