/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.alerts;

import org.lsst.ccs.bus.data.Alert;

public enum ComCamVacuumAlerts {
    CRYO_PLATE_TEMPERATURE_TOO_HIGH("CryoPlateHighTemp", "Alert for Cryo plate temperture too high"),
    CRYO_PLATE_TEMPERATURE_TOO_LOW("CryoPlateLowTemp", "Alert for Cryo plate temperture too low"),
    COLD_PLATE_TEMPERATURE_TOO_HIGH("ColdPlateHighTemp", "Alert for Cold plate temperture too high"),
    COLD_PLATE_TEMPERATURE_TOO_LOW("ColdPlateLowTemp", "Alert for Cold plate temperture too low"),
    PRESSURE_TOO_LOW("PressureLow", "Alert raised when the pressure too low"),
    PRESSURE_TOO_HIGH("PressureHigh", "Alert raised when the pressure too high"),
    VACUUM_VALVE_SHUT_OFF("VacuumValveShutOff", "Alert raised when the vacuum valve is shut off"),
    VACUUM_PLC_NOT_ALIVE("VacuumPLCNotAlive", "Vacuum PLC not alive"),
    UPS_ON_BATTERY("UPSOnBattery", "Alert raised when UPS goes onto battery"),
    UPS_DISCONNECTED("UPSDisconnected", "Alert raised when UPS becomes disconnected"),
    TURBO_PUMP_FAIL("TurboPumpFailure", "Alert raised when TurboPump status is Fail"),
    TURBO_PUMP_OVERTEMP("TUrboPumpOverTemp", "Alert raised when TurboPump temperature is too high"),
    GENERIC("GenericAlert", "Generic Alert");

    private final String id;
    private final String description;

    private ComCamVacuumAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getAlertId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert() {
        return this.getAlert(null);
    }

    private Alert getAlert(String prefix) {
        String aId = null;
        aId = prefix != null && !prefix.isEmpty() ? prefix + "/" + this.id : this.id;
        return new Alert(aId, this.description);
    }
}

