/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.BufferedDataOutputStream;

public class FitsCheckSum {
    private static final int CHECKSUM_BLOCK_SIZE = 4;
    private static final int CHECKSUM_STRING_SIZE = 16;
    private static final int ASCII_ZERO = 48;
    private static final Logger log = Logger.getLogger(FitsCheckSum.class.getName());

    private FitsCheckSum() {
    }

    public static long checksum(byte[] data) {
        return FitsCheckSum.computeChecksum(ByteBuffer.wrap(data));
    }

    public static long computeChecksum(ByteBuffer data) {
        return FitsCheckSum.updateChecksum(data, new Checksum());
    }

    public static long updateChecksum(ByteBuffer data, Checksum inOut) {
        if (data.remaining() % 4 != 0) {
            throw new IllegalArgumentException("fits blocks always must be dividable by 4");
        }
        data.order(ByteOrder.BIG_ENDIAN);
        ShortBuffer shortData = data.asShortBuffer();
        long hi = inOut.getHi();
        long lo = inOut.getLo();
        while (shortData.hasRemaining()) {
            hi += (long)(shortData.get() & 0xFFFF);
            lo += (long)(shortData.get() & 0xFFFF);
        }
        inOut.update(hi, lo);
        return inOut.getCheckSum();
    }

    public static String checksumEnc(long c, boolean compl) {
        return FitsCheckSum.checksumEncode(compl ? c ^ 0xFFFFFFFFFFFFFFFFL : c);
    }

    public static String checksumEncode(long checksum) {
        byte[] asc = new byte[16];
        String exclude = ":;<=>?@[\\]^_`";
        int offset = 48;
        for (int i = 0; i < 4; ++i) {
            int j;
            int byt = (int)(0xFFL & Long.rotateRight(checksum, (4 - i - 1) * 8));
            int quotient = byt / 4 + 48;
            int remainder = byt % 4;
            int[] ch = new int[4];
            for (j = 0; j < 4; ++j) {
                ch[j] = quotient;
            }
            ch[0] = ch[0] + remainder;
            for (j = 0; j < 4; j += 2) {
                while (exclude.indexOf(ch[j]) >= 0 || exclude.indexOf(ch[j + 1]) >= 0) {
                    int n = j;
                    ch[n] = ch[n] + 1;
                    int n2 = j + 1;
                    ch[n2] = ch[n2] - 1;
                }
            }
            for (j = 0; j < 4; ++j) {
                asc[4 * j + i] = (byte)ch[j];
            }
        }
        String resul = AsciiFuncs.asciiString((byte[])asc, (int)15, (int)1);
        return resul.concat(AsciiFuncs.asciiString((byte[])asc, (int)0, (int)15));
    }

    public static long checksumDecode(String encoded) {
        byte[] chars = encoded.getBytes(StandardCharsets.US_ASCII);
        if (chars.length != 16) {
            throw new IllegalArgumentException("Encoded checksum must consist of 16 US-ASCII characters");
        }
        byte tmp = chars[0];
        System.arraycopy(chars, 1, chars, 0, 15);
        chars[15] = tmp;
        int i = 0;
        while (i < 16) {
            int n = i++;
            chars[n] = (byte)(chars[n] - 48);
        }
        ByteBuffer bb = ByteBuffer.wrap(chars);
        bb.order(ByteOrder.BIG_ENDIAN);
        long result = 0L;
        result += (long)bb.getInt();
        result += (long)bb.getInt();
        result += (long)bb.getInt();
        return (result += (long)bb.getInt()) & 0xFFFFFFFFL;
    }

    static void updateDataSum(Header header, long dataSum) {
        HeaderCard dataSumCard = header.findCard((IFitsHeader)nom.tam.fits.header.Checksum.DATASUM);
        long oldDataSumCheckSum = FitsCheckSum.checksum(AsciiFuncs.getBytes((String)dataSumCard.toString()));
        String oldValue = dataSumCard.getValue();
        String newValue = Long.toString(dataSum);
        dataSumCard.setValue(newValue);
        long newDataSumCheckSum = FitsCheckSum.checksum(AsciiFuncs.getBytes((String)dataSumCard.toString()));
        long delta = Long.parseLong(newValue) - Long.parseLong(oldValue) + (newDataSumCheckSum - oldDataSumCheckSum);
        FitsCheckSum.updateCheckSum(header, delta);
    }

    public static void updateCheckSum(Header header, long delta) {
        HeaderCard checkSumCard = header.findCard((IFitsHeader)nom.tam.fits.header.Checksum.CHECKSUM);
        String oldChecksum = checkSumCard.getValue();
        long cksum = (FitsCheckSum.checksumDecode(oldChecksum) ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
        cksum += delta;
        while ((cksum & 0xFFFFFFFF00000000L) != 0L) {
            long cshduIntPart = cksum & 0xFFFFFFFFL;
            cksum = cshduIntPart + (cksum >> 32);
        }
        checkSumCard.setValue(FitsCheckSum.checksumEnc(cksum, true));
    }

    public static void setChecksum(BasicHDU<?> hdu) throws FitsException {
        Header hdr = hdu.getHeader();
        hdr.deleteKey((IFitsHeader)nom.tam.fits.header.Checksum.CHECKSUM);
        hdr.addValue((IFitsHeader)nom.tam.fits.header.Checksum.CHECKSUM, "0000000000000000");
        ByteArrayOutputStream hduByteImage = new ByteArrayOutputStream();
        BufferedDataOutputStream bdos = new BufferedDataOutputStream((OutputStream)hduByteImage);
        hdu.getData().write((ArrayDataOutput)bdos);
        try {
            bdos.flush();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "should not happen", e);
        }
        byte[] data = hduByteImage.toByteArray();
        FitsCheckSum.checksum(data);
        hdu.write((ArrayDataOutput)new BufferedDataOutputStream((OutputStream)hduByteImage));
        long csd = FitsCheckSum.checksum(data);
        hdu.getHeader().addValue((IFitsHeader)nom.tam.fits.header.Checksum.DATASUM, Long.toString(csd));
        hduByteImage.reset();
        hdu.getHeader().write((ArrayDataOutput)bdos);
        try {
            bdos.flush();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "should not happen", e);
        }
        data = hduByteImage.toByteArray();
        long csh = FitsCheckSum.checksum(data);
        long cshdu = csh + csd;
        while ((cshdu & 0xFFFFFFFF00000000L) != 0L) {
            long cshduIntPart = cshdu & 0xFFFFFFFFL;
            cshdu = cshduIntPart + 1L;
        }
        hdr.addValue((IFitsHeader)nom.tam.fits.header.Checksum.CHECKSUM, FitsCheckSum.checksumEnc(cshdu, true));
    }

    public static class Checksum {
        private long hi = 0L;
        private long lo = 0L;

        private long getHi() {
            return this.hi;
        }

        private long getLo() {
            return this.lo;
        }

        private void update(long hi, long lo) {
            long hicarry = hi >> 16;
            long locarry = lo >> 16;
            while (hicarry > 0L || locarry > 0L) {
                hi = (hi & 0xFFFFL) + locarry;
                lo = (lo & 0xFFFFL) + hicarry;
                hicarry = hi >> 16;
                locarry = lo >> 16;
            }
            this.hi = hi;
            this.lo = lo;
        }

        public long getCheckSum() {
            return this.hi << 16 | this.lo;
        }
    }
}

