import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.ccob.CCOBMainModule;
import org.lsst.ccs.subsystem.ccob.CCOBDevice;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.subsystem.ccob.Led;
import org.lsst.ccs.subsystem.ccob.Shutter;
import org.lsst.ccs.drivers.ccob.jni.CcobJNI
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["ccob-subsystem"]

builder.
    main (CCOBMainModule, nodeTags:["monitor-update/taskPeriodMillis":1000,"monitor-publish/taskPeriodMillis":10000]) {  
    
    // Low level access to driver, via a socket
    ccobDriver(CCOBCommands)
//        ccobDriver(CCOBSocketCommands, driver:new CcobSocketDriver("localhost", 1557))
    
    // ------ Monitoring 
    ccobDvc(CCOBDevice) {
        
        // Channels read as a group with getADCValues
        ledVoltage(Channel, description:"LED voltage", hwChan:CCOBDevice.CHAN_LED_VOLTAGE, units:"V", format:".5f",
                   checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:5.0, alarmHi:null)

        ledCurrent(Channel, description:"LED current", hwChan:CCOBDevice.CHAN_LED_CURRENT, units:"A", format:".6f",
                   checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:1.0, alarmHi:null)

        vrefLed(Channel, description:"LED reference voltage", hwChan:CCOBDevice.CHAN_LED_VREF, units:"V", format:".5f",
                checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:5.0, alarmHi:null)

        tempLed1(Channel, description:"LED temperature 1", hwChan:CCOBDevice.CHAN_LED_TEMP1, units:"\u00b0C", format:".1f",
                 checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)

        tempLed2(Channel, description:"LED temperature 2", hwChan:CCOBDevice.CHAN_LED_TEMP2, units:"\u00b0C", format:".1f",
                 checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)

        photodiodeCurrent(Channel, description:"Photodiode current", hwChan:CCOBDevice.CHAN_PD_CURRENT, units:"A", format:".6f",
                          checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:1.0, alarmHi:null)

        tempSphere(Channel, description:"Sphere temperature", hwChan:CCOBDevice.CHAN_SPHERE_TEMP, units:"\u00b0C", format:".1f",
                   checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)

        tempBrd(Channel, description:"Board temperature", hwChan:CCOBDevice.CHAN_BOARD_TEMP, units:"\u00b0C", format:".1f",
                checkLo:"flag", limitLo:-10.0, alarmLo:null, checkHi:"flag", limitHi:100.0, alarmHi:null)
        
        // Channels read separately
        photodiodeAdc(Channel, description:"Photodiode ADC", hwChan:CCOBDevice.CHAN_PD_ADC, units:"V", format:".5f",
                      checkLo:"flag", limitLo:0, alarmLo:null, checkHi:"flag", limitHi:5.0, alarmHi:null)
    }

    // ----- Other
    led (Led)
    shutter (Shutter)
}

