/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.freehep.application.studio.PluginDir;
import org.freehep.util.VersionComparator;

public class LibInfo {
    private String id;
    private String version;
    private String location;
    private String href;
    private PluginDir dir;
    private File file;

    public LibInfo(String location, String href) {
        this.href = href;
        this.location = location;
        int i = location.lastIndexOf(46);
        if (i != -1) {
            location = location.substring(0, i);
        }
        try {
            this.id = VersionComparator.stripVersion((String)location);
            this.version = location.substring(this.id.length() + 1);
        }
        catch (IllegalArgumentException x) {
            this.id = location;
        }
    }

    public LibInfo(File file, PluginDir dir) {
        block3: {
            this.file = file.getAbsoluteFile();
            this.dir = dir;
            String fileName = file.getName();
            int i = fileName.lastIndexOf(46);
            if (i != -1) {
                fileName = fileName.substring(0, i);
            }
            try {
                this.id = VersionComparator.stripVersion((String)fileName);
                this.version = fileName.substring(this.id.length() + 1);
            }
            catch (IllegalArgumentException x) {
                if (this.checkMavenID()) break block3;
                this.id = fileName;
            }
        }
    }

    public LibInfo(LibInfo other) {
        this.id = other.id;
        this.version = other.version;
        this.location = other.location;
        this.href = other.href;
        this.dir = other.dir;
        this.file = other.file;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public PluginDir getDir() {
        return this.dir;
    }

    public void setDir(PluginDir dir) {
        this.dir = dir;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public final boolean checkMavenID() {
        if (this.file == null || !this.file.exists()) {
            return false;
        }
        try {
            JarFile jar = new JarFile(this.file);
            JarEntry je = jar.getJarEntry("META-INF/maven");
            if (je != null) {
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    je = entries.nextElement();
                    String name = je.getName();
                    if (!name.startsWith("META-INF/maven") || !name.endsWith("pom.properties")) continue;
                    Properties p = new Properties();
                    p.load(jar.getInputStream(je));
                    this.version = p.getProperty("version");
                    if (this.version != null) {
                        this.id = p.getProperty("artifactId");
                    }
                    return true;
                }
            }
        }
        catch (IOException x) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof LibInfo) {
            return this.getId().equals(((LibInfo)o).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

