/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lakeshore.LS330;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class Lakeshore325Device
extends Device
implements CryoDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private static final int EVENT_ID_CRYO = 0;
    TSConfig cfg = new TSConfig();
    private double[] RUN_TEMP = new double[TSConfig.MAXSTATES];
    private double IDLE_TEMP = 20.0;
    List<Double> temperature_data = new ArrayList<Double>();
    List<Double> temperature_time = new ArrayList<Double>();
    private TSState.cryostates cstate = TSState.cryostates.NOTCONFIGURED;
    private LS330 tempDev;
    String current_channel = "";
    int current_loop = 1;
    boolean failedToInitialize = false;

    public Lakeshore325Device(int dummy, String host, int baud) throws DriverException {
        try {
            this.tempDev = new LS330();
            this.tempDev.openftdi(host, baud);
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed to open connection to Lakeshore device!");
        }
    }

    public Lakeshore325Device() {
    }

    @Override
    @Command(name="open", description="Open connection to Model LakeShore 325")
    public void open(@Argument(name="dummy type", description="Dummy type") int type, @Argument(name="identity", description="Device identifier") String ident, @Argument(name="parameter", description="Device parameter") int param) throws DriverException {
        this.tempDev = new LS330();
        this.tempDev.open(ident, param);
    }

    @Command(name="showident", description="Show Temp Control Lakeshore identification")
    public String showIdentification() throws DriverException {
        String ident = this.tempDev.getIdent();
        return "Show Lakeshore temp control identification" + ident;
    }

    @Override
    @Command(name="getMaxSetPoint", description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        this.log.info((Object)"Function not implemeneted for this device!");
        return -999.0;
    }

    @Override
    @Command(name="setMaxSetPoint", description="setMaxSetPoint for loop")
    public void setMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        if (this.tempDev != null) {
            this.log.info((Object)"Function not implemented for this device!");
        }
    }

    @Override
    @Command(name="getSetPoint", description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="unused loop") int loop) throws DriverException {
        return this.tempDev.getSetpoint();
    }

    @Override
    @Command(name="setSetPoint", description="setSetPoint for loop")
    public void setSetPoint(@Argument(name="loop", description="unused loop") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        if (this.tempDev != null) {
            this.tempDev.setSetpoint(temp);
        }
    }

    @Override
    @Command(name="getLoopSource", description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return 'A';
    }

    @Override
    @Command(name="setLoopSource", description="Set source channel for loop")
    public void setLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
        if (this.tempDev != null) {
            this.tempDev.setControlChannel(channel);
        }
    }

    @Override
    @Command(name="setHeaterRange", description="setHeaterRange for loop")
    public void setHeaterRange(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="range", description="hi,low,mid") String range) throws DriverException {
        if (this.tempDev != null) {
            this.log.info((Object)"Function not implemented for this device");
        }
    }

    @Override
    @Command(name="getHtrRead", description="Retrieve heater reading for loop")
    public double getHtrRead(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        this.log.info((Object)"Function not implemented for this device");
        return 1.0;
    }

    @Override
    @Command(name="getPID_P", description="Retrieve PID parameter P for loop")
    public double getPID_P(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        this.log.info((Object)"Function not implemented for this device");
        return 1.0;
    }

    @Override
    @Command(name="getPID_I", description="Retrieve PID parameter I for loop")
    public double getPID_I(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        this.log.info((Object)"Function not implemented for this device");
        return 1.0;
    }

    @Override
    @Command(name="getPID_D", description="Retrieve PID parameter D for loop")
    public double getPID_D(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        this.log.info((Object)"Function not implemented for this device");
        return 1.0;
    }

    @Override
    @Command(name="getTemp", description="Retrieve temperature info")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        if (!channel.isEmpty()) {
            char ch = channel.charAt(0);
            this.tempDev.setControlChannel(channel);
        }
        return this.tempDev.getControlData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Return the standard devation of the temperature values")
    public double getTempStdDev() {
        int ntemp = 0;
        double tempsum = 0.0;
        double tempsqsum = 0.0;
        for (double tempval : this.temperature_data) {
            tempsum += tempval;
            tempsqsum += tempval * tempval;
            ++ntemp;
        }
        double ovrstd = 0.0;
        if (ntemp > 0) {
            ovrstd = Math.sqrt(tempsqsum / (double)ntemp - tempsum * tempsum / (double)(ntemp * ntemp)) / (double)ntemp;
        }
        return ovrstd;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Return the temperature change over the sample period in degrees/minute")
    public double getTempChange() {
        double first_temp = this.temperature_data.get(0);
        double first_time = this.temperature_time.get(0);
        double last_temp = this.temperature_data.get(this.temperature_data.size() - 1);
        double last_time = this.temperature_time.get(this.temperature_time.size() - 1);
        double slope = 0.0;
        double delta_t = last_time - first_time;
        if (delta_t > 0.0) {
            slope = (first_temp - last_temp) / delta_t;
        }
        return slope;
    }

    @Override
    @Command(name="setruntemp", description="Sets the temp value for acquisition")
    public void setRunTemp(double Temp, int cfgstate) {
        this.RUN_TEMP[cfgstate] = Temp;
    }

    @Override
    @Command(name="getruntemp", description="Returns the temp value for acquisition")
    public double getRunTemp(int cfgstate) {
        return this.RUN_TEMP[cfgstate];
    }

    @Override
    @Command(name="rampVolts", description="ramp the voltage")
    public int rampTemp(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="value", description="Temp to ramp to") double value, @Argument(name="nsteps", description="number of steps") int nsteps) {
        block6: {
            try {
                if (this.tempDev == null) break block6;
                double tnow = this.getTemp(this.current_channel);
                double tstep = (value - tnow) / (double)nsteps;
                int delta = (int)(1000.0 * duration / (double)nsteps);
                System.out.println("ramp T from " + Double.toString(tnow) + " to " + Double.toString(value) + " with tstep = " + Double.toString(tstep) + " with tstep = " + Integer.toString(delta));
                System.out.println("starting T ramp");
                double t = tnow;
                boolean trip0 = this.isTrip();
                for (int istep = 0; istep < nsteps + 1; ++istep) {
                    System.out.println("T = " + t);
                    if (!trip0 && this.isTrip()) {
                        System.out.println("STOPPING RAMP!!! IT LOOKS LIKE WE CAUSED A TRIP!");
                        break;
                    }
                    this.setSetPoint(1, t);
                    try {
                        Thread.currentThread();
                        Thread.sleep(delta);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    t += tstep;
                }
                System.out.println("T ramp completed");
            }
            catch (DriverException f) {
                this.log.error((Object)"Cryocon Device failed to ramp temperature!");
            }
        }
        return 1;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="rampTemp", description="ramp the temperature to the desired point")
    public int rampTemp(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="t_target", description="Temp to ramp to") double t_target, @Argument(name="nsteps", description="number of steps") int nsteps, @Argument(name="warmer_loop", description="number of steps") int iwloop, @Argument(name="other_loop", description="number of steps") int ioloop, @Argument(name="warm_temp_chan", description="number of steps") String wchan, @Argument(name="other_temp_chan", description="number of steps") String ochan, @Argument(name="delta_warm", description="Temp to ramp to") double delta_warm) {
        try {
            if (this.tempDev != null) {
                double t;
                double tnow = this.getTemp(wchan);
                double tstep = (t_target - tnow) / (double)nsteps;
                int delta = (int)(1000.0 * duration / (double)nsteps);
                System.out.println("ramp T from " + Double.toString(tnow) + " C\n to " + Double.toString(t_target) + " C\n with delta Temp. (C) = " + Double.toString(tstep) + "\n and time step (ms) = " + Integer.toString(delta) + "\n Total duration (min) = " + duration / 60.0);
                System.out.println("starting temperature ramp ...");
                double t_other = t = tnow;
                boolean trip0 = this.isTrip();
                double cryotol = this.cfg.getCryoTAcqTol();
                while (tstep > 0.0 && t < t_target - tstep || tstep < 0.0 && t > t_target + tstep || tstep > 0.0 && t_other < t_target - tstep || tstep < 0.0 && t_other > t_target + tstep) {
                    if (tstep > 0.0 && t < t_target - tstep || tstep < 0.0 && t > t_target + tstep) {
                        t += tstep;
                        double otnow = this.getTemp(ochan);
                        if (t_other < t - delta_warm && otnow < tnow - delta_warm) {
                            t_other += tstep;
                        }
                    } else if (tstep > 0.0 && t_other < t_target - tstep || tstep < 0.0 && t_other > t_target + tstep) {
                        t_other += tstep;
                    }
                    if (!trip0 && this.isTrip()) {
                        this.log.error((Object)"STOPPING RAMP!!! IT LOOKS LIKE WE CAUSED A TRIP!");
                        break;
                    }
                    System.out.println("Setting warm loop temp to " + t + " C");
                    this.setSetPoint(iwloop, t);
                    System.out.println("Setting other loop temp to " + t_other + " C");
                    this.setSetPoint(ioloop, t_other);
                    try {
                        Thread.currentThread();
                        Thread.sleep(delta);
                    }
                    catch (Exception exception) {}
                }
                System.out.println("Setting warm loop temp to " + t + " C");
                this.setSetPoint(iwloop, t_target);
                System.out.println("Setting other loop temp to " + t_other + " C");
                this.setSetPoint(ioloop, t_target);
                this.log.info((Object)"temperature ramp completed");
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Cryocon Device failed to ramp temperature!");
        }
        return 1;
    }

    @Override
    @Command(name="getUnit", description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        char ch = channel.charAt(0);
        return this.tempDev.getSampleUnits().charAt(0);
    }

    @Override
    @Command(name="setUnit", description="Set temperature units")
    public void setUnit(@Argument(name="channel", description="Temp Channel to set") String channel, @Argument(name="units", description="Units in [K|C|F|S]") String unit) throws DriverException {
        char ch = channel.charAt(0);
        char un = unit.charAt(0);
        if (this.tempDev != null) {
            this.tempDev.setSampleChannel(channel);
            this.tempDev.setSampleUnits(unit);
        }
    }

    @Override
    @Command(name="setType", description="Set cal curve type : DIODE|ACR|PTC100|PTC1K|NTC10UA|ACR|TC70|NONE")
    public void setType(@Argument(name="channel", description="Temp Channel to set") String channel, @Argument(name="type", description="Calib. curve type [DIODE|ACR|PTC100|PTC1K|NTC10UA|ACR|TC70|NONE]") String typ) throws DriverException {
        this.log.debug((Object)"This function is not implmented for this device");
    }

    @Override
    @Command(name="setToControl", description="put loops in control mode")
    public void setToControl() throws DriverException {
        if (this.tempDev != null) {
            this.log.error((Object)"setToControl is not implemented for this device!");
        }
    }

    @Override
    @Command(name="isInControl", description="is the Lakeshore in control mode")
    public boolean isInControl() throws DriverException {
        boolean inControl = false;
        if (this.tempDev != null) {
            inControl = this.tempDev.isInControl();
        }
        return inControl;
    }

    @Override
    public void close() {
        try {
            if (this.tempDev != null) {
                this.tempDev.close();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"Lakeshore cryo device failed to close!!!");
        }
    }

    protected void initialize() {
        try {
            if (this.tempDev != null) {
                this.log.debug((Object)"Lakeshore device connected to:");
                this.log.debug((Object)this.showIdentification());
                this.setOnline(true);
            } else if (!this.failedToInitialize) {
                this.log.error((Object)"Tried to initialize unconnected cryo device!");
            }
        }
        catch (DriverException e) {
            if (!this.failedToInitialize) {
                this.log.error((Object)"Lakeshore failed to initialize!!!");
            }
            this.failedToInitialize = true;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != 0) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initChannel(int chan, int type, int subtype) {
        try {
            if (type != 0) return;
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        try {
            if (type == 0) {
                this.log.debug((Object)"readChannel in CryoCon performing getTemp");
                if (chan == 0) {
                    value = this.getTemp(this.current_channel);
                    this.temperature_data.add(value);
                    this.temperature_time.add((double)System.currentTimeMillis() / 60000.0);
                    if (this.temperature_data.size() > 120) {
                        this.temperature_data.remove(0);
                        this.temperature_time.remove(0);
                    }
                } else if (chan == -1) {
                    value = this.getRunTemp(1);
                } else if (chan == 2) {
                    value = this.getTempStdDev();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Override
    public double get_init_temp(int cfgstate) {
        return this.RUN_TEMP[cfgstate];
    }

    public double get_idle_temp() {
        return this.IDLE_TEMP;
    }

    @Override
    @Command
    public int getState() {
        return this.cstate.ordinal();
    }

    @Override
    @Command
    public void setState(int istate) {
        this.cstate = TSState.cryostates.values()[istate];
    }

    @Override
    public String getCurrent_channel() {
        return this.current_channel;
    }

    @Override
    public void setCurrent_channel(String current_channel) {
        this.current_channel = current_channel;
    }

    @Override
    public String getCurrent_channel2() {
        return this.current_channel;
    }

    @Override
    public void setCurrent_channel2(String current_channel) {
        this.current_channel = current_channel;
    }

    @Override
    public int getCurrent_loop() {
        return this.current_loop;
    }

    @Override
    public void setCurrent_loop(int current_loop) {
        this.current_loop = current_loop;
    }

    boolean isTrip() {
        return this.cstate == TSState.cryostates.TRIPPED;
    }

    boolean setTrip() {
        this.cstate = TSState.cryostates.TRIPPED;
        return false;
    }

    static {
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("PA", -1);
    }
}

