/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.AbstractNumericMethodGenerator;
import org.python.modules.jffi.JITSignature;
import org.python.modules.jffi.NativeType;

final class FastIntMethodGenerator
extends AbstractNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastIntMethodGenerator.getMaximumFastIntParameters();
    private static final String[] signatures = FastIntMethodGenerator.buildSignatures(Integer.TYPE, MAX_PARAMETERS);
    private static final String[] methodNames = new String[]{"invokeVrI", "invokeIrI", "invokeIIrI", "invokeIIIrI", "invokeIIIIrI", "invokeIIIIIrI", "invokeIIIIIIrI"};
    private static final String[] noErrnoMethodNames = new String[]{"invokeNoErrnoVrI", "invokeNoErrnoIrI", "invokeNoErrnoIIrI", "invokeNoErrnoIIIrI"};

    FastIntMethodGenerator() {
    }

    @Override
    String getInvokerMethodName(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (signature.isIgnoreError() && parameterCount <= MAX_PARAMETERS && parameterCount <= noErrnoMethodNames.length) {
            return noErrnoMethodNames[signature.getParameterCount()];
        }
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    String getInvokerSignature(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    final Class getInvokerIntType() {
        return Integer.TYPE;
    }

    @Override
    public boolean isSupported(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (!signature.getCallingConvention().equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform2.getCPU().equals((Object)Platform.CPU.I386) && !platform2.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (FastIntMethodGenerator.isFastIntParameter(platform2, signature.getParameterType(i))) continue;
            return false;
        }
        return FastIntMethodGenerator.isFastIntResult(platform2, signature.getResultType());
    }

    static final int getMaximumFastIntParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeIIIIIIrI", Function.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return 6;
        }
        catch (NoSuchMethodException nex) {
            try {
                Invoker.class.getDeclaredMethod("invokeIIIrI", Function.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return 3;
            }
            catch (NoSuchMethodException nex2) {
                return -1;
            }
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private static boolean isFastIntType(Platform platform2, NativeType type) {
        switch (type) {
            case BOOL: 
            case BYTE: 
            case UBYTE: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: {
                return true;
            }
            case LONG: 
            case ULONG: {
                return platform2.longSize() == 32;
            }
        }
        return false;
    }

    static boolean isFastIntResult(Platform platform2, NativeType type) {
        switch (type) {
            case VOID: {
                return true;
            }
            case POINTER: 
            case STRING: {
                return platform2.addressSize() == 32;
            }
        }
        return FastIntMethodGenerator.isFastIntType(platform2, type);
    }

    static boolean isFastIntParameter(Platform platform2, NativeType type) {
        switch (type) {
            case POINTER: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return platform2.addressSize() == 32;
            }
        }
        return FastIntMethodGenerator.isFastIntType(platform2, type);
    }
}

