/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gantry;

import java.time.Duration;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.MoveAxisMonitored;
import org.lsst.ccs.subsystem.motorplatform.gantry.Axis;

public class LoadCellAxis
extends Axis {
    @ConfigurationParameter(description="The scale factor used to convert load cell volts to Newtons.")
    private volatile double newtonsPerVolt = 1.0;
    @ConfigurationParameter(description="Direction of load signal change if colliding when ascending.")
    private volatile double ascendingLoadChangeDirection = -1.0;
    @ConfigurationParameter(description="Direction of load signal change if colliding when descending.")
    private volatile double descendingLoadChangeDirection = 1.0;
    @ConfigurationParameter(description="Load signal threshold used when ascending.")
    private volatile double ascendingLoadThreshold = 3.0;
    @ConfigurationParameter(description="Load signal theshold to use when descending.")
    private volatile double descendingLoadThreshold = 3.0;

    public void moveMonitored(AerotechPro165 aero, MoveAxisMonitored cmd) {
        double d = cmd.getDistance();
        boolean ascending = d < 0.0;
        double loadChangeDirection = ascending ? this.ascendingLoadChangeDirection : this.descendingLoadChangeDirection;
        double loadThreshold = ascending ? this.ascendingLoadThreshold : this.descendingLoadThreshold;
        double t = (double)cmd.getTime().toMillis() / 1000.0;
        double v = Math.abs(d) / (t - 0.2);
        v = Math.min(v, this.getMaxSpeed());
        double a = 10.0 * v;
        try {
            aero.writeAP("DGLOBAL(0) = " + loadThreshold / this.newtonsPerVolt);
            aero.writeAP("DGLOBAL(1) = " + loadChangeDirection);
            aero.writeAP("DGLOBAL(2) = " + d);
            aero.writeAP("DGLOBAL(3) = " + v);
            aero.writeAP("DGLOBAL(4) = " + a);
            aero.writeAP("DGLOBAL(5) = " + (Math.abs(d) / v + 0.2));
            aero.writeAP("PROGRAM RUN 1, \"CellMove.bcx\"");
        }
        catch (DriverException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Duration getMonitoredMoveTimeout(MoveAxisMonitored cmd) {
        MoveAxisRelative relcmd = new MoveAxisRelative(this.getName(), cmd.getDistance(), cmd.getTime());
        return this.getRelativeMoveTimeout(relcmd);
    }

    public double getVoltsToNewtons() {
        return this.newtonsPerVolt;
    }
}

