/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;

@Entity
@Immutable
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"hashMD5"})})
public class BaseDescription
implements Serializable {
    private static final long serialVersionUID = 1931407188397328132L;
    private long id;
    private AgentDesc agentDesc;
    private Map<ParameterPath, ConfigurationParameter> parameterDescriptions = new HashMap<ParameterPath, ConfigurationParameter>();
    private List<Description> compatibleDescriptions = new ArrayList<Description>();
    private byte[] hashMD5;

    protected BaseDescription() {
    }

    public BaseDescription(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKey(name="parameterPath")
    public Map<ParameterPath, ConfigurationParameter> getConfigurationParameters() {
        return this.parameterDescriptions;
    }

    void setConfigurationParameters(Map<ParameterPath, ConfigurationParameter> paramDescriptions) {
        this.parameterDescriptions = paramDescriptions;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="agentName")
    public AgentDesc getAgentDesc() {
        return this.agentDesc;
    }

    public void setAgentDesc(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    @Column(columnDefinition="varbinary(100)", nullable=false)
    public byte[] getHashMD5() {
        return this.hashMD5 == null ? null : Arrays.copyOf(this.hashMD5, this.hashMD5.length);
    }

    public void setHashMD5(byte[] hashMD5) {
        this.hashMD5 = hashMD5 == null ? null : Arrays.copyOf(hashMD5, hashMD5.length);
    }

    public static byte[] computeHashMD5(AgentDesc ad, List<ConfigurationParameter> parameters) {
        TreeMap<ParameterPath, ConfigurationParameter> map = new TreeMap<ParameterPath, ConfigurationParameter>();
        for (ConfigurationParameter configurationParameter : parameters) {
            map.put(configurationParameter.getParameterPath(), configurationParameter);
        }
        StringBuilder sb = new StringBuilder(ad.getAgentName()).append("*");
        for (Map.Entry entry : map.entrySet()) {
            ParameterPath name = (ParameterPath)entry.getKey();
            ConfigurationParameter cpi = (ConfigurationParameter)entry.getValue();
            sb.append(name).append(",").append(cpi.getCategory()).append(",").append(cpi.getType()).append(",").append(cpi.isFinal()).append(":");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            throw new RuntimeException(exception);
        }
    }

    @OneToMany(mappedBy="baseDescription", fetch=FetchType.EAGER)
    public List<Description> getCompatibleDescriptions() {
        return this.compatibleDescriptions;
    }

    public void setCompatibleDescriptions(List<Description> l) {
        this.compatibleDescriptions = l;
    }

    public String toString() {
        return "{id=" + this.getId() + ";descriptions=" + this.getConfigurationParameters() + '}';
    }

    public ConfigurationParameter fetch(String pathString) {
        for (ConfigurationParameter cp : this.parameterDescriptions.values()) {
            if (!cp.getParameterPath().toString().equals(pathString)) continue;
            return cp;
        }
        throw new RuntimeException("cannot find configuration parameter for " + pathString + " in BaseDescription " + this.toString());
    }
}

