/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.logging.Logger;

public class BiasControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String GD_P = "gdP";
    public static final String OD_P = "odP";
    public static final String OG_P = "ogP";
    public static final String RD_P = "rdP";
    public static final String CS_GATE_P = "csGateP";
    public static final String GD = "gd";
    public static final String OD = "od";
    public static final String OG = "og";
    public static final String OG_SH = "ogSh";
    public static final String RD = "rd";
    public static final String CS_GATE = "csGate";
    private static final int GD_CH = 1;
    private static final int OD_CH = 2;
    private static final int OG_CH = 4;
    private static final int OG_SH_CH = 8;
    private static final int RD_CH = 16;
    private static final int CSGATE_CH = 32;
    private static final String[] checkList = new String[]{"gd", "od", "og", "rd"};
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(category="Rafts")
    private double gdP;
    @ConfigurationParameter(category="Rafts")
    private double odP;
    @ConfigurationParameter(category="Rafts")
    private double ogP;
    @ConfigurationParameter(category="Rafts")
    private double rdP;
    @ConfigurationParameter(category="Rafts")
    private double csGateP;
    @ConfigurationParameter(category="RaftsLimits")
    private double gdMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double gdMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double odMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double odMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double ogMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double ogMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double rdMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double rdMax;
    @ConfigurationParameter(category="Rafts")
    private int gd;
    @ConfigurationParameter(category="Rafts")
    private int od;
    @ConfigurationParameter(category="Rafts")
    private int og;
    @ConfigurationParameter(category="Rafts")
    private int ogSh;
    @ConfigurationParameter(category="Rafts")
    private int rd;
    @ConfigurationParameter(category="Rafts")
    private int csGate;
    private boolean raw = false;
    private final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private boolean valid;
    private int hwVersion;
    private BoardDacs dac;
    private int changed = -1;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private String configError;
    private double gdConv;
    private double odConv;
    private double rdConv;
    private double ogConv;
    private double ogShiftConv;
    private double csConv;
    private double csOffset;

    public BiasControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    @Deprecated
    public BiasControl(String desc, int hwChan, int gd, int od, int og, int ogSh, int rd, int csGate) {
        this.description = desc;
        this.hwChan = hwChan;
        this.gd = gd;
        this.od = od;
        this.og = og;
        this.ogSh = ogSh;
        this.rd = rd;
        this.csGate = csGate;
        this.raw = true;
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        if (this.configError != null) {
            this.sLog.error((Object)("Config error (startup): " + this.getName() + ": " + this.configError));
        }
        this.dac = ((REBDevice)devc).getBoardDacs();
    }

    public boolean checkConfig() {
        this.hwVersion = BiasControl.getHwVersion(this.dac);
        if (this.hwVersion == -1) {
            this.sLog.error((Object)("BIAS " + this.hwChan + " configuration incompatible with the firmware"));
            return false;
        }
        try {
            if (this.hwChan < 0 || this.hwChan >= this.dac.getNumStrips()) {
                MonitorLogUtils.reportError((Logger)this.sLog, (String)this.getName(), (String)"HW channel", (Object)this.hwChan);
            }
        }
        catch (DriverException e) {
            this.sLog.error((Object)"Error getting number of strips");
            return false;
        }
        catch (Exception e) {
            return false;
        }
        if (!this.raw) {
            if (this.hwVersion == 1) {
                this.gdConv = this.odConv = 136.7278797996661;
                this.rdConv = this.odConv;
            } else if (this.hwVersion == 2) {
                this.odConv = 112.769123783032;
                this.gdConv = 113.75;
                this.rdConv = 163.14741035856574;
            } else {
                this.gdConv = this.odConv = 113.75;
                this.rdConv = 163.14741035856574;
            }
            double ogGain = 1.0;
            double fudge = this.hwVersion == 3 ? 1.0 : 1.1;
            this.ogShiftConv = fudge * 819.0 / ogGain;
            this.ogConv = fudge * 819.0 / (1.0 + ogGain);
            this.csConv = 1638.0;
            this.csOffset = -0.95;
        } else {
            this.valid = true;
        }
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        version = version == 2 || version == 4 || version == 5 ? 1 : (version == 3 || version == 6 ? 2 : (version == 7 || version == 8 ? 3 : -1));
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        if (this.raw) {
            return;
        }
        String errMsg = null;
        boolean newLimits = false;
        for (String pName : checkList) {
            double value = (Double)params.get(pName + "P");
            StringBuilder stringBuilder = new StringBuilder();
            if (value > (Double)params.get(stringBuilder.append(pName).append("Max").toString())) {
                errMsg = pName + "P is above high limit";
                break;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!(value < (Double)params.get(stringBuilder2.append(pName).append("Min").toString()))) continue;
            errMsg = pName + "P is below low limit";
            break;
        }
        if (errMsg != null && this.getName() != null) {
            for (String pName : checkList) {
                if ((Double)params.get(pName + "Max") == this.highLimitMap.get(pName) && (Double)params.get(pName + "Min") == this.lowLimitMap.get(pName)) continue;
                newLimits = true;
                break;
            }
        }
        if (errMsg == null) {
            this.valid = true;
            return;
        }
        if (this.getName() == null) {
            this.valid = false;
            this.configError = errMsg;
            return;
        }
        if (newLimits) {
            this.valid = false;
            this.sLog.error((Object)("Config error (new limits): " + this.getName() + ": " + errMsg));
            return;
        }
        errMsg = this.getName() + ": " + errMsg;
        this.sLog.error((Object)("Config error: " + errMsg));
        throw new IllegalArgumentException(errMsg);
    }

    @ConfigurationParameterChanger
    public void setGdP(double value) {
        this.gdP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Guard Diode voltage")
    public double getGdP() {
        return this.gdP;
    }

    @ConfigurationParameterChanger
    public void setGdMax(double value) {
        this.gdMax = value;
        this.highLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setGdMin(double value) {
        this.gdMin = value;
        this.lowLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setOdP(double value) {
        this.odP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the readout mode Output Drain voltage")
    public double getOdP() {
        return this.odP;
    }

    @ConfigurationParameterChanger
    public void setOdMax(double value) {
        this.odMax = value;
        this.highLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOdMin(double value) {
        this.odMin = value;
        this.lowLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOgP(double value) {
        this.ogP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Output Gate voltage")
    public double getOgP() {
        return this.ogP;
    }

    @ConfigurationParameterChanger
    public void setOgMax(double value) {
        this.ogMax = value;
        this.highLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setOgMin(double value) {
        this.ogMin = value;
        this.lowLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setRdP(double value) {
        this.rdP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Reset Drain voltage")
    public double getRdP() {
        return this.rdP;
    }

    @ConfigurationParameterChanger
    public void setRdMax(double value) {
        this.rdMax = value;
        this.highLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setRdMin(double value) {
        this.rdMin = value;
        this.lowLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setCsGateP(double value) {
        this.csGateP = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Current Source gate")
    public double getCsGateP() {
        return this.csGateP;
    }

    @ConfigurationParameterChanger
    public void setGd(int value) {
        this.gd = value;
        this.changed |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Guard Diode DAC value")
    public int getGd() {
        return this.gd;
    }

    @ConfigurationParameterChanger
    public void setOd(int value) {
        this.od = value;
        this.changed |= 2;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the readout mode Output Drain DAC value")
    public int getOd() {
        return this.od;
    }

    @ConfigurationParameterChanger
    public void setOg(int value) {
        this.og = value;
        this.changed |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Output Gate DAC value")
    public int getOg() {
        return this.og;
    }

    @ConfigurationParameterChanger
    public void setOgSh(int value) {
        this.ogSh = value;
        this.changed |= 8;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Output Gate shift DAC value")
    public int getOgSh() {
        return this.ogSh;
    }

    @ConfigurationParameterChanger
    public void setRd(int value) {
        this.rd = value;
        this.changed |= 0x10;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Reset Drain DAC value")
    public int getRd() {
        return this.rd;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int value) {
        this.csGate = value;
        this.changed |= 0x20;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Current Source gate")
    public int getCsGate() {
        return this.csGate;
    }

    void setConfig(BiasDACS bias) {
        Object[] values;
        String name = this.getName();
        if (!this.raw) {
            values = bias.getPValues();
            this.sce.submitChange(name, GD_P, (Object)values[0]);
            this.sce.submitChange(name, OD_P, (Object)values[1]);
            this.sce.submitChange(name, OG_P, (Object)values[2]);
            this.sce.submitChange(name, RD_P, (Object)values[5]);
            this.sce.submitChange(name, CS_GATE_P, (Object)values[4]);
        } else {
            values = bias.getValues();
            this.sce.submitChange(name, GD, (Object)((int)values[0]));
            this.sce.submitChange(name, OD, (Object)((int)values[1]));
            this.sce.submitChange(name, OG, (Object)((int)values[2]));
            this.sce.submitChange(name, OG_SH, (Object)((int)values[3]));
            this.sce.submitChange(name, RD, (Object)((int)values[5]));
            this.sce.submitChange(name, CS_GATE, (Object)((int)values[4]));
        }
        try {
            this.sce.commitBulkChange();
        }
        catch (IllegalArgumentException e) {
            this.sce.dropSubmittedChangesForComponent(name);
            throw e;
        }
    }

    BiasDACS getConfig() {
        BiasDACS bias = new BiasDACS();
        if (!this.raw) {
            double[] values = bias.getPValues();
            values[0] = this.gdP;
            values[1] = this.odP;
            values[2] = this.ogP;
            values[5] = this.rdP;
            values[4] = this.csGateP;
        } else {
            int[] values = bias.getValues();
            values[0] = this.gd;
            values[1] = this.od;
            values[2] = this.og;
            values[3] = this.ogSh;
            values[5] = this.rd;
            values[4] = this.csGate;
        }
        return bias;
    }

    int load() throws Exception {
        if (!this.valid) {
            throw new RaftException(this.getName() + " configuration not valid");
        }
        if (!this.raw) {
            this.setDac(13, (int)(this.gdConv * this.gdP));
            this.setDac(12, (int)(this.odConv * this.odP));
            this.setDac(15, this.ogP > 0.0 ? (int)(this.ogConv * this.ogP) : 0);
            this.setDac(16, this.ogP < 0.0 ? (int)(-this.ogShiftConv * this.ogP) : 0);
            this.setDac(14, (int)(this.rdConv * this.rdP));
            this.setDac(17, (int)(this.csConv * (this.csGateP + this.csOffset)));
        } else {
            this.setDac(13, this.gd);
            this.setDac(12, this.od);
            this.setDac(15, this.og);
            this.setDac(16, this.ogSh);
            this.setDac(14, this.rd);
            this.setDac(17, this.csGate);
        }
        this.loadDac();
        this.changed = 0;
        return 6;
    }

    int loadChanged() throws Exception {
        if (!this.valid) {
            throw new RaftException(this.getName() + " configuration not valid");
        }
        int count = 0;
        if (this.changed != 0) {
            if (!this.raw) {
                if ((this.changed & 1) != 0) {
                    this.setDac(13, (int)(this.gdConv * this.gdP));
                    ++count;
                }
                if ((this.changed & 2) != 0) {
                    this.setDac(12, (int)(this.odConv * this.odP));
                    ++count;
                }
                if ((this.changed & 4) != 0) {
                    this.setDac(15, this.ogP > 0.0 ? (int)(this.ogConv * this.ogP) : 0);
                    this.setDac(16, this.ogP < 0.0 ? (int)(-this.ogShiftConv * this.ogP) : 0);
                    count += 2;
                }
                if ((this.changed & 0x10) != 0) {
                    this.setDac(14, (int)(this.rdConv * this.rdP));
                    ++count;
                }
                if ((this.changed & 0x20) != 0) {
                    this.setDac(17, (int)(this.csConv * (this.csGateP + this.csOffset)));
                    ++count;
                }
            } else {
                if ((this.changed & 1) != 0) {
                    this.setDac(13, this.gd);
                    ++count;
                }
                if ((this.changed & 2) != 0) {
                    this.setDac(12, this.od);
                    ++count;
                }
                if ((this.changed & 4) != 0) {
                    this.setDac(15, this.og);
                    ++count;
                }
                if ((this.changed & 8) != 0) {
                    this.setDac(16, this.ogSh);
                    ++count;
                }
                if ((this.changed & 0x10) != 0) {
                    this.setDac(14, this.rd);
                    ++count;
                }
                if ((this.changed & 0x20) != 0) {
                    this.setDac(17, this.csGate);
                    ++count;
                }
            }
            this.loadDac();
            this.changed = 0;
        }
        return count;
    }

    void clear() throws Exception {
        this.setDac(13, 0);
        this.setDac(12, 0);
        this.setDac(15, 0);
        this.setDac(16, 0);
        this.setDac(14, 0);
        this.setDac(17, 0);
        this.loadDac();
        this.changed = -1;
    }

    void setDac(int chan, int value) throws Exception {
        this.testOnline();
        try {
            this.dac.set(this.hwChan, chan, value < 0 ? 0 : (value > 4095 ? 4095 : value));
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
        }
    }

    void loadDac() throws Exception {
        this.testOnline();
        try {
            this.dac.loadStrip(this.hwChan);
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
        }
    }
}

