/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;

public class InstrumentReport {
    public final List<InstrumentStatus> states;

    public InstrumentReport(List<Instrument> instruments) {
        this.states = Collections.unmodifiableList(instruments.stream().map(Instrument::getStatus).collect(ArrayList::new, ArrayList::add, ArrayList::addAll));
    }

    public String toString() {
        Formatter fmt = new Formatter();
        int[] seq = new int[]{0};
        fmt.format("Index  Location  Enabled?  Last data time%n", new Object[0]);
        fmt.format("-----  --------  --------  ---------------------------%n", new Object[0]);
        this.states.stream().forEachOrdered(sta -> {
            fmt.format("%5d  %-8s  %-8b  %s%n", seq[0], sta.location, sta.enabled, sta.lastDataTime);
            seq[0] = seq[0] + 1;
        });
        return fmt.toString();
    }
}

