/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class WattsUp
extends Ascii {
    public static final int FLD_WATTS = 0;
    public static final int FLD_VOLTS = 1;
    public static final int FLD_AMPS = 2;
    public static final int FLD_WATT_HOURS = 3;
    public static final int FLD_COST = 4;
    public static final int FLD_WH_MONTH = 5;
    public static final int FLD_COST_MONTH = 6;
    public static final int FLD_WATTS_MAX = 7;
    public static final int FLD_VOLTS_MAX = 8;
    public static final int FLD_AMPS_MAX = 9;
    public static final int FLD_WATTS_MIN = 10;
    public static final int FLD_VOLTS_MIN = 11;
    public static final int FLD_AMPS_MIN = 12;
    public static final int FLD_POWER_FACTOR = 13;
    public static final int FLD_DUTY_CYCLE = 14;
    public static final int FLD_POWER_CYCLE = 15;
    public static final int FLD_FREQUENCY = 16;
    public static final int FLD_VOLT_AMPS = 17;
    public static final int N_FIELDS = 18;
    public static final int N_CAL_FIELDS = 48;
    public static final int MEM_OPT_SUSPEND = 0;
    public static final int MEM_OPT_OVERWRITE = 1;
    public static final int MEM_OPT_CONDENSE = 2;
    public static final int LOG_STA_SUSPENDED = 0;
    public static final int LOG_STA_INTERNAL = 1;
    public static final int LOG_STA_EXTERNAL = 2;
    public static final int VER_FLD_MODEL = 0;
    public static final int VER_FLD_MEMORY = 1;
    public static final int VER_FLD_HWMAJOR = 2;
    public static final int VER_FLD_HW_MINOR = 3;
    public static final int VER_FLD_FWMAJOR = 4;
    public static final int VER_FLD_FWMINOR = 5;
    public static final int VER_FLD_FWTSTAMP = 6;
    public static final int VER_FLD_CHECKSUM = 7;
    public static final int N_VER_FIELDS = 8;
    private static final int BAUD_RATE = 115200;
    private static final int READ_TIMEOUT = 2000;
    private static final int READ_INTERVAL = 1000;
    private static final int CHECK_INTERVAL = 5000;
    private final BlockingQueue replyQ = new ArrayBlockingQueue(10);
    private final BlockingQueue closeQ = new ArrayBlockingQueue(1);
    private boolean open;
    private boolean powered;
    private Reader reader;
    private int nDataSent;
    private Listener listener;

    public WattsUp() {
        super(Ascii.Option.NO_NET);
        new Timer("WattsUp CheckPower", true).schedule((TimerTask)new CheckPower(), 0L, 5000L);
    }

    @Override
    public void open(DriverConstants.ConnType connType, String ident, int parm1, int parm2) throws DriverException {
        if (this.open) {
            throw new DriverException("Device already open");
        }
        super.open(connType, ident, parm1 == 0 ? 115200 : parm1, parm2);
        this.setTimeout(1000);
        this.open = true;
        this.nDataSent = 0;
        this.replyQ.clear();
        this.closeQ.clear();
        this.reader = new Reader();
        this.reader.setName("WattsUp Reader");
        this.reader.setDaemon(true);
        this.reader.start();
    }

    public void open(DriverConstants.ConnType connType, String ident) throws DriverException {
        this.open(connType, ident, 0, 0);
    }

    @Override
    public void close() throws DriverException {
        this.checkOpen();
        this.open = false;
        this.powered = false;
        Object excp = null;
        try {
            excp = this.closeQ.take();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (excp instanceof DriverException) {
            throw (DriverException)excp;
        }
    }

    public void closeAscii() throws DriverException {
        super.close();
    }

    public void addListener(Listener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public synchronized int getLoggedFields() throws DriverException {
        this.checkOpen();
        this.send("#C,R,0;");
        String[] reply = this.receive("c", 18);
        int mask = 0;
        for (int j = 0; j < 18; ++j) {
            if (!reply[j].contains("1")) continue;
            mask |= 1 << j;
        }
        return mask;
    }

    public synchronized int setLoggedFields(int mask) throws DriverException {
        this.checkOpen();
        String cmnd = "#C,W,18";
        for (int j = 0; j < 18; ++j) {
            cmnd = cmnd + "," + ((mask & 1 << j) != 0 ? "1" : "0");
        }
        cmnd = cmnd + ';';
        this.send(cmnd);
        return Integer.valueOf(this.receive("n", 1)[0]);
    }

    public synchronized int[] getCalibrationData() throws DriverException {
        this.checkOpen();
        this.send("#F,R,0;");
        String[] reply = this.receive("f", 48);
        int[] values = new int[48];
        for (int j = 0; j < 48; ++j) {
            values[j] = (int)Long.valueOf(reply[j]).longValue();
        }
        return values;
    }

    public synchronized String[] getHeaderRecord() throws DriverException {
        this.checkOpen();
        this.send("#H,R,0;");
        return this.receive("h", 18);
    }

    public synchronized int getLoggedData() throws DriverException {
        this.checkOpen();
        this.send("#D,R,0;");
        this.receive("n", 3);
        int count = this.nDataSent;
        while (true) {
            try {
                return Integer.valueOf(this.receive("l", 2)[1]);
            }
            catch (DriverException e) {
                if (this.nDataSent == count) {
                    throw e;
                }
                count = this.nDataSent;
                continue;
            }
            break;
        }
    }

    public synchronized int setInternalLogging(int interval) throws DriverException {
        this.checkOpen();
        this.send("#L,W,3,_,I," + interval + ";");
        return Integer.valueOf(this.receive("s", 3)[1]);
    }

    public void setExternalLogging(int interval) throws DriverException {
        this.checkOpen();
        this.send("#L,W,3,_,E," + interval + ";");
    }

    public synchronized int getRecordLimit() throws DriverException {
        this.checkOpen();
        this.send("#N,R,0;");
        return Integer.valueOf(this.receive("n", 1)[0]);
    }

    public synchronized int getFullOption() throws DriverException {
        this.checkOpen();
        this.send("#O,R,0;");
        return Integer.valueOf(this.receive("o", 1)[0]);
    }

    public void setFullOption(int option) throws DriverException {
        this.checkOpen();
        this.send("#O,W,1," + option + ";");
    }

    public void resetMemory() throws DriverException {
        this.checkOpen();
        this.send("#R,W,0;");
    }

    public synchronized int getLoggingInterval() throws DriverException {
        this.checkOpen();
        this.send("#S,R,0;");
        return Integer.valueOf(this.receive("s", 3)[1]);
    }

    public synchronized int getLoggingState() throws DriverException {
        this.checkOpen();
        this.send("#S,R,0;");
        return Integer.valueOf(this.receive("s", 3)[2]);
    }

    public void setLoggingInterval(int interval) throws DriverException {
        this.checkOpen();
        this.send("#S,W,2,_," + interval + ";");
    }

    public synchronized double getUserRate() throws DriverException {
        this.checkOpen();
        this.send("#U,R,0;");
        return Double.valueOf(this.receive("u", 3)[0]) / 1000.0;
    }

    public synchronized int getUserThreshold() throws DriverException {
        this.checkOpen();
        this.send("#U,R,0;");
        return Integer.valueOf(this.receive("u", 3)[1]);
    }

    public synchronized boolean getUserEuro() throws DriverException {
        this.checkOpen();
        this.send("#U,R,0;");
        return !this.receive("u", 3)[2].equals("0");
    }

    public void setUserParameters(double rate, int threshold, boolean euro) throws DriverException {
        this.checkOpen();
        this.send("#U,W,3," + (int)(1000.0 * rate + 0.5) + "," + threshold + "," + (euro ? "1" : "0") + ";");
    }

    public synchronized String[] getVersionData() throws DriverException {
        this.checkOpen();
        this.send("#V,R,0;");
        return this.receive("v", 8);
    }

    public void restart() throws DriverException {
        this.checkOpen();
        this.send("#V,W,0;");
    }

    private void send(String cmnd) throws DriverException {
        this.writeBytes(cmnd.getBytes());
    }

    private String[] receive(String id, int nFlds) throws DriverException {
        return this.receive(id, nFlds, 2000);
    }

    private String[] receive(String id, int nFlds, int timeout) throws DriverException {
        Object reply;
        String[] head;
        do {
            reply = null;
            try {
                reply = this.replyQ.poll(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (reply == null) {
                throw new DriverTimeoutException("Read timed out");
            }
            if (!(reply instanceof DriverException)) continue;
            throw (DriverException)reply;
        } while ((head = ((String)reply).split(",", 4)).length < 4 || !head[0].equals(id) || Integer.valueOf(head[2]) != nFlds);
        return head.length < 4 ? null : head[3].split(",");
    }

    private void sendListener(String reply) {
        ++this.nDataSent;
        if (this.listener == null) {
            return;
        }
        String[] fields = reply.split(",");
        double[] values = new double[18];
        for (int j = 0; j < 18; ++j) {
            String field = fields[j + 3];
            if (field.equals("_")) {
                values[j] = 0.0;
                continue;
            }
            int temp = Integer.valueOf(field);
            values[j] = j == 2 || j == 9 || j == 12 || j == 4 || j == 6 ? (double)temp / 1000.0 : (j == 5 || j == 15 ? (double)temp : (j == 13 || j == 14 ? (double)temp / 100.0 : (double)temp / 10.0));
        }
        this.listener.processData(values);
    }

    private void checkOpen() throws DriverException {
        if (!this.open) {
            throw new DriverException("Device not open");
        }
    }

    public static interface Listener {
        public void processData(double[] var1);

        public void setPowered(boolean var1);

        public void setClosed();
    }

    private class CheckPower
    extends TimerTask {
        private CheckPower() {
        }

        @Override
        public void run() {
            block5: {
                if (WattsUp.this.open) {
                    try {
                        WattsUp.this.getRecordLimit();
                        if (!WattsUp.this.powered) {
                            WattsUp.this.powered = true;
                            if (WattsUp.this.listener != null) {
                                WattsUp.this.listener.setPowered(WattsUp.this.powered);
                            }
                        }
                    }
                    catch (DriverException e) {
                        if (!(e instanceof DriverTimeoutException) || !WattsUp.this.powered) break block5;
                        WattsUp.this.powered = false;
                        if (WattsUp.this.listener == null) break block5;
                        WattsUp.this.listener.setPowered(WattsUp.this.powered);
                    }
                }
            }
        }
    }

    private class Reader
    extends Thread {
        private final byte HASH = (byte)35;
        private final byte SEMIC = (byte)59;
        private final byte DATA_ID = (byte)100;
        private int buffCurr;
        private int recdStart = -1;
        private int recdEnd = -1;
        private int recdCurr;
        private Exception excp;

        private Reader() {
        }

        @Override
        public void run() {
            block18: {
                byte[] buff = new byte[1024];
                while (true) {
                    int leng;
                    try {
                        leng = WattsUp.this.readBytes(buff, this.buffCurr);
                        this.buffCurr += leng;
                    }
                    catch (DriverTimeoutException e) {
                        if (WattsUp.this.open) continue;
                    }
                    catch (DriverException e) {
                        this.excp = e;
                    }
                    if (this.excp != null || !WattsUp.this.open) break;
                    while (this.recdCurr < this.buffCurr) {
                        while (this.recdStart < 0 && this.recdCurr < this.buffCurr) {
                            if (buff[this.recdCurr++] != 35) continue;
                            this.recdStart = this.recdCurr;
                        }
                        while (this.recdEnd < 0 && this.recdCurr < this.buffCurr) {
                            if (buff[this.recdCurr++] != 59) continue;
                            this.recdEnd = this.recdCurr - 1;
                        }
                        if (this.recdStart < 0 || this.recdEnd < 0) break;
                        byte recdId = buff[this.recdStart];
                        if (recdId != 100 || WattsUp.this.listener != null) {
                            String record = new String(buff, this.recdStart, this.recdEnd - this.recdStart);
                            if (recdId == 100) {
                                WattsUp.this.sendListener(record);
                            } else {
                                WattsUp.this.replyQ.offer(record);
                            }
                        }
                        this.recdStart = -1;
                        this.recdEnd = -1;
                    }
                    if (this.recdStart < 0) {
                        this.buffCurr = 0;
                        this.recdCurr = 0;
                        continue;
                    }
                    leng = this.buffCurr - this.recdStart;
                    System.arraycopy(buff, this.recdStart, buff, 0, leng);
                    this.buffCurr = leng;
                    this.recdStart = 0;
                    this.recdCurr = leng;
                }
                try {
                    WattsUp.this.closeAscii();
                }
                catch (DriverException e) {
                    if (this.excp != null) break block18;
                    this.excp = e;
                }
            }
            if (WattsUp.this.open) {
                WattsUp.this.open = false;
                WattsUp.this.powered = false;
                WattsUp.this.replyQ.clear();
                WattsUp.this.replyQ.offer(new DriverException(this.excp.getMessage()));
                if (WattsUp.this.listener != null) {
                    WattsUp.this.listener.setClosed();
                }
            } else if (this.excp == null) {
                WattsUp.this.closeQ.offer(new Object());
            } else {
                WattsUp.this.closeQ.offer(new DriverException(this.excp.getMessage()));
            }
        }
    }
}

