/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.ITLCCDType;

public final class RaftGeometryConstants {
    private final int gap_inx;
    private final int gap_iny;
    private final double gap_outx;
    private final double gap_outy;
    private final int ccd_px;
    private final int ccd_py;

    RaftGeometryConstants(int gap_inx, int gap_iny, double gap_outx, double gap_outy, int ccd_px, int ccd_py) {
        this.gap_inx = gap_inx;
        this.gap_iny = gap_iny;
        this.gap_outx = gap_outx;
        this.gap_outy = gap_outy;
        this.ccd_px = ccd_px;
        this.ccd_py = ccd_py;
    }

    public final int getGap_inx() {
        return this.gap_inx;
    }

    public final int getGap_iny() {
        return this.gap_iny;
    }

    public final double getGap_outx() {
        return this.gap_outx;
    }

    public final double getGap_outy() {
        return this.gap_outy;
    }

    public final int getRaftx() {
        return 3 * this.ccd_px + 2 * this.getGap_inx() + (int)(2.0 * this.getGap_outx());
    }

    public final int getRafty() {
        return 3 * this.ccd_py + 2 * this.getGap_iny() + (int)(2.0 * this.getGap_outy());
    }

    protected final int getPhysicalAreaParallelSize() {
        return this.ccd_px;
    }

    static RaftGeometryConstants createRaftGeometryConstants(CCDType type) {
        if (type instanceof E2VCCDType) {
            return new RaftGeometryConstants(28, 25, 26.5, 25.0, type.getCCDGeometryConstants().getPhysicalAreaParallelSize(), type.getCCDGeometryConstants().getPhysicalAreaSerialSize());
        }
        if (type instanceof ITLCCDType) {
            return new RaftGeometryConstants(27, 27, 26.0, 26.0, type.getCCDGeometryConstants().getPhysicalAreaParallelSize(), type.getCCDGeometryConstants().getPhysicalAreaSerialSize());
        }
        throw new IllegalArgumentException("Could not build RaftGeometryConstats for type " + type);
    }
}

