/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import org.lsst.ccs.subsystem.metrology.AerotechP165Device;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;

public class AerotechP165DeviceSim
extends AerotechP165Device {
    private double x;
    private double y;
    private double z;
    private double speed = 100.0;
    private double rampRate;

    @Override
    protected void initDevice() {
        this.fullName = "Simulated AerotechP165";
    }

    @Override
    protected void initialize() {
        this.setOnline(true);
        this.initSensors();
        this.kstate = MetrologyState.pwrstates.OK;
        this.log.info((Object)("Connected to " + this.fullName));
    }

    @Override
    protected void close() {
        this.kstate = MetrologyState.pwrstates.NOTCONFIGURED;
    }

    @Override
    public String getVersion() {
        return "Simulated 1.0";
    }

    @Override
    public void abort() {
    }

    @Override
    public void enableAxes() {
        this.log.info((Object)"Enabling X axis");
        this.log.info((Object)"Enabling Y axis");
        this.log.info((Object)"Enabling Z axis");
    }

    @Override
    public void disableAxes() {
        this.log.info((Object)"Disabling X axis");
        this.log.info((Object)"Disabling Y axis");
        this.log.info((Object)"Disabling Z axis");
    }

    @Override
    public void setSpeed(double velocity) {
        this.speed = velocity;
    }

    @Override
    public void rampRate(double rate) {
        this.rampRate = rate;
    }

    @Override
    public void moveIncX(double dx) {
        long time = Math.abs((long)(dx / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.x += dx;
    }

    @Override
    public void moveIncY(double dy) {
        long time = Math.abs((long)(dy / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.y += dy;
    }

    @Override
    public void moveIncZ(double dz) {
        long time = Math.abs((long)(dz / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.z += dz;
    }

    @Override
    public void moveIncXY(double dx, double dy) {
        long time = Math.abs((long)((dx + dy) / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.x += dx;
        this.y += dy;
    }

    @Override
    public void moveIncXYZ(double dx, double dy, double dz) {
        long time = Math.abs((long)((dx + dy + dz) / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    @Override
    public void moveAbsX(double xpos) {
        long time = Math.abs((long)(Math.abs(xpos - this.x) / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.x = xpos;
    }

    @Override
    public void moveAbsY(double ypos) {
        long time = Math.abs((long)(Math.abs(ypos - this.y) / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.y = ypos;
    }

    @Override
    public void moveAbsZ(double zpos) {
        long time = Math.abs((long)(Math.abs(zpos - this.z) / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.z = zpos;
    }

    @Override
    public void moveAbsXY(double xpos, double ypos) {
        long time = Math.abs((long)((Math.abs(ypos - this.y) + Math.abs(xpos - this.x)) / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.x = xpos;
        this.y = ypos;
    }

    @Override
    public void moveAbsXYZ(double xpos, double ypos, double zpos) {
        long time = Math.abs((long)((Math.abs(ypos - this.y) + Math.abs(xpos - this.x) + Math.abs(zpos - this.z)) / this.speed * 1000.0));
        try {
            Thread.sleep(time / 10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.x = xpos;
        this.y = ypos;
        this.z = zpos;
    }

    @Override
    public double getPosX() {
        this.lastPosx = this.x - this.xOffset;
        return this.lastPosx;
    }

    @Override
    public double getPosY() {
        this.lastPosy = this.y - this.yOffset;
        return this.lastPosy;
    }

    @Override
    public double getPosZ() {
        this.lastPosz = this.z - this.zOffset;
        return this.lastPosz;
    }

    @Override
    public String getError() {
        return "Simulation error";
    }

    @Override
    public void goHome() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    @Override
    public void setupHome(int mode) {
    }

    @Override
    public void softLowLim(String axis, int param) {
    }

    @Override
    public void softHighLim(String axis, int param) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void fullreset() {
    }

    @Override
    public void reconnect() {
    }

    @Override
    public String aerotechChat(String command) {
        return command;
    }
}

