/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;

public class FitsDate {
    private static final Logger LOG = Logger.getLogger(FitsDate.class.getName());
    private static final int FIRST_THREE_CHARACTER_VALUE = 100;
    private static final int FIRST_TWO_CHARACTER_VALUE = 10;
    private static final int FITS_DATE_STRING_SIZE = 23;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final int NEW_FORMAT_DAY_OF_MONTH_GROUP = 4;
    private static final int NEW_FORMAT_HOUR_GROUP = 6;
    private static final int NEW_FORMAT_MILLISECOND_GROUP = 10;
    private static final int NEW_FORMAT_MINUTE_GROUP = 7;
    private static final int NEW_FORMAT_MONTH_GROUP = 3;
    private static final int NEW_FORMAT_SECOND_GROUP = 8;
    private static final int NEW_FORMAT_YEAR_GROUP = 2;
    private static final Pattern NORMAL_REGEX = Pattern.compile("\\s*(([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9]))(T([0-9][0-9]):([0-9][0-9]):([0-9][0-9])(\\.([0-9][0-9][0-9]|[0-9][0-9]))?)?\\s*");
    private static final int OLD_FORMAT_DAY_OF_MONTH_GROUP = 1;
    private static final int OLD_FORMAT_MONTH_GROUP = 2;
    private static final int OLD_FORMAT_YEAR_GROUP = 3;
    private static final Pattern OLD_REGEX = Pattern.compile("\\s*([0-9][0-9])/([0-9][0-9])/([0-9][0-9])\\s*");
    private static final int TWO_DIGIT_MILISECONDS_FACTOR = 10;
    private static final int YEAR_OFFSET = 1900;
    private Date date = null;
    private int hour = -1;
    private int mday = -1;
    private int millisecond = -1;
    private int minute = -1;
    private int month = -1;
    private int second = -1;
    private int year = -1;

    public static String getFitsDateString() {
        return FitsDate.getFitsDateString(new Date(), true);
    }

    public static String getFitsDateString(Date epoch) {
        return FitsDate.getFitsDateString(epoch, true);
    }

    public static String getFitsDateString(Date epoch, boolean timeOfDay) {
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTime(epoch);
        StringBuffer fitsDate = new StringBuffer();
        DecimalFormat df = new DecimalFormat("0000");
        fitsDate.append(df.format(cal.get(1)));
        fitsDate.append("-");
        df = new DecimalFormat("00");
        fitsDate.append(df.format(cal.get(2) + 1));
        fitsDate.append("-");
        fitsDate.append(df.format(cal.get(5)));
        if (timeOfDay) {
            fitsDate.append("T");
            fitsDate.append(df.format(cal.get(11)));
            fitsDate.append(":");
            fitsDate.append(df.format(cal.get(12)));
            fitsDate.append(":");
            fitsDate.append(df.format(cal.get(13)));
            fitsDate.append(".");
            df = new DecimalFormat("000");
            fitsDate.append(df.format(cal.get(14)));
        }
        return fitsDate.toString();
    }

    public FitsDate(String dStr) throws FitsException {
        if (dStr == null || dStr.isEmpty()) {
            return;
        }
        Matcher match = NORMAL_REGEX.matcher(dStr);
        if (match.matches()) {
            this.year = this.getInt(match, 2);
            this.month = this.getInt(match, 3);
            this.mday = this.getInt(match, 4);
            this.hour = this.getInt(match, 6);
            this.minute = this.getInt(match, 7);
            this.second = this.getInt(match, 8);
            this.millisecond = this.getMilliseconds(match, 10);
        } else {
            match = OLD_REGEX.matcher(dStr);
            if (match.matches()) {
                this.year = this.getInt(match, 3) + 1900;
                this.month = this.getInt(match, 2);
                this.mday = this.getInt(match, 1);
            } else {
                if (dStr.trim().isEmpty()) {
                    return;
                }
                throw new FitsException("Bad FITS date string \"" + dStr + '\"');
            }
        }
    }

    private int getInt(Matcher match, int groupIndex) {
        String value = match.group(groupIndex);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    private int getMilliseconds(Matcher match, int groupIndex) {
        String value = match.group(groupIndex);
        if (value != null) {
            int result = Integer.parseInt(value);
            if (value.length() == 2) {
                result *= 10;
            }
            return result;
        }
        return -1;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public Date toDate() {
        if (this.date == null && this.year != -1) {
            Calendar cal = Calendar.getInstance(GMT);
            cal.set(1, this.year);
            cal.set(2, this.month - 1);
            cal.set(5, this.mday);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "At this point:" + cal.getTime());
            }
            if (this.hour == -1) {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "2At this point:" + cal.getTime());
                }
            } else {
                cal.set(11, this.hour);
                cal.set(12, this.minute);
                cal.set(13, this.second);
                if (this.millisecond == -1) {
                    cal.set(14, 0);
                } else {
                    cal.set(14, this.millisecond);
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "3At this point:" + cal.getTime());
                }
            }
            this.date = cal.getTime();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "  date:" + this.date);
            LOG.log(Level.FINEST, "  year:" + this.year);
            LOG.log(Level.FINEST, "  month:" + this.month);
            LOG.log(Level.FINEST, "  mday:" + this.mday);
            LOG.log(Level.FINEST, "  hour:" + this.hour);
        }
        return this.date;
    }

    public String toString() {
        if (this.year == -1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(23);
        buf.append(this.year);
        buf.append('-');
        this.appendTwoDigitValue(buf, this.month);
        buf.append('-');
        this.appendTwoDigitValue(buf, this.mday);
        if (this.hour != -1) {
            buf.append('T');
            this.appendTwoDigitValue(buf, this.hour);
            buf.append(':');
            this.appendTwoDigitValue(buf, this.minute);
            buf.append(':');
            this.appendTwoDigitValue(buf, this.second);
            if (this.millisecond != -1) {
                buf.append('.');
                this.appendThreeDigitValue(buf, this.millisecond);
            }
        }
        return buf.toString();
    }

    private void appendThreeDigitValue(StringBuffer buf, int value) {
        if (value < 100) {
            buf.append('0');
        }
        this.appendTwoDigitValue(buf, value);
    }

    private void appendTwoDigitValue(StringBuffer buf, int value) {
        if (value < 10) {
            buf.append('0');
        }
        buf.append(value);
    }
}

