/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keyence;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class KeyenceG5001
extends Ascii {
    public static double timeout = 200.0;
    public static final int DEFAULT_BAUD = 38400;
    public static final String DEFAULT_DEV = "/dev/ttyS1";
    MODE kmode = MODE.GEN;
    private final String terminator = "\r";
    private byte[] buff = new byte[1024];
    private int buffIn;
    private int buffOut;
    private static final Map<String, String> errors = new HashMap<String, String>();
    private static final ReentrantLock KeyLock = new ReentrantLock();

    public KeyenceG5001() throws DriverException {
        errors.put("01", "Command");
        errors.put("02", "Parity");
        errors.put("03", "Receive buffer full");
        errors.put("04", "Send buffer full");
        errors.put("05", "Framing");
        errors.put("20", "Command length");
        errors.put("21", "Parameter count");
        errors.put("22", "Invalid parameter");
        errors.put("60", "Invalid parameter");
        errors.put("88", "Timeout");
        errors.put("99", "Other");
    }

    public void open(String devname, int port) throws DriverException {
        this.open(2, devname, port);
        this.setTimeout(timeout);
    }

    public void openserial(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the Keyence Controller");
        this.open(2, serialname, port);
        this.setTimeout(timeout);
        this.setTerminator("\r");
        this.writeKeyenceG5001("R0");
    }

    public void openftdi(String serialname, int port) throws DriverException {
        System.out.println("openning connection to the Keyence Controller");
        this.setTerminator("\r");
        this.open(1, serialname, port);
        this.setTimeout(timeout);
    }

    public void opennet(String netaddress, int port) throws DriverException {
        System.out.println("opening connection to the Keyence Controller");
        this.setTerminator("\r");
        this.genmode();
        this.setTimeout(timeout);
        this.open(0, netaddress, port);
    }

    public void close() throws DriverException {
        super.close();
    }

    public String getVersion() throws DriverException {
        return this.readKeyenceG5001("VERSION");
    }

    public void laser(boolean laserstate) throws DriverException {
        if (laserstate) {
            this.genmode();
        } else {
            this.commmode();
        }
    }

    public void reset() throws DriverException {
        this.writeKeyenceG5001("ACKNOWLEDGEALL");
    }

    public void commmode() throws DriverException {
        this.readKeyenceG5001("Q0");
        this.kmode = MODE.COMM;
    }

    public void genmode() throws DriverException {
        this.readKeyenceG5001("R0");
        this.kmode = MODE.GEN;
    }

    public int getnsamps() throws DriverException {
        return this.KeyIntCommand("SR,CA", -1);
    }

    public void setnsamps(int cycle) throws DriverException {
        this.writeKeyenceG5001("SW,CA," + cycle);
    }

    public void setmeasmode(int mode) throws DriverException {
        this.writeKeyenceG5001("SW,HB,M," + mode);
    }

    public void setmindispunit(int dspu) throws DriverException {
        this.writeKeyenceG5001("SW,OG,01," + dspu);
        this.writeKeyenceG5001("SW,OG,02," + dspu);
    }

    public double read(int ikey) throws DriverException {
        return this.KeyDblCommand("MS", ikey)[0];
    }

    public double[] readAll() throws DriverException {
        return this.KeyDblCommand("MA");
    }

    public synchronized void writeKeyenceG5001(String command) throws DriverException {
        this.write(command + "\r");
    }

    public synchronized String readKeyenceG5001() throws DriverException {
        return this.read();
    }

    public synchronized String readKeyenceG5001(String command) throws DriverException {
        this.writeKeyenceG5001(command + "\r");
        String response = null;
        double starttim = System.currentTimeMillis();
        while ((double)System.currentTimeMillis() - starttim < timeout && !(response = this.readKeyenceG5001()).contains(command)) {
        }
        return response;
    }

    private int KeyIntCommand(String command) throws DriverException {
        return this.KeyIntCommand(command, -1, null);
    }

    private int KeyIntCommand(String command, int ikey) throws DriverException {
        return this.KeyIntCommand(command, ikey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int KeyIntCommand(String command, int ikey, String setval) throws DriverException {
        int value = 0;
        String rply = null;
        String cmnd = command;
        if (ikey > 0) {
            cmnd = cmnd + ",0" + ikey;
        }
        int cmndlen = cmnd.length();
        if (setval != null) {
            cmnd = cmnd + "," + setval;
        }
        try {
            KeyLock.lock();
            System.out.println("Keyence command = " + cmnd);
            rply = this.readKeyenceG5001(cmnd);
            System.out.println("Keyence reply = " + rply);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
        value = 0;
        if (rply != null) {
            if (rply.contains(command) && !rply.split(",")[0].contains("ER")) {
                try {
                    value = Integer.decode(rply.substring(cmndlen + 1).split(",")[0]);
                }
                catch (Exception ex) {
                    System.out.println("KeyenceG5001: unparsable reply - " + ex);
                }
            } else {
                System.out.println("KeyenceG5001: invalid reply. command not contained in reply!");
                int rlen = rply.split(",").length;
                if (rply.split(",")[0].contains("ER")) {
                    String errmsg = errors.get(rply.split(",")[rlen - 1]);
                    if (errmsg != null) {
                        System.out.println("KeyenceG5001: error code corresponds to " + errmsg);
                    } else {
                        System.out.println("Unrecognized error code. Reply = " + rply);
                    }
                }
            }
        }
        return value;
    }

    private double[] KeyDblCommand(String command) throws DriverException {
        return this.KeyDblCommand(command, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] KeyDblCommand(String command, int ikey) throws DriverException {
        double[] value = new double[]{-999.0, -999.0, -999.0, -999.0, -999.0};
        String rply = null;
        String cmnd = command;
        if (ikey > 0) {
            cmnd = cmnd + ",0" + ikey;
        }
        int cmndlen = cmnd.length();
        try {
            KeyLock.lock();
            System.out.println("Keyence command = " + cmnd);
            rply = this.readKeyenceG5001(cmnd);
            System.out.println("Keyence reply = " + rply);
        }
        finally {
            if (KeyLock.isHeldByCurrentThread()) {
                KeyLock.unlock();
            }
        }
        if (rply != null) {
            if (rply.contains(command) && !rply.split(",")[0].contains("ER")) {
                System.out.println("reply with command removed = " + rply.substring(cmndlen + 1) + "\n It has length = " + rply.substring(cmndlen + 1).split(",").length);
                try {
                    for (int i = 0; i < rply.substring(cmndlen + 1).split(",").length; ++i) {
                        value[i] = Double.parseDouble(rply.substring(cmndlen + 1).split(",")[i]);
                    }
                }
                catch (Exception ex) {
                    System.out.println("KeyenceG5001: unparsable reply - " + ex);
                }
            } else {
                String[] rsplit = rply.split(",");
                int rlen = rsplit.length;
                System.out.println("KeyenceG5001: invalid reply. command not contained in reply!");
                if (rsplit[0].contains("ER")) {
                    String hashkey = rsplit[rlen - 1];
                    System.out.println("hash key = " + hashkey);
                    String errmsg = errors.get(rsplit[rlen - 1]);
                    if (errmsg != null) {
                        System.out.println("KeyenceG5001: error code corresponds to " + errmsg);
                    } else {
                        System.out.println("Unrecognized error code. Reply = " + rply);
                    }
                }
            }
        }
        return value;
    }

    static enum MODE {
        NONE,
        COMM,
        GEN;

    }
}

