/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.monitor.Device;

public class CCOBDevice
extends Device {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private CCOBCommands driver;
    private CCOBDataRead readValues;

    protected void initialize() {
        this.setOnline(true);
    }

    public void readChannelGroup() {
        try {
            this.readValues = this.driver.getAdcValues();
        }
        catch (Exception ex) {
            this.log.error((Object)"error reading channel group", (Throwable)ex);
            throw new RuntimeException("cannot read channels", ex);
        }
    }

    public double readChannel(int hwChan, int type) {
        switch (hwChan) {
            case 0: {
                return this.readValues.getLedVoltage();
            }
            case 1: {
                return this.readValues.getLedCurrent();
            }
            case 2: {
                return this.readValues.getLedVref();
            }
            case 3: {
                return this.readValues.getTempLed1();
            }
            case 4: {
                return this.readValues.getTempLed2();
            }
            case 5: {
                return this.readValues.getPhotodiodeCurrent();
            }
            case 6: {
                return this.readValues.getTempSphere();
            }
            case 7: {
                return this.readValues.getTempBrd();
            }
        }
        return Double.NaN;
    }

    protected void close() {
    }
}

