/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.teststand.APC7900Device;
import org.lsst.ccs.subsystem.teststand.data.TSState;

public class APC7900SimDevice
extends APC7900Device {
    private int onStates = 0;

    @Override
    protected void initDevice() {
        this.outNumMap = new HashMap();
        this.fullName = "Simulated APC7900 PDU";
    }

    @Override
    protected void initialize() {
        this.outNums = new int[this.outlets.size()];
        this.initSensors();
        this.setOnline(true);
        this.kstate = TSState.pwrstates.OK;
        this.sLog.info((Object)("Connected to " + this.fullName));
        this.inited = true;
    }

    @Override
    protected void close() {
        this.kstate = TSState.pwrstates.NOTCONFIGURED;
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int[] typeSubtype = super.checkChannel(name, hwChan, type, subtype);
        if ((typeSubtype[0] & 0xFFFF) == 0) {
            this.outNumMap.put(subtype, this.outlets.size());
        }
        return typeSubtype;
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        double value = 0.0;
        switch (type & 0xFFFF) {
            case 0: {
                int outNum = this.outNums[type >> 16];
                value = this.onStates >> outNum & 1;
                break;
            }
            case 1: {
                value = hwChan == 1 ? 1650.0 : 15.0;
            }
        }
        return value;
    }

    @Override
    @Command(name="getOutletOnStateMap", description="Get the map of outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        HashMap<String, Boolean> onStateMap = new HashMap<String, Boolean>();
        Iterator iterator = this.outNumMap.keySet().iterator();
        while (iterator.hasNext()) {
            String oName;
            onStateMap.put(oName, (1 << (Integer)this.outNumMap.get(oName = (String)iterator.next()) & this.onStates) != 0);
        }
        return onStateMap;
    }

    @Override
    @Command(name="outletOn", description="Turn outlet on")
    public void outletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.onStates |= 1 << this.getOutletNumber(name);
    }

    @Override
    @Command(name="outletOff", description="Turn outlet off")
    public void outletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.onStates &= ~(1 << this.getOutletNumber(name));
    }

    @Override
    @Command(name="forceOutletOn", description="Force outlet to turn on")
    public void forceOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.outletOn(name);
    }

    @Override
    @Command(name="forceOutletOff", description="Force outlet to turn off")
    public void forceOutletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.outletOff(name);
    }

    @Override
    @Command(name="isOutletOn", description="Get whether outlet is on")
    public boolean isOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        return (this.onStates & 1 << this.getOutletNumber(name)) != 0;
    }
}

