/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.LocalConfigService;
import org.lsst.ccs.utilities.logging.Logger;

public class EmailSender {
    private static final Logger log = Logger.getLogger((String)EmailSender.class.getName());
    private final LocalConfigService config;
    private final AlertService alertService;
    private final Map<String, Instant> sendingTimes;
    private static final Duration NO_SPAM = Duration.ofMinutes(60L);

    public EmailSender(LocalConfigService config, AlertService alertService) {
        this.config = config;
        this.alertService = alertService;
        this.sendingTimes = new HashMap<String, Instant>();
    }

    public void send(String subject, Throwable exc) {
        this.sendingTimes.putIfAbsent(subject, Instant.MIN);
        Duration elapsed = Duration.between(this.sendingTimes.get(subject), Instant.now());
        try {
            String[] recipients = this.config.getEmailRecipients().toArray(new String[0]);
            if (recipients.length > 0 && elapsed.compareTo(NO_SPAM) > 0) {
                this.sendingTimes.put(subject, Instant.now());
                SimpleEmail emsg = new SimpleEmail();
                emsg.setHostName(this.config.getSMTPServer());
                emsg.setFrom(this.config.getEmailSender());
                emsg.setBounceAddress(this.config.getEmailBounceAddress());
                emsg.addReplyTo(this.config.getEmailBounceAddress());
                emsg.setSubject("[Airwatch] " + subject);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exc.printStackTrace(pw);
                ((Email)emsg).setMsg(sw.toString());
                emsg.addTo(recipients);
                emsg.send();
            }
        }
        catch (EmailException mailExc) {
            String summary = "Error composing or sending email.";
            log.error((Object)"Error composing or sending email.", (Throwable)mailExc);
            this.alertService.raiseAlert(Alerts.emailDeliveryAlert(), AlertState.WARNING, "Error composing or sending email.");
        }
    }
}

