/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ts8;

import org.lsst.ccs.subsystem.ts8.TS8Subsystem;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

class TS8FitsHeaderMetadataProvider
implements FitsHeaderMetadataProvider {
    private final TS8Subsystem ts8Subsystem;
    private final MetaDataSet metaDataSet;

    TS8FitsHeaderMetadataProvider(TS8Subsystem ts8Subsystem, MetaDataSet metaDataSet) {
        this.ts8Subsystem = ts8Subsystem;
        this.metaDataSet = metaDataSet;
    }

    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        return this.getTS8MetaDataSet(imageSet);
    }

    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        return this.getTS8MetaDataSet(imageSet);
    }

    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        return this.getTS8MetaDataSet(imageSet);
    }

    private synchronized MetaDataSet getTS8MetaDataSet(ImageSet imageSet) {
        MetaDataSet m = new MetaDataSet();
        m.addMetaDataSet(this.metaDataSet);
        m.addMetaDataMap("TS8SpecificKeywords", this.ts8Subsystem.getPrimaryHeaderKeywordsMapForCCD(imageSet.getCCD().getUniqueId()));
        m.addMetaData("CCDInfo", "CCDManufacturer", (Object)imageSet.getCCD().getType().getName().toUpperCase());
        m.addMetaData("CCDInfo", "CCDModel", (Object)imageSet.getCCD().getType().getType());
        return m;
    }
}

