/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.main.CheckException;

public class Axis {
    private String axisName;
    private int index;
    private String units;
    @ConfigurationParameter(description="The speed limit in axis units/sec.")
    private volatile double maxSpeed;
    @ConfigurationParameter(description="The furthest the axis can travel, end to end, in axis units.")
    private volatile double maxTravel;

    public String getName() {
        return this.axisName;
    }

    public int getIndex() {
        return this.index;
    }

    public String getUnits() {
        return this.units;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public double getMaxTravel() {
        return this.maxTravel;
    }

    public boolean isAtHome(AerotechPro165 aero) {
        return Status.HOMED.isSetIn(this.getStatusMask(aero));
    }

    public AxisStatus getStatus(AerotechPro165 aero) {
        long statusMask = this.getStatusMask(aero);
        long faultMask = this.getFaultMask(aero);
        boolean enabled = Status.ENABLED.isSetIn(statusMask);
        boolean moving = Status.MOVING.isSetIn(statusMask);
        boolean atLow = Fault.HARD_EOT_LOW.isSetIn(faultMask);
        boolean atHigh = Fault.HARD_EOT_HIGH.isSetIn(faultMask);
        boolean homed = Status.HOMED.isSetIn(statusMask);
        double position = this.getPosition(aero);
        List<String> faults = this.getFaultList(statusMask, faultMask);
        AxisStatus status = new AxisStatus(this.axisName, enabled, moving, homed, atLow, atHigh, faults, position);
        return status;
    }

    private double getPosition(AerotechPro165 aero) {
        try {
            return aero.readDoubleAP("PFBKPROG(" + this.getName() + ")");
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    private List<String> getFaultList(long statusMask, long faultMask) {
        ArrayList<String> faults = new ArrayList<String>();
        if (!Status.BRAKED.isSetIn(statusMask)) {
            faults.add("BRAKE SET");
        }
        faults.addAll(Arrays.stream(Fault.values()).filter(f -> f.isSetIn(faultMask)).map(Fault::toString).collect(Collectors.toList()));
        return faults;
    }

    private long getStatusMask(AerotechPro165 aero) {
        try {
            return (long)aero.readDoubleAP("AXISSTATUS(" + this.getName() + ")");
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    private long getFaultMask(AerotechPro165 aero) {
        try {
            return (long)aero.readDoubleAP("AXISFAULT(" + this.getName() + ")");
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public void moveRelative(AerotechPro165 aero, MoveAxisRelative cmd) {
        double d = cmd.getDistance();
        double t = (double)cmd.getTime().toMillis() / 1000.0;
        double v = Math.abs(d) / (t - 0.2);
        v = Math.min(v, this.maxSpeed);
        double a = 10.0 * v;
        try {
            aero.writeAP("DGLOBAL(0) = " + this.index);
            aero.writeAP("DGLOBAL(1) = " + d);
            aero.writeAP("DGLOBAL(2) = " + v);
            aero.writeAP("DGLOBAL(3) = " + a);
            aero.writeAP("DGLOBAL(4) = " + (Math.abs(d) / v + 0.2));
            aero.writeAP("DGLOBAL(5) = 0");
            aero.writeAP("PROGRAM RUN 1, \"Move.bcx\"");
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public Duration getRelativeMoveTimeout(MoveAxisRelative cmd) {
        double d = Math.abs(cmd.getDistance());
        double t = (double)cmd.getTime().toMillis() / 1000.0;
        double v = d / (t - 0.2);
        v = Math.min(v, this.maxSpeed);
        return Duration.ofMillis(Math.round(1000.0 * (d / v + 0.2)));
    }

    public void moveAbsolute(AerotechPro165 aero, MoveAxisAbsolute cmd) {
        double d = cmd.getPosition();
        double v = Math.min(cmd.getSpeed(), this.maxSpeed);
        double a = 10.0 * v;
        double t = (double)this.getAbsoluteMoveTimeout(cmd).toMillis() / 1000.0;
        try {
            aero.writeAP("DGLOBAL(0) = " + this.index);
            aero.writeAP("DGLOBAL(1) = " + d);
            aero.writeAP("DGLOBAL(2) = " + v);
            aero.writeAP("DGLOBAL(3) = " + a);
            aero.writeAP("DGLOBAL(4) = " + t);
            aero.writeAP("DGLOBAL(5) = 1");
            aero.writeAP("PROGRAM RUN 1, \"Move.bcx\"");
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public Duration getAbsoluteMoveTimeout(MoveAxisAbsolute cmd) {
        double d = Math.max(cmd.getPosition(), this.maxTravel - cmd.getPosition());
        double v = Math.min(cmd.getSpeed(), this.maxSpeed);
        return Duration.ofMillis(Math.round(1000.0 * (d / v + 2.0)));
    }

    public int getMoveCompletionCode(AerotechPro165 aero) {
        try {
            return (int)aero.readDoubleAP("DGLOBAL(0)");
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public void clearFaults(AerotechPro165 aero) {
        try {
            aero.writeAP("FAULTACK " + this.getName());
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public boolean hasFaults(AerotechPro165 aero) {
        return 0L != this.getFaultMask(aero);
    }

    public Duration getHomingTimeout() {
        return Duration.ofMillis((long)(1000.0 * this.maxTravel / this.maxSpeed));
    }

    public int getHomingCompletionCode(AerotechPro165 aero) {
        return 0;
    }

    public void home(AerotechPro165 aero) {
        try {
            aero.writeAP("HOME CONDITIONAL " + this.getName());
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public void enable(AerotechPro165 aero) {
        try {
            aero.writeAP("ENABLE " + this.getName());
            long status = (long)aero.readDoubleAP("AXISSTATUS(" + this.getName() + ")");
            if (!Status.ENABLED.isSetIn(status)) {
                throw new CheckException("EN FAIL", String.format("Enable of %s axis failed.", this.axisName));
            }
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public void disable(AerotechPro165 aero) {
        try {
            aero.writeAP("DISABLE " + this.getName());
            long status = (long)aero.readDoubleAP("AXISSTATUS(" + this.getName() + ")");
            if (Status.ENABLED.isSetIn(status)) {
                throw new CheckException("DIS FAIL", String.format("Disable of %s axis failed.", this.axisName));
            }
        }
        catch (DriverException ex) {
            throw new Error(ex);
        }
    }

    public boolean hasESTOP(AerotechPro165 aero) {
        return Fault.ESTOP.isSetIn(this.getFaultMask(aero));
    }

    private static enum Fault {
        POSITION_ERROR(0, "Position error"),
        OVER_CURRENT(1, "Too much current"),
        HARD_EOT_HIGH(2, "Hard EOT high"),
        HARD_EOT_LOW(3, "Hard EOT low"),
        SOFT_EOT_HIGH(4, "Soft EOT high"),
        SOFT_EOT_LOW(5, "Soft EOT low"),
        AMPLIFIER(6, "Amplifier"),
        POSITION_FEEDBACK(7, "Position feedback"),
        VELOCITY_FEEDBACK(8, "Velocity feedback"),
        HALL(9, "Hall sensor"),
        MAX_VELOCITY(10, "Maximum velocity"),
        ESTOP(11, "ESTOP"),
        VELOCITY_ERROR(12, "Velocity error"),
        EXTERNAL(15, "External"),
        MOTOR_TEMP(17, "Motor temperature"),
        AMP_TEMP(18, "Amplifier temperature"),
        ENCODER(19, "Encoder"),
        COMM_LOST(20, "Lost comm"),
        FEEDBACK_SCALING(23, "Feedback scaling"),
        MARK_SEARCH(24, "Mark search"),
        VOLTAGE_CLAMP(27, "Voltage clamp"),
        POWER_SUPPLY(28, "Power supply");

        private final long mask;
        private final String text;

        private Fault(int bitPos, String text) {
            this.mask = 1L << bitPos;
            this.text = text;
        }

        public boolean isSetIn(long faultMask) {
            return 0L != (faultMask & this.mask);
        }

        public String toString() {
            return this.text;
        }
    }

    private static enum Status {
        ENABLED(0),
        HOMED(1),
        MOVING(3),
        BRAKED(8),
        CW_EOT(22),
        CCW_EOT(23),
        ESTOP(31);

        private final long mask;

        private Status(int bitPos) {
            this.mask = 1L << bitPos;
        }

        public boolean isSetIn(long statusMask) {
            return 0L != (statusMask & this.mask);
        }
    }
}

