/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.metrology.KeyenceG5001Device;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;

public class KeyenceG5001DeviceSim
extends KeyenceG5001Device {
    private int ncycles;
    private int measmode;
    private int mindispunit;

    public KeyenceG5001DeviceSim(String host, int port) throws DriverException {
        super(host, port);
    }

    @Override
    protected void initialize() {
        if (this.isconnected) {
            this.log.debug((Object)"KeyenceG5001 device is already initialized");
            this.log.debug((Object)"Setting device online.");
            this.setOnline(true);
            this.kstate = MetrologyState.pwrstates.OK;
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected Keyence device!");
            this.failedToInitialize = true;
        }
    }

    @Override
    @Command(description="return controller version")
    public String getVersion() throws DriverException {
        return "Simulation 1.0";
    }

    @Override
    @Command(name="getcycles", description="get sampling cycle setting")
    public int getcycles() throws DriverException {
        return this.ncycles;
    }

    @Override
    @Command(name="setcycles", description="set number of cycles")
    public void setcycles(@Argument(name="cycles", description="sampling cycle mode") int cycles) throws DriverException {
        this.ncycles = cycles;
    }

    @Override
    @Command(name="getmeasmode", description="get mode")
    public int getmeasmode() throws DriverException {
        return this.measmode;
    }

    @Override
    @Command(name="setmeasmode", description="set mode")
    public void setmeasmode(@Argument(name="mode", description="mode number") int mode) throws DriverException {
        this.measmode = mode;
    }

    @Override
    @Command(name="setmindispunit", description="set mode")
    public void setmindispunit(@Argument(name="dspu", description="(0: 0.01 mm, 1: 0.001 mm, 2: 0.0001 mm, 3: 0.00001 mm, 4: 0.1 um, 5: 0.01 um, 6: 0.001 um)") int dspu) throws DriverException {
        this.mindispunit = dspu;
    }

    @Override
    @Command(name="readAll", description="get keyence head measurement")
    public double[] readAll() throws DriverException {
        double[] response = new double[]{1.2, 3.1};
        for (int i = 0; i < response.length; ++i) {
            this.last_read[i] = response[i];
        }
        return response;
    }

    @Override
    @Command(description="communications mode")
    public void commmode() throws DriverException {
    }

    @Override
    @Command(description="general mode")
    public void genmode() throws DriverException {
    }

    @Override
    @Command(description="clears all fault mesdsages")
    public void reset() throws DriverException {
    }

    @Override
    @Command(description="sets lasers on/off")
    public void laser(@Argument(name="laserstate", description="false for laser off / true for on") boolean laserstate) throws DriverException {
    }

    @Override
    @Command(description="generic write")
    public String keyenceChat(@Argument(name="command", description="The raw Keyence command") String command) throws DriverException {
        return command;
    }
}

