/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.RaftsCommands;
import org.lsst.ccs.subsystem.rafts.TempControl;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RaftFullState;
import org.lsst.ccs.subsystem.rafts.data.RaftState;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.states.SequencerMainState;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.logging.Logger;

public class RaftsMain
implements HasLifecycle,
HardwareController {
    private ClientFactory clientFactory = null;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<REBDevice> rebDevices = new ArrayList<REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, REBDevice> rebDevicesMap = new HashMap<String, REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private TempControl tempCtrl;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor mon;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupName
    private String name;
    private final Logger sLog = Logger.getLogger((String)this.getClass().getPackage().getName());
    private final GlobalProc globalProc = new GlobalProc();
    private RaftsCommands raftsCommands;
    private final CCDType ccdType = new E2VCCDType();
    private final Raft raftGeometry = Raft.createRaft((CCDType)this.ccdType);
    private boolean running = false;

    public void build() {
        this.raftsCommands = new RaftsCommands(this.subsys, this.rebDevices, this.globalProc, (Geometry)this.raftGeometry, this.tempCtrl);
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("sequencerMonitor", () -> this.raftsCommands.checkSequencerState()).withIsFixedRate(false).withPeriod(Duration.ofSeconds(5L)));
    }

    public void postInit() {
        this.subsys.setAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsMain.class.getCanonicalName());
        if (this.tempCtrl != null) {
            this.tempCtrl.initialize(this.sLog);
        } else {
            this.sLog.info((Object)"No temperature control available");
        }
        this.subsys.addCommandsFromObject((Object)this.raftsCommands, "");
        this.globalProc.initialize(this.rebDevices, this.clientFactory, this.sLog);
    }

    public TreeWalkerDiag checkHardware() {
        for (REBDevice devc : this.rebDevices) {
            BitSet s = new BitSet(3);
            for (int i = 0; i < 3; ++i) {
                s.set(i, (devc.getCcdMask() & 1 << i) != 0);
            }
            Reb rebGeometry = Reb.createReb((CCDType)this.ccdType, (BitSet)s);
            this.raftGeometry.addReb(rebGeometry, devc.getRebNumber());
        }
        return TreeWalkerDiag.GO;
    }

    public void postStart() {
        this.running = true;
        this.sLog.info((Object)"Rafts subsystem started");
        this.subsys.updateAgentState(new Enum[]{SequencerMainState.UNKNOWN});
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(name="value", description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        if (this.running) {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveNamedConfig(String name) throws IOException {
        if (name.isEmpty()) {
            this.sce.saveChangesForCategories(new String[]{"Rafts"});
        } else {
            this.sce.saveChangesForCategoriesAs(new String[]{"Rafts:" + name});
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load a named rafts configuration")
    public void loadNamedConfig(String name) throws IOException {
        this.sce.loadCategories(new String[]{"Rafts:" + name});
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full Raft module state")
    public RaftFullState getFullState() {
        return new RaftFullState(new RaftState(this.getTickPeriod()), this.mon.getFullState());
    }

    @Command(type=Command.CommandType.QUERY, description="Get a portion of a saved raw image")
    public static ImageData getImage(@Argument(name="filename", description="The image file name") String fileName, @Argument(name="offset", description="The offset to the first pixel") int offset, @Argument(name="count", description="The number of pixels to get") int count) throws RaftException, IOException {
        return ImageProc.getImage(fileName, offset, count);
    }

    void publishState() {
        KeyValueData data = new KeyValueData("RaftState", (Serializable)new RaftState(this.getTickPeriod()));
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    RaftsCommands getRaftsCommands() {
        return this.raftsCommands;
    }
}

