/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ccob;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.Charset;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.commons.DriverException;

public class CCOBSocketDriver
implements CCOBInterface,
Closeable {
    private static final Charset DEFAULT_CHARSET = Charset.forName("US-ASCII");
    private Socket socket;
    private final String host;
    private final int port;

    CCOBSocketDriver(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void init() throws DriverException {
        try {
            this.socket = new Socket(this.host, this.port);
        }
        catch (IOException ex) {
            throw new DriverException((Throwable)ex);
        }
        this.write("Init");
        this.readAndCheckOK();
    }

    @Override
    public void stop() throws DriverException {
        this.write("Stop");
        this.readAndCheckOK();
        try {
            this.close();
        }
        catch (IOException ex) {
            throw new DriverException((Throwable)ex);
        }
    }

    @Override
    public String version() throws DriverException {
        this.write("Version");
        return this.read();
    }

    @Override
    public String date() throws DriverException {
        this.write("Date");
        return this.read();
    }

    @Override
    public String misc() throws DriverException {
        this.write("Misc");
        return this.read();
    }

    @Override
    public String manu() throws DriverException {
        this.write("Manu");
        return this.read();
    }

    @Override
    public String device() throws DriverException {
        this.write("Device");
        return this.read();
    }

    @Override
    public void selectLed(CCOBInterface.LED led) throws DriverException {
        this.write("SelectLed " + led.ordinal());
        this.readAndCheckOK();
    }

    @Override
    public void setLedCurrent(double current) throws DriverException {
        this.write("SetLedCurrent " + current);
        this.readAndCheckOK();
    }

    @Override
    public void setExposureTime(double time) throws DriverException {
        this.write("SetExposureTime " + time);
        this.readAndCheckOK();
    }

    @Override
    public void pulse() throws DriverException {
        this.write("PulseLed");
        this.readAndCheckOK();
    }

    @Override
    public void shutter() throws DriverException {
        this.write("UseShutter");
        this.readAndCheckOK();
    }

    @Override
    public void startExposure() throws DriverException {
        this.write("StartExposure");
        this.readAndCheckOK();
    }

    @Override
    public boolean pollEnd() throws DriverException {
        this.write("PollEnd");
        String response = this.read();
        if (response.equals("1")) {
            return true;
        }
        if (response.equals("0")) {
            return false;
        }
        throw new DriverException("Unexpected response from server: " + response);
    }

    @Override
    public CCOBDataRead getAdcValues() throws DriverException {
        this.write("GetAdcValues");
        String response = this.read();
        CCOBDataRead myData = new CCOBDataRead(response);
        return myData;
    }

    @Override
    public double getAdcPhotoDiode() throws DriverException {
        this.write("GetAdcPhotoDiode");
        String response = this.read();
        return Double.parseDouble(response);
    }

    private void write(String command) throws DriverException {
        try {
            this.socket.getOutputStream().write(command.getBytes(DEFAULT_CHARSET));
        }
        catch (IOException ex) {
            throw new DriverException("Error writing to socket", (Throwable)ex);
        }
    }

    private String read() throws DriverException {
        try {
            byte[] buffer = new byte[256];
            this.socket.getInputStream().read(buffer);
            return new String(buffer, DEFAULT_CHARSET);
        }
        catch (IOException ex) {
            throw new DriverException("Error reading from socket", (Throwable)ex);
        }
    }

    private void readAndCheckOK() throws DriverException {
        String response = this.read();
        if (!response.startsWith("OK")) {
            throw new DriverException("Unexpected response from server: " + response);
        }
    }

    @Override
    public void ledOn(int Led, int On) throws DriverException {
        this.write("LedOn " + Led + " " + (On > 0 ? "1" : "0"));
        this.readAndCheckOK();
    }

    @Override
    public boolean readButton(int Button) throws DriverException {
        this.write("ReadButton " + Button);
        String response = this.read();
        if (response.equals("1")) {
            return true;
        }
        if (response.equals("0")) {
            return false;
        }
        throw new DriverException("Unexpected response from server: " + response);
    }
}

