/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ccob;

import java.io.IOException;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.ccob.jni.CcobJNI;
import org.lsst.ccs.drivers.commons.DriverException;

public class CCOBCommands
implements CCOBInterface {
    private final CCOBInterface driver;

    public CCOBCommands() {
        this.driver = new CcobJNI();
    }

    public CCOBCommands(CCOBInterface driver) {
        this.driver = driver;
    }

    @Command(description="Close connection")
    public void close() throws IOException, DriverException {
        this.driver.stop();
    }

    @Override
    @Command(description="Open connection and initialize CCOB")
    public void init() throws DriverException {
        this.checkSocket().init();
    }

    @Override
    @Command(description="Stop CCOB and close connection")
    public void stop() throws DriverException {
        this.checkSocket().stop();
    }

    @Override
    @Command(description="Get version string")
    public String version() throws DriverException {
        return this.checkSocket().version();
    }

    @Override
    @Command(description="Get date string")
    public String date() throws DriverException {
        return this.checkSocket().date();
    }

    @Override
    @Command(description="Get miscellaneous string")
    public String misc() throws DriverException {
        return this.checkSocket().misc();
    }

    @Override
    @Command(description="Get manufacturer string")
    public String manu() throws DriverException {
        return this.checkSocket().manu();
    }

    @Override
    @Command(description="Get device string")
    public String device() throws DriverException {
        return this.checkSocket().device();
    }

    @Override
    @Command(description="Select the LED")
    public void selectLed(@Argument(name="led", description="LED name") CCOBInterface.LED led) throws DriverException {
        this.checkSocket().selectLed(led);
    }

    @Override
    @Command(description="Set the LED current")
    public void setLedCurrent(@Argument(description="LED current (amps)") double current) throws DriverException {
        this.checkSocket().setLedCurrent(current);
    }

    @Override
    @Command(description="Set the exposure time")
    public void setExposureTime(@Argument(description="Exposure time (secs)") double time) throws DriverException {
        this.checkSocket().setExposureTime(time);
    }

    @Override
    @Command(description="Set pulse mode")
    public void pulse() throws DriverException {
        this.checkSocket().pulse();
    }

    @Override
    @Command(description="Set shutter mode")
    public void shutter() throws DriverException {
        this.checkSocket().shutter();
    }

    @Override
    @Command(description="Start exposure")
    public void startExposure() throws DriverException {
        this.checkSocket().startExposure();
    }

    @Override
    @Command(description="Poll for end of exposure")
    public boolean pollEnd() throws DriverException {
        return this.checkSocket().pollEnd();
    }

    @Override
    @Command(description="Read ADC values")
    public CCOBDataRead getAdcValues() throws DriverException {
        return this.checkSocket().getAdcValues();
    }

    @Override
    @Command(description="Read photodiode voltage")
    public double getAdcPhotoDiode() throws DriverException {
        return this.checkSocket().getAdcPhotoDiode();
    }

    @Command(description="Read LED current")
    public double getLedCurrent() throws DriverException {
        return this.getAdcValues().getLedCurrent();
    }

    @Command(description="Read LED voltage")
    public double getLedVoltage() throws DriverException {
        return this.getAdcValues().getLedVoltage();
    }

    @Command(description="Read LED reference voltage")
    public double getLedRefVoltage() throws DriverException {
        return this.getAdcValues().getLedVref();
    }

    @Command(description="Read sphere temperature")
    public double getSphereTemperature() throws DriverException {
        return this.getAdcValues().getTempSphere();
    }

    @Command(description="Read board temperature")
    public double getBoardTemperature() throws DriverException {
        return this.getAdcValues().getTempBrd();
    }

    @Command(description="Read LED temperature 1")
    public double getLed1Temperature() throws DriverException {
        return this.getAdcValues().getTempLed1();
    }

    @Command(description="Read LED temperature 2")
    public double getLed2Temperature() throws DriverException {
        return this.getAdcValues().getTempLed2();
    }

    @Override
    @Command(description="Set board LED state")
    public void ledOn(@Argument(description="LED number (1 - 4)") int led, @Argument(description="LED state (1 = on, 0 = off)") int on) throws DriverException {
        this.checkSocket().ledOn(led, on);
    }

    @Override
    @Command(description="Get button state")
    public boolean readButton(@Argument(description="Button number (0 - 4)") int Button) throws DriverException {
        return this.checkSocket().readButton(Button);
    }

    private CCOBInterface checkSocket() {
        if (this.driver == null) {
            throw new RuntimeException("Socket not open");
        }
        return this.driver;
    }
}

