/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.Random;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.teststand.LampDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

public class NewportLampSimDevice
extends Device
implements LampDevice {
    private String lampType = "undef";
    TSConfig cfg = new TSConfig();
    private double[] runlampcurr = new double[TSConfig.MAXSTATES];
    private int itype = 2;
    private int port;
    private String host;
    boolean isConnected = false;
    boolean failedToInitialize = false;
    private int powerPreset;
    private boolean isPowerOn = false;
    private Random r = new Random();

    public NewportLampSimDevice(String host, int port) throws DriverException {
        this(2, host, port);
    }

    public NewportLampSimDevice(int itype, String host, int baud) throws DriverException {
        this.itype = itype;
        this.host = host;
        this.port = this.port;
    }

    @Override
    @Command(name="isLampPowerOn", description="returns whether the NewportLamp device is active")
    public boolean isLampPowerOn() {
        return this.isPowerOn;
    }

    @Override
    @Command(name="setLampPowerEnable", description="enables/disables the power to the lamp from the NewportLamp device")
    public void setLampPowerEnable(@Argument(name="enable", description="enables/disables lamp power") boolean on) {
        this.isPowerOn = true;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getLampCurrent", description="returns the #amps read from the NewportLamp device")
    public double getLampCurrent() {
        return this.isPowerOn ? 4.0 + this.r.nextGaussian() : 0.0;
    }

    @Override
    @Command(name="setLampCurrent", description="(not implemented) sets the current for the NewportLamp device")
    public void setLampCurrent(double current) {
        this.log.error((Object)"Purposely not implemented");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getLampPower", description="returns the #amps read from the NewportLamp device")
    public double getLampPower() {
        return this.isPowerOn ? 7.0 + this.r.nextGaussian() : 0.0;
    }

    @Command(name="setLampPower", description="(not implimented) sets the power for the NewportLamp device")
    public void setLampPower(double current) {
        this.log.error((Object)"Purposely not implemented!!!");
    }

    @Override
    @Command(name="setType", description="define lamp type")
    public void setType(String type) {
        this.lampType = type;
    }

    @Override
    @Command(name="getType", description="returns the lamp type")
    public String getType() {
        return this.lampType;
    }

    @Override
    @Command(name="getLampIdent", description="returns the identity read from the NewportLamp device")
    public String getLampIdent() {
        String ident = "?";
        return ident;
    }

    protected void close() {
        this.isConnected = false;
    }

    protected void initialize() {
        this.isConnected = true;
        this.setOnline(true);
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("NewportLampDevice readChannel called! chan=" + chan + " type=" + type));
        try {
            value = chan == 1 ? this.getLampCurrent() : this.getLampPower();
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading channel type " + type + " channel " + chan), (Throwable)e);
        }
        return value;
    }

    public void setRunlampcurr(double runlampcurr, int iwstate) {
        this.runlampcurr[iwstate] = runlampcurr;
    }

    public double getRunlampcurr(int iwstate) {
        return this.runlampcurr[iwstate];
    }

    @Command(name="setPowerPreset", description="Set the power preset", type=Command.CommandType.ACTION)
    public void setPowerPreset(@Argument(name="powerPreset", description="desired power") int powerPreset) throws DriverException {
        this.powerPreset = powerPreset;
    }

    @Command(name="getStatus", description="Read Status", type=Command.CommandType.QUERY)
    public String getStatus() throws DriverException {
        return "?";
    }

    @Command(name="getPowerPreset", description="Read Power Preset", type=Command.CommandType.QUERY)
    public int getPowerPreset() throws DriverException {
        return this.powerPreset;
    }

    @Command(name="getVolts", description="Read Volts", type=Command.CommandType.QUERY)
    public double getVolts() throws DriverException {
        return this.isPowerOn ? 45.0 + this.r.nextGaussian() : 0.0;
    }

    @Command(name="getLampHrs", description="Read Lamp Hrs", type=Command.CommandType.QUERY)
    public String getLampHrs() throws DriverException {
        return "13";
    }

    @Command(name="genericRead", description="Generic read", type=Command.CommandType.QUERY)
    public String genericRead(@Argument(name="command", description="generic read command") String command) throws DriverException {
        return "?";
    }
}

