/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.comp.hcompress;

import java.nio.ByteBuffer;

public class HDecompress {
    private static final byte[] CODE_MAGIC = new byte[]{-35, -103};
    private static final int[] MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private static final byte ZERO = 0;
    private static final byte BIT_ONE = 1;
    private static final byte BIT_TWO = 2;
    private static final byte BIT_THREE = 4;
    private static final byte BIT_FOUR = 8;
    private static final int N03 = 3;
    private static final int N04 = 4;
    private static final int N05 = 5;
    private static final int N06 = 6;
    private static final int N07 = 7;
    private static final int N08 = 8;
    private static final int N09 = 9;
    private static final int N10 = 10;
    private static final int N11 = 11;
    private static final int N12 = 12;
    private static final int N13 = 13;
    private static final int N14 = 14;
    private static final int N15 = 15;
    private static final int N26 = 26;
    private static final int N27 = 27;
    private static final int N28 = 28;
    private static final int N29 = 29;
    private static final int N30 = 30;
    private static final int N31 = 31;
    private static final int N62 = 62;
    private static final int N63 = 63;
    private int bitsToGo;
    private int buffer2;
    private int nx;
    private int ny;
    private int scale;

    private int calculateLog2N(int nmax) {
        int log2n = (int)(Math.log(nmax) / Math.log(2.0) + 0.5);
        if (nmax > 1 << log2n) {
            ++log2n;
        }
        return log2n;
    }

    private void decode64(ByteBuffer infile, LongArrayPointer a) {
        byte[] nbitplanes = new byte[3];
        byte[] tmagic = new byte[2];
        infile.get(tmagic);
        if (tmagic[0] != CODE_MAGIC[0] || tmagic[1] != CODE_MAGIC[1]) {
            throw new RuntimeException("compresseionError");
        }
        this.nx = infile.getInt();
        this.ny = infile.getInt();
        this.scale = infile.getInt();
        long sumall = infile.getLong();
        infile.get(nbitplanes);
        this.dodecode64(infile, a, nbitplanes);
        a.set(0, sumall);
    }

    public void decompress(ByteBuffer input, boolean smooth, long[] aa) {
        LongArrayPointer a = new LongArrayPointer(aa);
        this.decode64(input, a);
        this.undigitize64(a);
        this.hinv64(a, smooth);
    }

    private int dodecode64(ByteBuffer infile, LongArrayPointer a, byte[] nbitplanes) {
        int i;
        int nel = this.nx * this.ny;
        int nx2 = (this.nx + 1) / 2;
        int ny2 = (this.ny + 1) / 2;
        for (i = 0; i < nel; ++i) {
            a.set(i, 0L);
        }
        this.startInputingBits();
        this.qtreeDecode64(infile, a.copy(0), this.ny, nx2, ny2, nbitplanes[0]);
        this.qtreeDecode64(infile, a.copy(ny2), this.ny, nx2, this.ny / 2, nbitplanes[1]);
        this.qtreeDecode64(infile, a.copy(this.ny * nx2), this.ny, this.nx / 2, ny2, nbitplanes[1]);
        this.qtreeDecode64(infile, a.copy(this.ny * nx2 + ny2), this.ny, this.nx / 2, this.ny / 2, nbitplanes[2]);
        if (this.inputNybble(infile) != 0) {
            throw new RuntimeException("compresseionError");
        }
        this.startInputingBits();
        for (i = 0; i < nel; ++i) {
            if (a.get(i) == 0L || this.inputBit(infile) == 0) continue;
            a.set(i, -a.get(i));
        }
        return 0;
    }

    private int hinv64(LongArrayPointer a, boolean smooth) {
        int nmax = this.nx > this.ny ? this.nx : this.ny;
        int log2n = this.calculateLog2N(nmax);
        long[] tmp = new long[(nmax + 1) / 2];
        int shift = 1;
        long bit0 = 1L << log2n - 1;
        long bit1 = bit0 << 1;
        long bit2 = bit0 << 2;
        long mask0 = -bit0;
        long mask1 = mask0 << 1;
        long mask2 = mask0 << 2;
        long prnd0 = bit0 >> 1;
        long prnd1 = bit1 >> 1;
        long prnd2 = bit2 >> 1;
        long nrnd0 = prnd0 - 1L;
        long nrnd1 = prnd1 - 1L;
        long nrnd2 = prnd2 - 1L;
        a.set(0, a.get(0) + (a.get(0) >= 0L ? prnd2 : nrnd2) & mask2);
        int nxtop = 1;
        int nytop = 1;
        int nxf = this.nx;
        int nyf = this.ny;
        int c = 1 << log2n;
        for (int k = log2n - 1; k >= 0; --k) {
            long lowbit1;
            long hy;
            long h0;
            int s00;
            int j;
            int i;
            nxtop <<= 1;
            nytop <<= 1;
            if (nxf <= (c >>= 1)) {
                --nxtop;
            } else {
                nxf -= c;
            }
            if (nyf <= c) {
                --nytop;
            } else {
                nyf -= c;
            }
            if (k == 0) {
                nrnd0 = 0L;
                shift = 2;
            }
            for (i = 0; i < nxtop; ++i) {
                this.unshuffle64(a.copy(this.ny * i), nytop, 1, tmp);
            }
            for (j = 0; j < nytop; ++j) {
                this.unshuffle64(a.copy(j), nxtop, this.ny, tmp);
            }
            if (smooth) {
                this.hsmooth64(a, nxtop, nytop);
            }
            int oddx = nxtop % 2;
            int oddy = nytop % 2;
            for (i = 0; i < nxtop - oddx; i += 2) {
                long hx;
                s00 = this.ny * i;
                int s10 = s00 + this.ny;
                for (j = 0; j < nytop - oddy; j += 2) {
                    h0 = a.get(s00);
                    hx = a.get(s10);
                    hy = a.get(s00 + 1);
                    long hc = a.get(s10 + 1);
                    hx = hx + (hx >= 0L ? prnd1 : nrnd1) & mask1;
                    hy = hy + (hy >= 0L ? prnd1 : nrnd1) & mask1;
                    hc = hc + (hc >= 0L ? prnd0 : nrnd0) & mask0;
                    long lowbit0 = hc & bit0;
                    hx = hx >= 0L ? hx - lowbit0 : hx + lowbit0;
                    hy = hy >= 0L ? hy - lowbit0 : hy + lowbit0;
                    lowbit1 = (hc ^ hx ^ hy) & bit1;
                    h0 = h0 >= 0L ? h0 + lowbit0 - lowbit1 : h0 + (lowbit0 == 0L ? lowbit1 : lowbit0 - lowbit1);
                    a.set(s10 + 1, h0 + hx + hy + hc >> shift);
                    a.set(s10, h0 + hx - hy - hc >> shift);
                    a.set(s00 + 1, h0 - hx + hy - hc >> shift);
                    a.set(s00, h0 - hx - hy + hc >> shift);
                    s00 += 2;
                    s10 += 2;
                }
                if (oddy == 0) continue;
                h0 = a.get(s00);
                hx = a.get(s10);
                hx = (hx >= 0L ? hx + prnd1 : hx + nrnd1) & mask1;
                lowbit1 = hx & bit1;
                h0 = h0 >= 0L ? h0 - lowbit1 : h0 + lowbit1;
                a.set(s10, h0 + hx >> shift);
                a.set(s00, h0 - hx >> shift);
            }
            if (oddx != 0) {
                s00 = this.ny * i;
                for (j = 0; j < nytop - oddy; j += 2) {
                    h0 = a.get(s00);
                    hy = a.get(s00 + 1);
                    hy = (hy >= 0L ? hy + prnd1 : hy + nrnd1) & mask1;
                    lowbit1 = hy & bit1;
                    h0 = h0 >= 0L ? h0 - lowbit1 : h0 + lowbit1;
                    a.set(s00 + 1, h0 + hy >> shift);
                    a.set(s00, h0 - hy >> shift);
                    s00 += 2;
                }
                if (oddy != 0) {
                    h0 = a.get(s00);
                    a.set(s00, h0 >> shift);
                }
            }
            bit2 = bit1;
            bit1 = bit0;
            bit0 >>= 1;
            mask1 = mask0;
            mask0 >>= 1;
            prnd1 = prnd0;
            nrnd1 = nrnd0;
            nrnd0 = (prnd0 >>= 1) - 1L;
        }
        return 0;
    }

    private void hsmooth64(LongArrayPointer a, int nxtop, int nytop) {
        long s;
        long dmin;
        long dmax;
        long diff;
        long hp;
        long h0;
        long hm;
        int j;
        int s10;
        int s00;
        int i;
        long smax = this.scale >> 1;
        if (smax <= 0L) {
            return;
        }
        int ny2 = this.ny << 1;
        for (i = 2; i < nxtop - 2; i += 2) {
            s00 = this.ny * i;
            s10 = s00 + this.ny;
            for (j = 0; j < nytop; j += 2) {
                hm = a.get(s00 - ny2);
                h0 = a.get(s00);
                hp = a.get(s00 + ny2);
                diff = hp - hm;
                dmax = Math.max(Math.min(hp - h0, h0 - hm), 0L) << 2;
                dmin = Math.min(Math.max(hp - h0, h0 - hm), 0L) << 2;
                if (dmin < dmax) {
                    s = (diff = Math.max(Math.min(diff, dmax), dmin)) - (a.get(s10) << 3);
                    s = s >= 0L ? s >> 3 : s + 7L >> 3;
                    s = Math.max(Math.min(s, smax), -smax);
                    a.set(s10, a.get(s10) + s);
                }
                s00 += 2;
                s10 += 2;
            }
        }
        for (i = 0; i < nxtop; i += 2) {
            s00 = this.ny * i + 2;
            s10 = s00 + this.ny;
            for (j = 2; j < nytop - 2; j += 2) {
                hm = a.get(s00 - 2);
                h0 = a.get(s00);
                hp = a.get(s00 + 2);
                diff = hp - hm;
                dmax = Math.max(Math.min(hp - h0, h0 - hm), 0L) << 2;
                dmin = Math.min(Math.max(hp - h0, h0 - hm), 0L) << 2;
                if (dmin < dmax) {
                    s = (diff = Math.max(Math.min(diff, dmax), dmin)) - (a.get(s00 + 1) << 3);
                    s = s >= 0L ? s >> 3 : s + 7L >> 3;
                    s = Math.max(Math.min(s, smax), -smax);
                    a.set(s00 + 1, a.get(s00 + 1) + s);
                }
                s00 += 2;
                s10 += 2;
            }
        }
        for (i = 2; i < nxtop - 2; i += 2) {
            s00 = this.ny * i + 2;
            s10 = s00 + this.ny;
            for (j = 2; j < nytop - 2; j += 2) {
                long hmm = a.get(s00 - ny2 - 2);
                long hpm = a.get(s00 + ny2 - 2);
                long hmp = a.get(s00 - ny2 + 2);
                long hpp = a.get(s00 + ny2 + 2);
                h0 = a.get(s00);
                diff = hpp + hmm - hmp - hpm;
                long hx2 = a.get(s10) << 1;
                long hy2 = a.get(s00 + 1) << 1;
                long m1 = Math.min(Math.max(hpp - h0, 0L) - hx2 - hy2, Math.max(h0 - hpm, 0L) + hx2 - hy2);
                long m2 = Math.min(Math.max(h0 - hmp, 0L) - hx2 + hy2, Math.max(hmm - h0, 0L) + hx2 + hy2);
                dmax = Math.min(m1, m2) << 4;
                m1 = Math.max(Math.min(hpp - h0, 0L) - hx2 - hy2, Math.min(h0 - hpm, 0L) + hx2 - hy2);
                dmin = Math.max(m1, m2 = Math.max(Math.min(h0 - hmp, 0L) - hx2 + hy2, Math.min(hmm - h0, 0L) + hx2 + hy2)) << 4;
                if (dmin < dmax) {
                    s = (diff = Math.max(Math.min(diff, dmax), dmin)) - (a.get(s10 + 1) << 6);
                    s = s >= 0L ? s >> 6 : s + 63L >> 6;
                    s = Math.max(Math.min(s, smax), -smax);
                    a.set(s10 + 1, a.get(s10 + 1) + s);
                }
                s00 += 2;
                s10 += 2;
            }
        }
    }

    private int inputBit(ByteBuffer infile) {
        if (this.bitsToGo == 0) {
            this.buffer2 = infile.get() & 0xFF;
            this.bitsToGo = 8;
        }
        --this.bitsToGo;
        return this.buffer2 >> this.bitsToGo & 1;
    }

    private int inputHuffman(ByteBuffer infile) {
        int c = this.inputNbits(infile, 3);
        if (c < 4) {
            return 1 << c;
        }
        c = this.inputBit(infile) | c << 1;
        if (c < 13) {
            switch (c) {
                case 8: {
                    return 3;
                }
                case 9: {
                    return 5;
                }
                case 10: {
                    return 10;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 15;
                }
            }
        }
        if ((c = this.inputBit(infile) | c << 1) < 31) {
            switch (c) {
                case 26: {
                    return 6;
                }
                case 27: {
                    return 7;
                }
                case 28: {
                    return 9;
                }
                case 29: {
                    return 11;
                }
                case 30: {
                    return 13;
                }
            }
        }
        if ((c = this.inputBit(infile) | c << 1) == 62) {
            return 0;
        }
        return 14;
    }

    private int inputNbits(ByteBuffer infile, int n) {
        if (this.bitsToGo < n) {
            this.buffer2 = this.buffer2 << 8 | infile.get() & 0xFF;
            this.bitsToGo += 8;
        }
        this.bitsToGo -= n;
        return this.buffer2 >> this.bitsToGo & MASKS[n];
    }

    private int inputNnybble(ByteBuffer infile, int n, byte[] array) {
        int ii;
        if (n == 1) {
            array[0] = (byte)this.inputNybble(infile);
            return 0;
        }
        if (this.bitsToGo == 8) {
            infile.position(infile.position() - 1);
            this.bitsToGo = 0;
        }
        int shift1 = this.bitsToGo + 4;
        int shift2 = this.bitsToGo;
        int kk = 0;
        if (this.bitsToGo == 0) {
            for (ii = 0; ii < n / 2; ++ii) {
                this.buffer2 = this.buffer2 << 8 | infile.get() & 0xFF;
                array[kk] = (byte)(this.buffer2 >> 4 & 0xF);
                array[kk + 1] = (byte)(this.buffer2 & 0xF);
                kk += 2;
            }
        } else {
            for (ii = 0; ii < n / 2; ++ii) {
                this.buffer2 = this.buffer2 << 8 | infile.get() & 0xFF;
                array[kk] = (byte)(this.buffer2 >> shift1 & 0xF);
                array[kk + 1] = (byte)(this.buffer2 >> shift2 & 0xF);
                kk += 2;
            }
        }
        if (ii * 2 != n) {
            array[n - 1] = (byte)this.inputNybble(infile);
        }
        return this.buffer2 >> this.bitsToGo & 0xF;
    }

    private int inputNybble(ByteBuffer infile) {
        if (this.bitsToGo < 4) {
            this.buffer2 = this.buffer2 << 8 | infile.get() & 0xFF;
            this.bitsToGo += 8;
        }
        this.bitsToGo -= 4;
        return this.buffer2 >> this.bitsToGo & 0xF;
    }

    private void qtreeBitins64(byte[] a, int lnx, int lny, LongArrayPointer b, int n, int bit) {
        byte value;
        int j;
        int s00;
        int i;
        long planeVal = 1L << bit;
        ByteBuffer k = ByteBuffer.wrap(a);
        for (i = 0; i < lnx - 1; i += 2) {
            s00 = n * i;
            for (j = 0; j < lny - 1; j += 2) {
                value = k.get();
                if ((value & 1) != 0) {
                    b.bitOr(s00 + n + 1, planeVal);
                }
                if ((value & 2) != 0) {
                    b.bitOr(s00 + n, planeVal);
                }
                if ((value & 4) != 0) {
                    b.bitOr(s00 + 1, planeVal);
                }
                if ((value & 8) != 0) {
                    b.bitOr(s00, planeVal);
                }
                s00 += 2;
            }
            if (j >= lny) continue;
            value = k.get();
            if ((value & 2) != 0) {
                b.bitOr(s00 + n, planeVal);
            }
            if ((value & 8) == 0) continue;
            b.bitOr(s00, planeVal);
        }
        if (i < lnx) {
            s00 = n * i;
            for (j = 0; j < lny - 1; j += 2) {
                value = k.get();
                if ((value & 4) != 0) {
                    b.bitOr(s00 + 1, planeVal);
                }
                if ((value & 8) != 0) {
                    b.bitOr(s00, planeVal);
                }
                s00 += 2;
            }
            if (j < lny && (k.get() & 8) != 0) {
                b.bitOr(s00, planeVal);
            }
        }
    }

    private void qtreeCopy(byte[] a, int lnx, int lny, byte[] b, int n) {
        int j;
        int s00;
        int i;
        int nx2 = (lnx + 1) / 2;
        int ny2 = (lny + 1) / 2;
        int k = ny2 * (nx2 - 1) + ny2 - 1;
        for (i = nx2 - 1; i >= 0; --i) {
            s00 = 2 * (n * i + ny2 - 1);
            for (j = ny2 - 1; j >= 0; --j) {
                b[s00] = a[k];
                --k;
                s00 -= 2;
            }
        }
        for (i = 0; i < lnx - 1; i += 2) {
            s00 = n * i;
            int s10 = s00 + n;
            for (j = 0; j < lny - 1; j += 2) {
                b[s10 + 1] = (b[s00] & 1) == 0 ? (byte)0 : 1;
                b[s10] = (b[s00] & 2) == 0 ? (byte)0 : 1;
                b[s00 + 1] = (b[s00] & 4) == 0 ? (byte)0 : 1;
                b[s00] = (b[s00] & 8) == 0 ? (byte)0 : 1;
                s00 += 2;
                s10 += 2;
            }
            if (j >= lny) continue;
            b[s10] = (byte)(b[s00] >> 1 & 1);
            b[s00] = (byte)(b[s00] >> 3 & 1);
        }
        if (i < lnx) {
            s00 = n * i;
            for (j = 0; j < lny - 1; j += 2) {
                b[s00 + 1] = (byte)(b[s00] >> 2 & 1);
                b[s00] = (byte)(b[s00] >> 3 & 1);
                s00 += 2;
            }
            if (j < lny) {
                b[s00] = (byte)(b[s00] >> 3 & 1);
            }
        }
    }

    private int qtreeDecode64(ByteBuffer infile, LongArrayPointer a, int n, int nqx, int nqy, int nbitplanes) {
        int nqmax = nqx > nqy ? nqx : nqy;
        int log2n = this.calculateLog2N(nqmax);
        int nqx2 = (nqx + 1) / 2;
        int nqy2 = (nqy + 1) / 2;
        byte[] scratch = new byte[nqx2 * nqy2];
        for (int bit = nbitplanes - 1; bit >= 0; --bit) {
            int b = this.inputNybble(infile);
            if (b == 0) {
                this.readBdirect64(infile, a, n, nqx, nqy, scratch, bit);
                continue;
            }
            if (b != 15) {
                throw new RuntimeException("compresseionError");
            }
            scratch[0] = (byte)this.inputHuffman(infile);
            int nx2 = 1;
            int ny2 = 1;
            int nfx = nqx;
            int nfy = nqy;
            int c = 1 << log2n;
            for (int k = 1; k < log2n; ++k) {
                nx2 <<= 1;
                ny2 <<= 1;
                if (nfx <= (c >>= 1)) {
                    --nx2;
                } else {
                    nfx -= c;
                }
                if (nfy <= c) {
                    --ny2;
                } else {
                    nfy -= c;
                }
                this.qtreeExpand(infile, scratch, nx2, ny2, scratch);
            }
            this.qtreeBitins64(scratch, nqx, nqy, a, n, bit);
        }
        return 0;
    }

    private void qtreeExpand(ByteBuffer infile, byte[] a, int nx2, int ny2, byte[] b) {
        this.qtreeCopy(a, nx2, ny2, b, ny2);
        for (int i = nx2 * ny2 - 1; i >= 0; --i) {
            if (b[i] == 0) continue;
            b[i] = (byte)this.inputHuffman(infile);
        }
    }

    private void readBdirect64(ByteBuffer infile, LongArrayPointer a, int n, int nqx, int nqy, byte[] scratch, int bit) {
        this.inputNnybble(infile, (nqx + 1) / 2 * ((nqy + 1) / 2), scratch);
        this.qtreeBitins64(scratch, nqx, nqy, a, n, bit);
    }

    private void startInputingBits() {
        this.bitsToGo = 0;
    }

    private void undigitize64(LongArrayPointer a) {
        if (this.scale <= 1) {
            return;
        }
        long scale64 = this.scale;
        for (int index = 0; index < a.a.length; ++index) {
            ((LongArrayPointer)a).a[index] = a.a[index] * scale64;
        }
    }

    private void unshuffle64(LongArrayPointer a, int n, int n2, long[] tmp) {
        int i;
        int nhalf = n + 1 >> 1;
        LongArrayPointer pt = new LongArrayPointer(tmp);
        LongArrayPointer p1 = a.copy(n2 * nhalf);
        for (i = nhalf; i < n; ++i) {
            pt.set(p1.get());
            p1.offset += n2;
            pt.offset += 1;
        }
        LongArrayPointer p2 = a.copy(n2 * (nhalf - 1));
        p1 = a.copy(n2 * (nhalf - 1) << 1);
        for (i = nhalf - 1; i >= 0; --i) {
            p1.set(p2.get());
            p2.offset -= n2;
            p1.offset -= n2 + n2;
        }
        pt = new LongArrayPointer(tmp);
        p1 = a.copy(n2);
        for (i = 1; i < n; i += 2) {
            p1.set(pt.get());
            p1.offset += n2 + n2;
            pt.offset += 1;
        }
    }

    private static class LongArrayPointer {
        private final long[] a;
        private int offset;

        public LongArrayPointer(long[] tmp) {
            this.a = tmp;
            this.offset = 0;
        }

        public void bitOr(int i, long planeVal) {
            int n = this.offset + i;
            this.a[n] = this.a[n] | planeVal;
        }

        public LongArrayPointer copy(int extraOffset) {
            LongArrayPointer intAP = new LongArrayPointer(this.a);
            intAP.offset = this.offset + extraOffset;
            return intAP;
        }

        public long get() {
            return this.a[this.offset];
        }

        public long get(int i) {
            return this.a[this.offset + i];
        }

        public void set(int i, long value) {
            this.a[this.offset + i] = value;
        }

        public void set(long value) {
            this.a[this.offset] = value;
        }
    }
}

