/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.ccd.SegmentReadOutOrder;

public class CCD
extends Geometry<Segment> {
    private final CCDType ccdType;
    private final List<Segment> segments = new ArrayList<Segment>();

    CCD(CCDType ccdType) {
        this(2, 8, ccdType);
    }

    CCD(int parallelSegmentsCount, int serialSegmentsCount, CCDType ccdType) {
        super("Sen", new Dimension(ccdType.getCCDGeometryConstants().getPhysicalAreaParallelSize(), ccdType.getCCDGeometryConstants().getPhysicalAreaSerialSize()), parallelSegmentsCount, serialSegmentsCount);
        this.ccdType = ccdType;
    }

    @Override
    protected void addGeometryToGrid(Segment segment, int p, int s) {
        int x = (int)this.ccdType.getCCDGeometryConstants().getParallelEdge() + (this.getParallelChildrenCount() - 1 - p) * segment.getWidth();
        int y = (int)this.ccdType.getCCDGeometryConstants().getSerialEdge() + (this.getSerialChildrenCount() - 1 - s) * segment.getHeight();
        this.addGeometry(segment, x, y);
        this.segments.add(segment);
        Collections.sort(this.segments, (o1, o2) -> o1.getChannel() > o2.getChannel() ? 1 : -1);
    }

    public int getActiveSerialSize() {
        return this.ccdType.getCCDGeometryConstants().getSegmentSerialActiveSize() * this.getSerialChildrenCount();
    }

    public int getActiveParallelSize() {
        return this.ccdType.getCCDGeometryConstants().getSegmentParallelActiveSize() * this.getParallelChildrenCount();
    }

    public CCDType getType() {
        return this.ccdType;
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public static CCD createCCD(CCDType ccdType) {
        CCD ccd = new CCD(ccdType);
        for (int s = 0; s < ccd.getSerialChildrenCount(); ++s) {
            for (int p = 0; p < ccd.getParallelChildrenCount(); ++p) {
                int channel = p == 0 ? 16 - s : 1 + s;
                Segment segment = Segment.createCCDSegment(ccdType, CCD.evaluateSegmentReadOutOrder(p, ccdType), channel);
                ccd.addChildGeometry(segment, p, s);
            }
        }
        return ccd;
    }

    private static SegmentReadOutOrder evaluateSegmentReadOutOrder(int parallelPosition, CCDType type) {
        if (parallelPosition == 1) {
            return SegmentReadOutOrder.LeftUp;
        }
        return type.getName().toLowerCase().contains("e2v") ? SegmentReadOutOrder.RightDown : SegmentReadOutOrder.RightUp;
    }
}

