/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.ccob.Led;
import org.lsst.ccs.subsystem.ccob.Shutter;
import org.lsst.ccs.subsystem.ccob.Thermometer;
import org.lsst.ccs.utilities.logging.Logger;

public class CCOBMainModule
implements HasLifecycle {
    public static final Logger ccobLog = Logger.getLogger((String)"org.lsst.ccs.subsystems.ccob");
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CCOBCommands driver;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Led led;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    Shutter shutter;
    Thermometer thermometer;

    public void init() {
        try {
            this.driver.init();
            ccobLog.info((Object)"connection established");
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot establish connection with ccob driver", ex);
        }
    }

    public void start() {
        ccobLog.info((Object)"ccob subsystem started");
    }

    @Command
    public CCOBDataRead getADCValues() throws DriverException {
        return this.driver.getAdcValues();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn On the led.")
    public void turnOnLed() {
        this.led.turnOn();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Turn Off the led.")
    public void turnOffLed() {
        this.led.turnOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open the shutter.")
    public void openShutter() {
        this.shutter.open();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close the shutter.")
    public void closeShutter() {
        this.shutter.close();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Take an image.")
    public void takeImage() {
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read temperature on the gauge and returns its values in decimal format.")
    public double readTemperature() {
        return this.thermometer.readTemperature();
    }
}

