/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.CloseMetaData;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;

public class MetaDataPersister
extends BatchPersister<Object> {
    public MetaDataPersister() {
        super(3000, false);
    }

    @Override
    public void persist(Object obj, Session sess) {
        if (obj instanceof MetaDataData) {
            this.persistMetaData((MetaDataData)obj, sess);
        } else if (obj instanceof CloseMetaData) {
            this.closeMetaData((CloseMetaData)obj, sess);
        }
    }

    private void persistMetaData(MetaDataData md, Session sess) {
        Query q = sess.createQuery("from MetaDataData md where dataGroup.id = :id and name = :n and endTime <= 0");
        q.setParameter("id", (Object)md.getDataGroup().getId());
        q.setParameter("n", (Object)md.getName());
        MetaDataData oldMetaData = (MetaDataData)q.uniqueResult();
        if (oldMetaData != null) {
            oldMetaData.setEndTime(md.getStartTime());
        }
        sess.persist((Object)md);
    }

    private void closeMetaData(CloseMetaData cmd, Session sess) {
        long time = System.currentTimeMillis();
        Query q = sess.createQuery("from MetaDataData md where dataGroup.agentName=:agName and endTime <= 0");
        q.setString("agName", cmd.agentName);
        List res = q.list();
        for (MetaDataData md : res) {
            md.setEndTime(time);
        }
    }
}

