/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.modbus.CRC16;
import org.lsst.ccs.drivers.modbus.ModbusIO;

public class ModbusIOFtdi
implements ModbusIO {
    private static final int PACKET_INTERVAL = 100;
    private final Ftdi ftdi = new Ftdi();

    @Override
    public void open(String serial, int baud) throws DriverException {
        this.ftdi.open(0, serial);
        this.ftdi.setBaudrate(baud);
        this.ftdi.setDataCharacteristics(8, 0, 0);
        this.ftdi.enableEvents(1);
    }

    @Override
    public void close() throws DriverException {
        this.ftdi.close();
    }

    @Override
    public int send(byte[] cmnd, byte[] resp, int timeout) throws DriverException {
        this.write(cmnd);
        return this.read(resp, timeout);
    }

    private void write(byte[] command) throws DriverException {
        int leng = command.length;
        CRC16.generateStd(command, 6, leng - 6 - 2, command, leng - 2);
        this.ftdi.write(command, 6, command.length - 6);
    }

    private int read(byte[] buff, int timeout) throws DriverException {
        int posn = 6;
        while (this.ftdi.awaitEvent(timeout) != 0) {
            int leng = this.ftdi.getQueueStatus();
            if (posn + leng > buff.length) {
                throw new DriverException("Read buffer is too short");
            }
            posn += this.ftdi.read(buff, posn, leng);
            timeout = 100;
        }
        if (posn == 6) {
            throw new DriverTimeoutException("Read timed out");
        }
        if (CRC16.generateStd(buff, 6, posn - 6) != 0) {
            throw new DriverException("Reply checksum error");
        }
        return posn;
    }

    @Override
    public void flush() throws DriverException {
        int count = this.ftdi.getQueueStatus();
        if (count > 0) {
            byte[] buff = new byte[count];
            this.ftdi.read(buff, 0, count);
        }
    }
}

