/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class TwisTorr84Device
extends Device {
    private final TwisTorr84 turbo = new TwisTorr84();
    private Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private Map<Integer, String> itemMap = new HashMap<Integer, String>();
    private Integer chanKey;
    @ConfigurationParameter
    protected String devcId;
    @ConfigurationParameter(isFinal=true, description="true/false for low/normal speed ")
    protected Boolean lowSpeedMode;
    @ConfigurationParameter(isFinal=true, description="true/false for water/air cooling")
    protected Boolean waterCooling;
    @ConfigurationParameter(isFinal=true, description="true/false for manual/auto")
    protected Boolean ventValveByCmnd;
    @ConfigurationParameter(isFinal=true, description="true/false for continuous/impulse")
    protected Boolean interlockType;
    @ConfigurationParameter
    protected Boolean softStartMode;
    @ConfigurationParameter
    protected Boolean activeStopMode;
    private final int rotfreq_set = 1350;
    private final int rotfreq_low = 1100;
    private final boolean serialType = false;
    private final boolean gasType = false;

    protected void initDevice() {
        this.chanKey = 0;
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "TwisTorr84 (" + this.devcId + ")";
        if (this.lowSpeedMode == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"lowSpeedMode", (String)"is missing");
        }
        if (this.waterCooling == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"waterCooling", (String)"is missing");
        }
        if (this.ventValveByCmnd == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"ventValveByCmnd", (String)"is missing");
        }
        if (this.interlockType == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"interlockType", (String)"is missing");
        }
        if (this.softStartMode == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"softStartMode", (String)"is missing");
        }
        if (this.activeStopMode == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"activeStopMode", (String)"is missing");
        }
    }

    protected void initialize() {
        try {
            this.turbo.open(this.devcId);
            this.setOnline(true);
            this.initSensors();
            this.log.info((Object)("Connected to " + this.fullName));
            this.turbo.writeBool(TwisTorr84.CmndBool.LOW_SPEED, this.lowSpeedMode.booleanValue());
            this.turbo.writeBool(TwisTorr84.CmndBool.VENTVALVE_BY_CMND, this.ventValveByCmnd.booleanValue());
            this.turbo.writeBool(TwisTorr84.CmndBool.INTERLOCK_TYPE, this.interlockType.booleanValue());
            this.turbo.writeBool(TwisTorr84.CmndBool.SOFT_START, this.softStartMode.booleanValue());
            this.turbo.writeBool(TwisTorr84.CmndBool.ACTIVE_STOP, this.activeStopMode.booleanValue());
            this.turbo.writeBool(TwisTorr84.CmndBool.SERIAL_TYPE, false);
            this.turbo.writeBool(TwisTorr84.CmndBool.GAS_TYPE_ARGON, false);
            this.turbo.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_SET, 1350);
            this.turbo.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_LOW, 1100);
            int status = this.turbo.readNumeric(TwisTorr84.CmndNumeric.STATUS);
            if (TwisTorr84.PumpStatus.decode((int)status) == "STOP") {
                this.turbo.writeBool(TwisTorr84.CmndBool.WATER_COOLING, this.waterCooling.booleanValue());
            }
            this.log.info((Object)("Hardware initialized for " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to or initializaing " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
            return;
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.turbo.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    @ConfigurationParameterChanger(propertyName="softStartMode")
    protected void setSoftStart(@Argument(name="<true|false>", description="Soft-start mode true or false") boolean value) throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.SOFT_START, value);
    }

    @ConfigurationParameterChanger(propertyName="activeStopMode")
    protected void setActiveStop(@Argument(name="<true|false>", description="Active-stop mode true or false") boolean value) throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.ACTIVE_STOP, value);
    }

    @Command(type=Command.CommandType.ACTION, name="startTurboPump", description="Start turbo pump")
    public void startTurboPump() throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.START_STOP, true);
    }

    @Command(type=Command.CommandType.ACTION, name="stopTurboPump", description="Stop turbo pump")
    public void stopTurboPump() throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.START_STOP, false);
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        try {
            switch (type) {
                case "Bool": {
                    TwisTorr84.CmndBool.valueOf((String)subtype);
                    break;
                }
                case "Numeric": {
                    TwisTorr84.CmndNumeric.valueOf((String)subtype);
                    break;
                }
                case "Alpha": {
                    TwisTorr84.CmndAlpha.valueOf((String)subtype);
                    break;
                }
                default: {
                    MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
                    break;
                }
            }
        }
        catch (Exception e) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)(type + " subtype "), (Object)subtype);
        }
        Object object = this.chanKey;
        Integer n = this.chanKey = Integer.valueOf(this.chanKey + 1);
        this.typeMap.put(this.chanKey, type);
        this.itemMap.put(this.chanKey, subtype);
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(int hwChan, int type) {
        String item;
        String itemType;
        double value = super.readChannel(hwChan, type);
        try {
            itemType = this.typeMap.get(type);
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading typeMap, TurboPump channel " + type + " " + e));
            return value;
        }
        try {
            item = this.itemMap.get(type);
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading itemMap, TurboPump channel " + type + " " + e));
            return value;
        }
        try {
            switch (itemType) {
                case "Bool": {
                    if (this.turbo.readBool(TwisTorr84.CmndBool.valueOf((String)item))) {
                        value = 1.0;
                        break;
                    }
                    value = 0.0;
                    break;
                }
                case "Numeric": {
                    value = this.turbo.readNumeric(TwisTorr84.CmndNumeric.valueOf((String)item));
                    break;
                }
                case "Alpha": {
                    this.turbo.readAlpha(TwisTorr84.CmndAlpha.valueOf((String)item));
                }
            }
        }
        catch (DriverTimeoutException et) {
            this.log.error((Object)("TurboPump timeout reading data " + item + ": " + (Object)((Object)et)));
            this.setOnline(false);
        }
        catch (DriverException e) {
            this.log.error((Object)("TurboPump exception reading data " + item + ": " + (Object)((Object)e)));
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, name="readTurboStatus", description="Get pump status, including operating modes and failure")
    public String readTurboStatus() throws DriverException {
        int status = this.turbo.readNumeric(TwisTorr84.CmndNumeric.STATUS);
        return TwisTorr84.PumpStatus.decode((int)status);
    }

    @Command(type=Command.CommandType.QUERY, name="readTurboFailCode", description="Fin reason(s) for failure")
    public String readTurboFailCode() throws DriverException {
        int errcode = this.turbo.readNumeric(TwisTorr84.CmndNumeric.ERRCODE);
        return Integer.toString(errcode, 16) + ", " + TwisTorr84.decodeError((int)errcode);
    }

    @Command(type=Command.CommandType.QUERY, name="readAll", description="Read all TurboPump controller settings and data")
    public String readAll() {
        String table = "Read all turbo-pump settings and data\n\n";
        TwisTorr84.CmndBool[] cmndB = TwisTorr84.CmndBool.values();
        int nB = cmndB.length;
        for (int i = 0; i < nB; ++i) {
            table = table + String.format("\n   %-22s", cmndB[i]);
            try {
                boolean respB = this.turbo.readBool(cmndB[i]);
                table = table + Boolean.toString(respB);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndNumeric[] cmndN = TwisTorr84.CmndNumeric.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", cmndN[i]);
            try {
                int respN = this.turbo.readNumeric(cmndN[i]);
                table = table + Integer.toString(respN);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndAlpha[] cmndA = TwisTorr84.CmndAlpha.values();
        int nA = cmndA.length;
        for (int i = 0; i < nA; ++i) {
            table = table + String.format("\n   %-22s", cmndA[i]);
            try {
                String respA = this.turbo.readAlpha(cmndA[i]);
                table = table + respA;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        return table;
    }

    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }
}

