/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.ModbusIO;
import org.lsst.ccs.drivers.modbus.ModbusIOFtdi;
import org.lsst.ccs.drivers.modbus.ModbusIONet;
import org.lsst.ccs.utilities.conv.Convert;

public class Modbus {
    public static final int CONN_TYPE_NETWORK = 0;
    public static final int CONN_TYPE_FTDI = 1;
    static final byte FUNC_READ_COILS = 1;
    static final byte FUNC_READ_DISCRETES = 2;
    static final byte FUNC_READ_REGISTERS = 3;
    static final byte FUNC_READ_INPUTS = 4;
    static final byte FUNC_WRITE_COIL = 5;
    static final byte FUNC_WRITE_REGISTER = 6;
    static final byte FUNC_WRITE_COILS = 15;
    static final byte FUNC_WRITE_REGISTERS = 16;
    static final int OFF_TID = 0;
    static final int OFF_PID = 2;
    static final int OFF_LENGTH = 4;
    static final int OFF_UID = 6;
    static final int OFF_FUNC = 7;
    static final int OFF_RLENG = 8;
    static final int OFF_ERROR = 8;
    static final int OFF_ADDR = 8;
    static final int OFF_RDATA = 9;
    static final int OFF_COUNT = 10;
    static final int OFF_DATA = 12;
    static final int LENG_HEADER = 6;
    static final int LENG_CRC = 2;
    static final int EXCP_ILL_FUNC = 1;
    static final int EXCP_ILL_ADDR = 2;
    static final int EXCP_ILL_VALUE = 3;
    static final int EXCP_SRVR_FAIL = 4;
    static final int EXCP_SRVR_BUSY = 6;
    static final int PORT_NUMBER = 502;
    static final int BAUD_RATE = 115200;
    private static final int READ_TIMEOUT = 2000;
    private ModbusIO io;
    private int nmbrOff = 1;
    private short tranId = 0;
    private final byte[] resp = new byte[1024];
    protected int timeout = 2000;

    public void open(int type, String ident) throws DriverException {
        this.open(type, ident, -1);
    }

    public synchronized void open(int type, String ident, int parm) throws DriverException {
        ModbusIO newIo;
        if (this.io != null) {
            throw new DriverException("Device already open");
        }
        switch (type) {
            case 0: {
                newIo = new ModbusIONet();
                parm = parm < 0 ? 502 : parm;
                break;
            }
            case 1: {
                newIo = new ModbusIOFtdi();
                parm = parm < 0 ? 115200 : parm;
                break;
            }
            default: {
                throw new DriverException("Invalid connection type: " + type);
            }
        }
        newIo.open(ident, parm);
        this.io = newIo;
    }

    public synchronized void close() throws DriverException {
        this.checkOpen();
        try {
            this.io.close();
        }
        finally {
            this.io = null;
        }
    }

    protected void checkOpen() throws DriverException {
        if (this.io == null) {
            throw new DriverException("Device not open");
        }
    }

    public void setAddressMode(boolean mode) {
        this.nmbrOff = mode ? 0 : 1;
    }

    public boolean isAddressMode() {
        return this.nmbrOff == 0;
    }

    public void setTimeout(double tmo) {
        this.timeout = (int)(1000.0 * tmo);
    }

    public synchronized byte[] readCoils(short dAddr, short cNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(cNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)1, cmnd, this.resp, this.timeout);
        int nbyte = this.resp[8] & 0xFF;
        byte[] value = new byte[nbyte];
        System.arraycopy(this.resp, 9, value, 0, nbyte);
        return value;
    }

    public synchronized byte[] readDiscretes(short dAddr, short iNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(iNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)2, cmnd, this.resp, this.timeout);
        int nbyte = this.resp[8] & 0xFF;
        byte[] value = new byte[nbyte];
        System.arraycopy(this.resp, 9, value, 0, nbyte);
        return value;
    }

    public synchronized short[] readRegisters(short dAddr, short rNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)3, cmnd, this.resp, this.timeout);
        int nvalue = (this.resp[8] & 0xFF) / 2;
        short[] value = new short[nvalue];
        int j = 0;
        while (j < nvalue) {
            value[j] = Convert.bytesToShortBE((byte[])this.resp, (int)(2 * j + 9));
            ++j;
        }
        return value;
    }

    public synchronized short[] readInputs(short dAddr, short rNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)4, cmnd, this.resp, this.timeout);
        int nvalue = (this.resp[8] & 0xFF) / 2;
        short[] value = new short[nvalue];
        int j = 0;
        while (j < nvalue) {
            value[j] = Convert.bytesToShortBE((byte[])this.resp, (int)(2 * j + 9));
            ++j;
        }
        return value;
    }

    public synchronized void writeRegister(short dAddr, short rNmbr, short value) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)value, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)6, cmnd, this.resp, this.timeout);
    }

    public synchronized void writeCoil(short dAddr, short cNmbr, boolean value) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(cNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)((short)(value ? 65280 : 0)), (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)5, cmnd, this.resp, this.timeout);
    }

    public synchronized void writeRegisters(short dAddr, short rNmbr, short[] value) throws DriverException {
        int count = value.length;
        byte[] cmnd = new byte[2 * count + 1 + 12 + 2];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)((short)count), (byte[])cmnd, (int)10);
        cmnd[12] = (byte)(2 * count);
        int j = 0;
        while (j < count) {
            Convert.shortToBytesBE((short)value[j], (byte[])cmnd, (int)(2 * j + 1 + 12));
            ++j;
        }
        this.send(dAddr, (byte)16, cmnd, this.resp, this.timeout);
    }

    public synchronized void writeCoils(short dAddr, short cNmbr, short count, byte[] value) throws DriverException {
        int nbyte = (count + 7) / 8;
        byte[] cmnd = new byte[nbyte + 1 + 12 + 2];
        Convert.shortToBytesBE((short)((short)(cNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        cmnd[12] = (byte)nbyte;
        System.arraycopy(value, 0, cmnd, 13, nbyte);
        this.send(dAddr, (byte)15, cmnd, this.resp, this.timeout);
    }

    private int send(short addr, byte func, byte[] cmnd, byte[] resp, int timeout) throws DriverException {
        this.checkOpen();
        short s = this.tranId;
        this.tranId = (short)(s + 1);
        Convert.shortToBytesBE((short)s, (byte[])cmnd, (int)0);
        cmnd[6] = (byte)addr;
        cmnd[7] = func;
        int leng = this.io.send(cmnd, resp, timeout);
        if ((resp[6] & 0xFF) != addr) {
            throw new DriverException("Invalid reply address");
        }
        if ((resp[7] & 0x7F) != func) {
            throw new DriverException("Invalid reply function code");
        }
        if ((resp[7] & 0x80) != 0) {
            String message;
            byte code = resp[8];
            switch (code) {
                case 1: {
                    message = "illegal function";
                    break;
                }
                case 2: {
                    message = "illegal data address";
                    break;
                }
                case 3: {
                    message = "illegal data value";
                    break;
                }
                case 4: {
                    message = "server device failure";
                    break;
                }
                case 6: {
                    message = "server device busy";
                    break;
                }
                default: {
                    message = "unknown code (" + code + ")";
                }
            }
            throw new DriverException("Reply exception: " + message);
        }
        return leng;
    }
}

