/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.utilities.logging.Logger;

@Table(uniqueConstraints={@UniqueConstraint(columnNames={"descriptionId", "category", "configName", "version"})}, indexes={@Index(columnList="checkSum")})
@Entity
public class Configuration
implements Serializable {
    private static final long serialVersionUID = 672642551238249224L;
    private long id;
    private Description description;
    private String category;
    private String configNameForCategory;
    private Map<ParameterPath, ConfigurationParameterValue> parameterConfigurations = new HashMap<ParameterPath, ConfigurationParameterValue>();
    private long tsaved;
    private int version;
    private boolean defaultVersion;
    private boolean latestVersion = true;
    private Long checkSum;

    protected Configuration() {
    }

    public Configuration(Description subsystemDescription, String category, String configName, long date) {
        this.description = subsystemDescription;
        this.category = category;
        this.configNameForCategory = configName;
        this.tsaved = date;
    }

    public Configuration(Description subsystemDescription, String category, String configName, long date, int version) {
        this(subsystemDescription, category, configName, date);
        this.version = version;
    }

    public Configuration(Configuration other, String newName, long date, int version) {
        this(other.getDescription(), other.getCategory(), newName == null ? other.getConfigName() : newName, date, version);
        this.parameterConfigurations.putAll(other.getConfigurationParameterValues());
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description subsystemDesc) {
        this.description = subsystemDesc;
    }

    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKeyJoinColumn(name="configurationParameter_parameterPath")
    public Map<ParameterPath, ConfigurationParameterValue> getConfigurationParameterValues() {
        return this.parameterConfigurations;
    }

    void setConfigurationParameterValues(Map<ParameterPath, ConfigurationParameterValue> parameterConfigurations) {
        this.parameterConfigurations = parameterConfigurations;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getConfigName() {
        return this.configNameForCategory;
    }

    public void setConfigName(String configName) {
        this.configNameForCategory = configName;
    }

    public long getTsaved() {
        return this.tsaved;
    }

    public void setTsaved(long tsaved) {
        this.tsaved = tsaved;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public boolean isLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    public void setCheckSum(Long sha) {
        this.checkSum = sha;
    }

    public Long getCheckSum() {
        return this.checkSum;
    }

    @Transient
    public String getConfigurationDescriptionString() {
        return this.category + ":" + this.configNameForCategory + "(" + this.version + ")";
    }

    public void addConfigurationParameterValue(ConfigurationParameterValue parameterConfiguration) {
        ConfigurationParameter cp = parameterConfiguration.getConfigurationParameter();
        if (cp.getCategory().equals(this.getCategory())) {
            this.parameterConfigurations.put(parameterConfiguration.getPath(), parameterConfiguration);
        } else {
            Logger.getLogger((String)"org.lsst.ccs.config").warn((Object)("The property " + cp.getPath().getParameterName() + " does not belong to the category specified by the property file name : " + this.getCategory()));
        }
    }

    public String getValue(ParameterPath path) {
        ConfigurationParameterValue cpv = this.parameterConfigurations.get(path);
        if (cpv == null) {
            return null;
        }
        return cpv.getValue();
    }

    public String toString() {
        return "\"" + this.category + "\":\"" + this.configNameForCategory + "\"(" + this.version + ")";
    }
}

