/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.metrology.AerotechDevice;
import org.lsst.ccs.subsystem.metrology.data.MetrologyState;
import org.lsst.ccs.utilities.logging.Logger;

public class AerotechP165Device
extends Device
implements AerotechDevice {
    protected String host = null;
    protected int port = 0;
    MetrologyState.pwrstates kstate = MetrologyState.pwrstates.NOTCONFIGURED;
    double xOffset = -300.0;
    double yOffset = -200.0;
    double zOffset = -100.0;
    double lastPosx;
    double lastPosy;
    double lastPosz;
    private final AerotechPro165 devaero = new AerotechPro165();

    protected void initDevice() {
        if (this.host == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"host", (String)"not defined");
        }
        this.fullName = "AerotechP165 (" + this.host + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.devaero.opennet(this.host, this.port);
                this.setOnline(true);
                this.initSensors();
                this.kstate = MetrologyState.pwrstates.OK;
                this.log.info((Object)("Connected to " + this.fullName));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.devaero.close();
            this.kstate = MetrologyState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        switch (chan) {
            case 0: {
                value = this.lastPosx;
                break;
            }
            case 1: {
                value = this.lastPosy;
                break;
            }
            case 2: {
                value = this.lastPosz;
            }
        }
        return value;
    }

    @Override
    @Command(description="return the x offset")
    public double getxOffset() {
        return this.xOffset;
    }

    @Override
    @Command(description="set the x offset")
    public void setxOffset(@Argument(description="offset in user units") double xoff) {
        this.xOffset = xoff;
    }

    @Override
    @Command(description="return the y offset")
    public double getyOffset() {
        return this.yOffset;
    }

    @Override
    @Command(description="set the y offset")
    public void setyOffset(@Argument(description="offset in user units") double yoff) {
        this.yOffset = yoff;
    }

    @Override
    @Command(description="return the z offset")
    public double getzOffset() {
        return this.zOffset;
    }

    @Override
    @Command(description="set the z offset")
    public void setzOffset(@Argument(description="offset in user units") double zoff) {
        this.zOffset = zoff;
    }

    @Override
    @Command(description="return controller version")
    public String getVersion() throws DriverException {
        return this.devaero.getVersion();
    }

    @Override
    @Command(description="abort motion")
    public void abort() throws DriverException {
        this.devaero.abort();
    }

    @Override
    @Command(description="enable axes")
    public void enableAxes() throws DriverException {
        this.log.debug((Object)"Enabling X axis");
        this.devaero.enableAxis('X');
        this.sleep(1.0);
        this.log.debug((Object)"Enabling Y axis");
        this.devaero.enableAxis('Y');
        this.sleep(1.0);
        this.log.debug((Object)"Enabling Z axis");
        this.devaero.enableAxis('Z');
    }

    @Override
    @Command(description="disable axes")
    public void disableAxes() throws DriverException {
        this.log.debug((Object)"Disabling X axis");
        this.devaero.disableAxis('X');
        this.sleep(1.0);
        this.log.debug((Object)"Disabling Y axis");
        this.devaero.disableAxis('Y');
        this.sleep(1.0);
        this.log.debug((Object)"Disabling Z axis");
        this.devaero.disableAxis('Z');
    }

    private void sleep(double secs) {
        try {
            long millis = (long)(secs * 1000.0);
            this.log.debug((Object)("Sleeping for " + millis + " millis"));
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            this.log.error((Object)("Rude awakening!" + ex));
        }
    }

    @Override
    @Command(description="setSpeed")
    public void setSpeed(@Argument(description="step / s") double velocity) throws DriverException {
        this.devaero.setSpeed(velocity);
    }

    @Override
    @Command(description="rampRate")
    public void rampRate(@Argument(description="step / s2") double rate) throws DriverException {
        this.devaero.rampMode("RATE");
        this.devaero.rampRate(rate);
    }

    @Override
    @Command(description="move incrementally in x")
    public void moveIncX(@Argument(description="amount to move in user units") double dx) throws DriverException {
        this.devaero.moveIncX(dx);
    }

    @Override
    @Command(description="move incrementally in y")
    public void moveIncY(@Argument(description="amount to move in user units") double dy) throws DriverException {
        this.devaero.moveIncY(dy);
    }

    @Override
    @Command(description="move incrementally in z")
    public void moveIncZ(@Argument(description="amount to move in user units") double dz) throws DriverException {
        this.devaero.moveIncZ(dz);
    }

    @Override
    @Command(description="move incrementally in x and y")
    public void moveIncXY(@Argument(description="amount to move in user units") double dx, @Argument(description="amount to move in user units") double dy) throws DriverException {
        this.devaero.moveInc(dx, dy);
    }

    @Override
    @Command(description="move incrementally in x, y and z")
    public void moveIncXYZ(@Argument(description="amount to move in user units") double dx, @Argument(description="amount to move in user units") double dy, @Argument(description="amount to move in user units") double dz) throws DriverException {
        this.devaero.moveInc(dx, dy, dz);
    }

    @Override
    @Command(description="move absolutely in x")
    public void moveAbsX(@Argument(description="x position in user units") double x) throws DriverException {
        this.devaero.moveAbsX(x);
    }

    @Override
    @Command(description="move absolutely in y")
    public void moveAbsY(@Argument(description="y position in user units") double y) throws DriverException {
        this.devaero.moveAbsY(y);
    }

    @Override
    @Command(description="move absolutely in z")
    public void moveAbsZ(@Argument(description="z position in user units") double z) throws DriverException {
        this.devaero.moveAbsZ(z);
    }

    @Override
    @Command(description="move absolutely in x and y")
    public void moveAbsXY(@Argument(description="x position in user units") double x, @Argument(description="y position in user units") double y) throws DriverException {
        this.devaero.moveAbs(x, y);
    }

    @Override
    @Command(description="move absolutely in x, y and z")
    public void moveAbsXYZ(@Argument(description="x position in user units") double x, @Argument(description="y position in user units") double y, @Argument(description="z position in user units") double z) throws DriverException {
        this.devaero.moveAbs(x, y, z);
    }

    @Override
    @Command(description="returns position in x, y and z")
    public double[] getPosXYZ() throws DriverException {
        double[] p = new double[]{this.getPosX(), this.getPosY(), this.getPosZ()};
        this.lastPosx = p[0];
        this.lastPosy = p[1];
        this.lastPosz = p[2];
        return p;
    }

    @Override
    @Command(description="returns position in x")
    public double getPosX() throws DriverException {
        double xmeas = Double.NaN;
        while (Double.isNaN(xmeas)) {
            xmeas = this.devaero.getPosX();
            if (!Double.isNaN(xmeas)) continue;
            this.log.debug((Object)"Waiting for x position value to become available");
        }
        this.lastPosx = xmeas -= this.xOffset;
        return this.lastPosx;
    }

    @Override
    @Command(description="returns position in y")
    public double getPosY() throws DriverException {
        double ymeas = Double.NaN;
        while (Double.isNaN(ymeas)) {
            ymeas = this.devaero.getPosY();
            if (!Double.isNaN(ymeas)) continue;
            this.log.debug((Object)"Waiting for y position value to become available");
        }
        this.lastPosy = ymeas -= this.yOffset;
        return this.lastPosy;
    }

    @Override
    @Command(description="returns position in z")
    public double getPosZ() throws DriverException {
        double zmeas = Double.NaN;
        while (Double.isNaN(zmeas)) {
            zmeas = this.devaero.getPosZ();
            if (!Double.isNaN(zmeas)) continue;
            this.log.debug((Object)"Waiting for z position value to become available");
        }
        this.lastPosz = zmeas -= this.zOffset;
        return this.lastPosz;
    }

    @Command(description="generic write", level=10)
    public String aerotechChat(@Argument(name="command", description="The raw Aerotech command") String command) throws DriverException {
        return this.devaero.read(command);
    }

    @Override
    public double getLastPosX() {
        return this.lastPosx;
    }

    @Override
    public double getLastPosY() {
        return this.lastPosy;
    }

    @Override
    public double getLastPosZ() {
        return this.lastPosz;
    }

    @Override
    @Command(description="returns any axis fault messages")
    public String getError() throws DriverException {
        return this.devaero.getError();
    }

    @Override
    @Command(description="goes to home position")
    public void goHome() throws DriverException {
        this.devaero.goHome();
        double new_xOffset = this.xOffset;
        double new_yOffset = this.yOffset;
        double new_zOffset = this.zOffset;
        this.xOffset = new_xOffset;
        this.yOffset = new_yOffset;
        this.zOffset = new_zOffset;
        this.log.error((Object)("Offsets determined from home position are (" + this.xOffset + "," + this.yOffset + "," + this.zOffset + ")"));
    }

    @Override
    @Command(description="setup homing mode")
    public void setupHome(int mode) throws DriverException {
        this.devaero.setupHome(mode);
    }

    @Override
    @Command(description="setup low position limit")
    public void softLowLim(String axis, int param) throws DriverException {
        this.devaero.softLowLim(axis, param);
    }

    @Override
    @Command(description="setup high position limit")
    public void softHighLim(String axis, int param) throws DriverException {
        this.devaero.softHighLim(axis, param);
    }

    @Override
    @Command(description="clears all fault messages")
    public void reset() throws DriverException {
        this.devaero.reset();
    }

    @Override
    @Command(description="reset controller")
    public void fullreset() throws DriverException {
        this.devaero.fullreset();
        this.log.error((Object)"trying to reopen the connection");
        this.reconnect();
    }

    @Override
    @Command(description="reconnect to controller")
    public void reconnect() {
        this.setOnline(false);
    }

    @Command(name="setstate", description="set AerotechP165 device status")
    public void setState(int istate) {
        this.kstate = MetrologyState.pwrstates.values()[istate];
    }

    @Command(name="getstate", description="get AerotechP165 device status")
    public int getState() {
        return this.kstate.ordinal();
    }
}

