/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.utility.PlutoDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class PlutoControl
extends Control {
    private static final int TYPE_BIT = 0;
    private static final int TYPE_REG = 1;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private String type;
    private double offset = 0.0;
    private double scale = 1.0;
    private final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private final PlutoDevice pDevc = (PlutoDevice)this.devc;
    private int iType;
    private int area;

    protected void configure(Monitor mon, Device devc) {
        int maxChan;
        super.configure(mon, devc);
        if (this.type == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.getName(), (String)"type", (String)"not specified");
        }
        Integer iTyp = null;
        String[] typeFields = this.type.split(":", -1);
        if (typeFields.length == 2) {
            iTyp = typeMap.get(typeFields[0].toUpperCase());
        }
        try {
            this.area = Integer.decode(typeFields[1]);
        }
        catch (NumberFormatException e) {
            this.area = -1;
        }
        if (iTyp == null || this.area < 0 || this.area >= 4) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.getName(), (String)"type", (String)"has invalid value");
        }
        this.iType = iTyp;
        int n = maxChan = this.iType == 0 ? 16 : 2;
        if (this.hwChan >= maxChan) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.getName(), (String)"hwchan", (String)"has invalid value");
        }
    }

    public void writeValue(double value) {
        int ival = (int)((value - this.offset) / this.scale);
        if (this.iType == 0) {
            this.pDevc.writeBit(this.area, this.hwChan, ival);
        } else {
            this.pDevc.writeRegister(this.area, this.hwChan, ival);
        }
    }

    static {
        typeMap.put("BIT", 0);
        typeMap.put("REG", 1);
    }
}

