/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mks;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.GP390;
import org.lsst.ccs.drivers.scpi.Scpi;

public class GP835
extends Scpi
implements GP390.HardComm {
    private static final double UNAVAIL_VALUE = 9.91E37;
    private static final double SHORT_TIMEOUT = 1.0;
    private static final double LONG_TIMEOUT = 10.0;
    private final int gp390Address = 2;
    private final String gp390Format = "SYST:COMM:SER:ACOM? 2,\"%s\"";
    private boolean DEBUG = false;
    private final GP390 gp390 = new GP390();

    public GP835() {
        super(Ascii.Option.NO_NET);
    }

    public void open(DriverConstants.ConnType connType, String ident, int parm1, int parm2) throws DriverException {
        super.open(connType, ident, parm1, parm2);
        this.setTerminator(Ascii.Terminator.CR);
        this.setTimeout(1.0);
        this.checkIdentification(null, 3, "835", 3);
        this.gp390.setCommHandler(this);
        this.gp390.setAddress(2);
    }

    public void open(String serialname) throws DriverException {
        this.open(DriverConstants.ConnType.SERIAL, serialname, 0);
    }

    public void openftdi(String serialname) throws DriverException {
        this.open(DriverConstants.ConnType.FTDI, serialname, 0);
    }

    public double getPressure() throws DriverException {
        this.writeCommand("INST ETPR");
        double value = this.readDouble("MEAS:PRES?");
        return value == 9.91E37 ? Double.NaN : value;
    }

    public double getPressureGP390() throws DriverException {
        return this.gp390.readPressure();
    }

    public double getFilamentPower() throws DriverException {
        this.writeCommand("INST FIL");
        return this.readDouble("MEAS:POW?");
    }

    public String getMSP() throws DriverException {
        this.writeCommand("INST MSP");
        return this.readString("FORM:AMU ON;FORM:COUNT ON;OUTP ON ;INIT;FETC?");
    }

    public String getTestReport() throws DriverException {
        return this.readString("TEST:REP?");
    }

    public String getInstrument() throws DriverException {
        return this.readString("INST?");
    }

    public void setGaugeOn() throws DriverException {
        this.setTimeout(10.0);
        this.writeCommand("INST ETPR");
        this.writeCommand("OUTP ON");
        this.setTimeout(1.0);
    }

    public void setGaugeOff() throws DriverException {
        this.writeCommand("INST ETPR");
        this.writeCommand("OUTP OFF");
    }

    public boolean isGaugeOn() throws DriverException {
        this.writeCommand("INST ETPR");
        return this.readInteger("OUTP?") == 1;
    }

    public void setFilamentOn() throws DriverException {
        this.gp390.setMiGaugeOn(true);
    }

    public void setFilamentOff() throws DriverException {
        this.gp390.setMiGaugeOn(false);
    }

    public boolean isFilamentOn() throws DriverException {
        return this.gp390.isMiGaugeOn();
    }

    public void setRelayTrip(int relay, int type, double value) throws DriverException {
        this.gp390.setRelayTrip(relay, type, value);
    }

    public double getRelayTrip(int relay, int type) throws DriverException {
        return this.gp390.getRelayTrip(relay, type);
    }

    public void assignRelay(int relay, int assign) throws DriverException {
        this.gp390.assignRelay(relay, assign);
    }

    public int getRelayAssignment(int relay) throws DriverException {
        return this.gp390.getRelayAssignment(relay);
    }

    public void enableRelay(int relay, boolean enable) throws DriverException {
        this.gp390.enableRelay(relay, enable);
    }

    public boolean isRelayEnabled(int relay) throws DriverException {
        return this.gp390.isRelayEnabled(relay);
    }

    public boolean isRelayActive(int relay) throws DriverException {
        return this.gp390.isRelayActive(relay);
    }

    public void setMSPOn() throws DriverException {
        this.setTimeout(10.0);
        this.writeCommand("INST MSP");
        this.writeCommand("OUTP ON");
        this.setTimeout(1.0);
    }

    public void setMSPOff() throws DriverException {
        this.writeCommand("INST MSP");
        this.writeCommand("OUTP OFF");
    }

    public double[][] readAMU() throws DriverException {
        double[][] amuarray = new double[5000][2];
        String buff = this.getMSP();
        int blen = buff.length();
        int ichar = 0;
        int icrv = buff.indexOf(" CURVE ");
        if (icrv > 0) {
            int istart = buff.indexOf(" VALues ");
            if (istart > 0) {
                istart += 8;
            }
            ichar = istart;
            ByteBuffer curv = ByteBuffer.wrap(buff.substring(istart).getBytes());
            curv.order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer mspdat = curv.asShortBuffer();
            int idx = 0;
            while (ichar + 1 < blen) {
                double val;
                char thischar = buff.charAt(ichar);
                char nextchar = buff.charAt(ichar + 1);
                if (thischar == '\n' || nextchar == '\n') break;
                amuarray[idx][1] = val = (double)mspdat.get();
                ++idx;
                ichar += 2;
                System.out.println("ADC count = " + val);
            }
        }
        return amuarray;
    }

    public double[][] readDoublePairArray(String command) throws DriverException {
        try {
            if (this.DEBUG) {
                System.out.println("Doing String Array read.");
            }
            String[] reply = this.readStringArray(command);
            if (this.DEBUG) {
                System.out.println("Retrieved string of values from buffer. length = " + reply.length);
            }
            double[][] dReply = new double[2][reply.length / 2];
            int ridx = 0;
            for (int j = 0; j < reply.length; j += 2) {
                dReply[0][ridx] = Double.valueOf(reply[j]);
                dReply[1][ridx] = Double.valueOf(reply[j + 1]);
                ++ridx;
            }
            if (this.DEBUG) {
                System.out.println("Binary array prepared.");
            }
            return dReply;
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void checkOpenGP390() {
    }

    @Override
    public String readGP390(String cmnd) throws DriverException {
        String value = this.readString(String.format("SYST:COMM:SER:ACOM? 2,\"%s\"", cmnd)).split(" *!")[0];
        if (value.isEmpty()) {
            throw new DriverException("Vacuum gauge is turned off");
        }
        return value;
    }
}

