/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.localdb.statusdb.utils.CacheStatistics;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.startup.HasCommandLineOptions;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusPersisterSubsystem
extends Subsystem
implements HasCommandLineOptions {
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    private static SessionFactory fac;
    private Properties p;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPeriodicTaskService periodicTaskService;
    private final Options commandLineOptions = new Options();

    private static synchronized void init(Properties p) {
        fac = StatusdbUtils.getSessionFactory((Properties)p);
    }

    public StatusPersisterSubsystem() {
        super("localdb", AgentInfo.AgentType.SERVICE);
        if (this.p == null) {
            this.p = BootstrapResourceUtils.getBootstrapSystemProperties();
        }
        this.commandLineOptions.addOption("u", "update", false, "Start the Trending Ingest Module in update mode.");
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("statistics-publish", () -> this.publishSubsystemDataOnStatusBus(new KeyValueData("statistics", (Serializable)new CacheStatistics(fac)))).withIsFixedRate(true).withPeriod(Duration.ofMinutes(1L)));
    }

    public void init() {
        StatusPersisterSubsystem.init(this.p);
    }

    public void startAgent() {
        Session sess = fac.openSession();
        SQLQuery somethingToMigrate = sess.createSQLQuery("select count(*) from ccs_agentSt_innerStDe_b");
        int nEntries = ((BigInteger)somethingToMigrate.uniqueResult()).intValue();
        sess.close();
        if (nEntries > 0) {
            throw new RuntimeException("localdb cannot start because the MigrateAgentStates application has not been run yet.");
        }
        super.startAgent();
    }

    public void processCommandLineOptions(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.commandLineOptions, args, false);
            if (line.hasOption("update")) {
                this.p.setProperty("hibernate.hbm2ddl.auto", "update");
            }
        }
        catch (Exception e) {
            this.printHelp();
        }
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "TrendingIngestModule", "", this.commandLineOptions, "", true);
    }
}

