/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IManagedObject;
import hep.aida.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import nom.tam.fits.FitsException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.subsystem.rafts.GlobalVisualizationClient;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.pattern.FileNamePatternUtils;

public class ImageProc {
    private static final int[] DATA_SEGMENT_MAP = new int[]{15, 14, 13, 12, 11, 10, 9, 8, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] INV_DATA_SEGMENT_MAP = new int[DATA_SEGMENT_MAP.length];
    private static final int NUM_ADCS = 16;
    private static final int DATA_MASK_STRAIGHT = 131072;
    private static final int DATA_MASK_INVERTED = 131071;
    private final IDataPointSetFactory dpsf = IAnalysisFactory.create().createDataPointSetFactory(null);
    private REBDevice reb;
    private Subsystem subsys;
    private Logger log;
    private int ccdMask;
    private int numCcds;
    private int numRebCcds;
    private Image currImage = new Image();
    private ByteBuffer[][] currImageBuffer;
    private RaftException currImageExcp = new RaftException("No image data available");
    private int fitsSeqnum;
    private boolean externalSequenceNumber = false;
    private long imageTime;
    private boolean scanMode;
    private String defaultDirectory = ".";
    private String fitsFileNamePattern = "Image_${rebName}_${sensorId}_${timestamp}.fits";
    private String imageDataFileNamePattern = "Image_${rebName}_${timestamp}.dat";
    private final Properties fileNamePatternProperties = new Properties();
    private Reb rebGeometry;
    private volatile ReadOutParameters readOutParameters;
    private int dataInversionMask = 131071;
    private final ImageProcFitsHeaderMetadataProvider metadataProvider = new ImageProcFitsHeaderMetadataProvider();
    private GlobalVisualizationClient globalVisualizationClient;
    private static final int[][] CCD_MAP;

    public ImageProc(ImageClient imc) {
        imc.setListener((ImageClient.Listener)new GetImage(), this.currImage);
        this.fileNamePatternProperties.setProperty("raftLoc", "99");
    }

    public void configure(REBDevice reb, Subsystem subsys, Logger log) {
        this.reb = reb;
        this.log = log;
        this.subsys = subsys;
        this.fileNamePatternProperties.setProperty("rebName", reb.getName());
    }

    void setGlobalVisualizationClient(GlobalVisualizationClient globalVisualizationClient) {
        this.globalVisualizationClient = globalVisualizationClient;
    }

    @Deprecated
    public void configure(String rebName, int rebId, Subsystem subsys, Logger log) {
        this.log = log;
        this.subsys = subsys;
        this.fileNamePatternProperties.setProperty("rebName", rebName);
    }

    void setPatternProperty(String propertyName, String propertyValue) {
        this.fileNamePatternProperties.setProperty(propertyName, propertyValue);
    }

    public void enableScan(boolean enable) {
        this.scanMode = enable;
    }

    public void setCcdMask(int ccdMask) {
        this.ccdMask = ccdMask;
        this.numCcds = Integer.bitCount(this.ccdMask);
    }

    public void setNumRebCcds(int numRebCcds) {
        this.numRebCcds = numRebCcds;
    }

    public void setRebGeometry(Reb reb) {
        this.rebGeometry = reb;
    }

    public void setDataInversion(boolean invert) {
        this.dataInversionMask = invert ? 131071 : 131072;
    }

    public String saveImage(String dName) throws RaftException, IOException {
        if ((this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(0)) == null) {
            throw new RaftException("Image contains no valid data");
        }
        String dirName = (dName == null || dName.isEmpty() ? this.defaultDirectory : dName) + "/";
        String filName = FileNamePatternUtils.resolveFileName((String)this.imageDataFileNamePattern, (Properties)this.fileNamePatternProperties);
        String shortFileName = Paths.get(filName, new String[0]).getFileName().toString();
        this.setFitsFileName(shortFileName);
        try (FileOutputStream ofs = new FileOutputStream(dirName + filName);){
            if (this.currImage.isInterleaved()) {
                ofs.getChannel().write(this.currImage.getData());
            } else {
                for (int ccd = 0; ccd < this.numCcds; ++ccd) {
                    ofs.getChannel().write(this.currImage.getData(ccd));
                }
            }
        }
        return filName;
    }

    void setExternalSequenceNumber(int sequenceNumber) {
        this.fitsSeqnum = sequenceNumber;
        this.externalSequenceNumber = true;
    }

    public List<String> saveFitsImage(String dName, FitsHeaderMetadataProvider provider) throws IOException, RaftException {
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        int numberOfColumns = this.readOutParameters.getSerialReadPixels();
        int numberOfRows = this.readOutParameters.getParallelReadPixels();
        if (this.currImageBuffer[0][0].limit() != 4 * numberOfColumns * numberOfRows) {
            throw new RaftException("Image size is inconsistent with slice count. Size: " + this.currImageBuffer[0][0].limit() / 4 + ", expected: " + numberOfColumns * numberOfRows + " (" + numberOfColumns + "x" + numberOfRows + ")");
        }
        ArrayList<String> names = new ArrayList<String>();
        String dirPatt = (dName == null || dName.isEmpty() ? this.defaultDirectory : dName) + "/";
        for (int ccd = 0; ccd < this.numCcds; ++ccd) {
            FitsFileWriter writer;
            int n;
            CCD ccdGeometry = (CCD)this.rebGeometry.getChild(0, ccd);
            DefaultImageSet imageSet = new DefaultImageSet(ccdGeometry, this.readOutParameters);
            if (this.externalSequenceNumber) {
                n = this.fitsSeqnum;
            } else {
                n = this.fitsSeqnum + 1;
                this.fitsSeqnum = this.fitsSeqnum;
            }
            int seqNumber = n;
            this.metadataProvider.setSequenceNumber(seqNumber);
            this.metadataProvider.setImageDates(System.currentTimeMillis(), this.imageTime);
            ArrayList<FitsHeaderMetadataProvider> providers = new ArrayList<FitsHeaderMetadataProvider>();
            providers.add(this.metadataProvider);
            if (provider != null) {
                providers.add(provider);
            }
            Properties resolverProperties = this.getPropertiesFromMetadataProviders(providers, (ImageSet)imageSet);
            this.fileNamePatternProperties.setProperty("sensorId", String.valueOf(ccd));
            this.fileNamePatternProperties.setProperty("sensorLoc", String.valueOf(this.reb.getRebNumber()) + String.valueOf(ccd));
            try {
                this.fileNamePatternProperties.setProperty("testType", resolverProperties.getProperty("TestType").toLowerCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.fileNamePatternProperties.setProperty("imageType", resolverProperties.getProperty("ImageType").toLowerCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            resolverProperties.putAll((Map<?, ?>)this.fileNamePatternProperties);
            String fileName = FileNamePatternUtils.resolveFileName((String)this.fitsFileNamePattern, (Properties)resolverProperties);
            String shortFileName = Paths.get(fileName, new String[0]).getFileName().toString();
            this.setFitsFileName(shortFileName);
            String dirName = FileNamePatternUtils.resolveFileName((String)dirPatt, (Properties)resolverProperties);
            File file = new File(dirName, fileName);
            file.getParentFile().mkdirs();
            try {
                writer = new FitsFileWriter(file, (ImageSet)imageSet, providers);
            }
            catch (FitsException e) {
                throw new RaftException("FITS error: " + (Object)((Object)e));
            }
            for (int adc = 0; adc < 16; ++adc) {
                ByteBuffer buff = this.currImageBuffer[ccd][adc];
                buff.rewind();
                writer.write(DATA_SEGMENT_MAP[adc], buff);
            }
            writer.close();
            names.add(file.getName());
        }
        return names;
    }

    public List<String> saveFitsImage(String dName) throws IOException, RaftException {
        return this.saveFitsImage(dName, null);
    }

    private Properties getPropertiesFromMetadataProviders(List<FitsHeaderMetadataProvider> providers, ImageSet imageSet) {
        Properties p = new Properties();
        for (FitsHeaderMetadataProvider provider : providers) {
            p.putAll((Map<?, ?>)provider.getPrimaryHeaderMetadata(imageSet).convertToProperties());
        }
        return p;
    }

    public ImageMetadata getImageMetadata() throws RaftException {
        return this.currImage.getMetadata();
    }

    public ImageData getImage(int ccd, int offset, int count) throws RaftException {
        if ((this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(0)) == null) {
            throw new RaftException("Image contains no valid data");
        }
        int length = count;
        int iLength = this.currImage.getLength();
        if (length < 0 || offset < 0 || offset >= iLength) {
            throw new RaftException("Invalid length or offset");
        }
        if (length == 0 || length + offset > iLength) {
            length = iLength - offset;
        }
        int[] data = new int[length];
        ByteBuffer buff = this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(ccd);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.position(4 * offset);
        buff.asIntBuffer().get(data);
        return new ImageData(this.currImage.getTimestamp(), offset, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImageData getImage(String fileName, int offset, int count) throws RaftException, IOException {
        MappedByteBuffer buff;
        offset *= 4;
        int length = 4 * count;
        try (FileInputStream ifs = new FileInputStream(fileName);){
            FileChannel chan = ifs.getChannel();
            long iLength = chan.size();
            if (length < 0 || offset < 0 || (long)offset >= iLength) {
                throw new RaftException("Invalid length or offset");
            }
            if (length == 0 || (long)(length + offset) > iLength) {
                length = (int)(iLength - (long)offset);
            }
            buff = chan.map(FileChannel.MapMode.READ_ONLY, offset, length);
        }
        int[] data = new int[length / 4];
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.asIntBuffer().get(data);
        return new ImageData(0L, offset / 4, data);
    }

    public double[][] getImageStats() throws RaftException {
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        double[][] stats = new double[this.numCcds * 16][2];
        for (int ccd = 0; ccd < this.numCcds; ++ccd) {
            for (int adc = 0; adc < 16; ++adc) {
                double sum = 0.0;
                double sumSq = 0.0;
                ByteBuffer buff = this.currImageBuffer[ccd][adc];
                int count = buff.limit() / 4;
                for (int k = 0; k < count; ++k) {
                    double value = buff.getInt();
                    sum += value;
                    sumSq += value * value;
                }
                double avg = sum / (double)count;
                int j = ccd * 16 + adc;
                stats[j][0] = avg;
                stats[j][1] = Math.sqrt(sumSq / (double)count - avg * avg);
            }
        }
        return stats;
    }

    public ByteBuffer[][] splitImage() throws RaftException {
        int adc;
        int ccd;
        int adc2;
        int buffSegs;
        ByteBuffer data;
        ByteBuffer byteBuffer = data = this.currImage.isInterleaved() ? this.currImage.getData() : this.currImage.getData(0);
        if (data == null || this.currImage.getStatus() != 0) {
            throw new RaftException("Image contains no valid data");
        }
        int numSeg = this.numCcds * 16;
        int n = buffSegs = this.currImage.isInterleaved() ? numSeg : 16;
        if (data.limit() % (4 * buffSegs) != 0) {
            throw new RaftException("Invalid image size: " + data.limit());
        }
        int segSize = data.limit() / buffSegs;
        ByteBuffer[][] adata = new ByteBuffer[this.numCcds][16];
        for (int ccd2 = 0; ccd2 < this.numCcds; ++ccd2) {
            for (adc2 = 0; adc2 < 16; ++adc2) {
                adata[ccd2][adc2] = ByteBuffer.allocate(segSize);
            }
        }
        if (this.currImage.isInterleaved()) {
            data.order(ByteOrder.nativeOrder());
            for (int j = 0; j < segSize / 4; ++j) {
                for (ccd = 0; ccd < this.numCcds; ++ccd) {
                    int actCcd = this.reb.getRebType() != 0 ? ccd : this.numRebCcds - 1 - ccd;
                    for (adc = 0; adc < 16; ++adc) {
                        adata[actCcd][adc].putInt(data.getInt() ^ this.dataInversionMask);
                    }
                }
            }
        } else {
            ByteBuffer[] cdata = new ByteBuffer[this.numCcds];
            for (ccd = 0; ccd < this.numCcds; ++ccd) {
                cdata[ccd] = this.currImage.getData(ccd);
                cdata[ccd].order(ByteOrder.nativeOrder());
            }
            for (int j = 0; j < segSize / 4; ++j) {
                for (int ccd3 = 0; ccd3 < this.numCcds; ++ccd3) {
                    for (adc = 0; adc < 16; ++adc) {
                        adata[ccd3][adc].putInt(cdata[ccd3].getInt() ^ this.dataInversionMask);
                    }
                }
            }
        }
        for (int ccd4 = 0; ccd4 < this.numCcds; ++ccd4) {
            for (adc2 = 0; adc2 < 16; ++adc2) {
                adata[ccd4][adc2].flip();
            }
        }
        return adata;
    }

    public void setFitsConditions(String filter, double temperature, double wavelength) {
        this.metadataProvider.setFitsConditions(filter, temperature, wavelength);
    }

    protected void setConstFitsMetadata(long serial) {
        this.metadataProvider.setConstFitsMetadata(serial);
    }

    protected void setSequencerFileName(String name) {
        this.metadataProvider.setSequencerFileName(name);
        this.metadataProvider.setSeqFitsMetadata(name, 0.0, 0.0);
    }

    public void setFitsFileName(String fitsFileName) {
        this.metadataProvider.setFitsFileName(fitsFileName);
    }

    public void setExposureTime(double expTime) {
        this.metadataProvider.setExposureTime(expTime);
    }

    public void setDefaultImageDirectory(String dirName) {
        this.defaultDirectory = dirName == null || dirName.isEmpty() ? "." : dirName;
    }

    public void setFitsFileNamePattern(String pattern) {
        this.fitsFileNamePattern = pattern;
    }

    public void setImageDataFileNamePattern(String pattern) {
        this.imageDataFileNamePattern = pattern;
    }

    @Deprecated
    public void setFitsFileNamePatter(String fitsFileNamePattern) {
        this.fitsFileNamePattern = fitsFileNamePattern;
    }

    @Deprecated
    public void setImageDataFileNamePatter(String imageDataFileNamePattern) {
        this.imageDataFileNamePattern = imageDataFileNamePattern;
    }

    private static String timestampString(long tstamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(tstamp / 1000000L);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        return String.format("%tY%<tm%<td%<tH%<tM%<tS", cal);
    }

    private void analyzeImage(Segment segment, int ccdNum, int segNum, Map<String, Object> imageMetaData) throws RaftException {
        double stdev;
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        int daqCcdNum = CCD_MAP[ccdNum][this.ccdMask];
        if (daqCcdNum < 0) {
            throw new RaftException("Invalid CCD number: " + ccdNum + "; CCD mask = " + this.ccdMask);
        }
        ByteBuffer buff = this.currImageBuffer[daqCcdNum][INV_DATA_SEGMENT_MAP[segNum]];
        buff.rewind();
        double pix_sum_active = 0.0;
        double pix_sum_sq_active = 0.0;
        int npix_active = 0;
        double pix_sum_bias = 0.0;
        double pix_sum_sq_bias = 0.0;
        int npix_bias = 0;
        int numberOfColumns = this.readOutParameters.getSerialReadPixels();
        int numberOfRows = this.readOutParameters.getParallelReadPixels();
        int segmentSerialActiveSize = segment.getSegmentSerialActiveSize();
        int serialPrescan = this.readOutParameters.getSerialPrescan();
        for (int row = 1; row <= numberOfRows; ++row) {
            for (int col = 1; col <= numberOfColumns; ++col) {
                double pixval = buff.getInt();
                if (col > serialPrescan && col <= serialPrescan + segmentSerialActiveSize) {
                    pix_sum_active += pixval;
                    pix_sum_sq_active += pixval * pixval;
                    ++npix_active;
                    continue;
                }
                if (col <= serialPrescan + segmentSerialActiveSize) continue;
                pix_sum_bias += pixval;
                pix_sum_sq_bias += pixval * pixval;
                ++npix_bias;
            }
        }
        this.log.debug((Object)("Active " + npix_active + " Bias " + npix_bias + " PreCols " + serialPrescan + " ActiveSize " + segmentSerialActiveSize + " NCols " + numberOfColumns + " NRows " + numberOfRows));
        if (npix_active > 0) {
            double average = pix_sum_active / (double)npix_active;
            stdev = Math.sqrt(pix_sum_sq_active / (double)npix_active - average * average);
            this.log.debug((Object)("Adding AVERAGE " + average + " STDEV " + stdev));
            imageMetaData.put("AVERAGE", average);
            imageMetaData.put("STDEV", stdev);
        }
        if (npix_bias > 0) {
            double average = pix_sum_bias / (double)npix_bias;
            stdev = Math.sqrt(pix_sum_sq_bias / (double)npix_bias - average * average);
            this.log.debug((Object)("Adding AVGBIAS " + average + " STDVBIAS " + stdev));
            imageMetaData.put("AVGBIAS", average);
            imageMetaData.put("STDVBIAS", stdev);
        }
    }

    private ReadOutParameters createReadOutParametersFromRegistersMetadata(int[] registers) {
        CCDType ccdType = ((CCD)this.rebGeometry.getChildrenList().get(0)).getType();
        if (ccdType == null) {
            throw new RuntimeException("The CCD Type must have been set to evaluate Read Out Parameters");
        }
        int segRows = ccdType.getCCDGeometryConstants().getSegmentParallelActiveSize();
        int serCols = ccdType.getCCDGeometryConstants().getSegmentSerialActiveSize() + ccdType.getCCDGeometryConstants().getSegmentSerialPrescanSize();
        try {
            int preRows = registers[2];
            int readRows = registers[0];
            int postRows = registers[4];
            int overRows = registers[7];
            int preCols = registers[3];
            int readCols = registers[1];
            int postCols = registers[5];
            int readCols2 = registers[6];
            int overCols = registers[8];
            if (preRows == 0 && postRows == 0 && preCols == 0 && postCols == 0 && readCols2 == 0) {
                if (overRows == 0 && readRows > segRows) {
                    overRows = readRows - segRows;
                    readRows = segRows;
                }
                if (overCols == 0 && readCols > serCols) {
                    overCols = readCols - serCols;
                    readCols = serCols;
                }
            }
            if (readCols != 0 && readRows != 0) {
                return new ReadOutParameters(ccdType, preRows, readRows, postRows, overRows, preCols, readCols, postCols, readCols2, overCols);
            }
            this.log.info((Object)("Reverting back to default readout parameters " + readRows + " " + readCols));
            return new ReadOutParameters(ccdType);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.info((Object)("Got Exception: Reverting back to default readout parameters " + e.getMessage()));
            return new ReadOutParameters(ccdType);
        }
    }

    static /* synthetic */ ByteBuffer[][] access$402(ImageProc x0, ByteBuffer[][] x1) {
        x0.currImageBuffer = x1;
        return x1;
    }

    static {
        for (int j = 0; j < DATA_SEGMENT_MAP.length; ++j) {
            ImageProc.INV_DATA_SEGMENT_MAP[ImageProc.DATA_SEGMENT_MAP[j]] = j;
        }
        FitsHeadersSpecifications.addSpecFile((String)"Fits_primary_header.spec", (String)"primary");
        CCD_MAP = new int[][]{{-1, 0, -1, 0, -1, 0, -1, 0}, {-1, -1, 0, 1, -1, -1, 0, 1}, {-1, -1, -1, -1, 0, 1, 1, 2}};
    }

    private class ImageProcFitsHeaderMetadataProvider
    implements FitsHeaderMetadataProvider {
        private long obsvTime;
        private final Map<String, Object> sysMetadata = new HashMap<String, Object>();

        private ImageProcFitsHeaderMetadataProvider() {
        }

        public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
            if (ImageProc.this.rebGeometry.getChildrenList().contains(imageSet.getCCD())) {
                MetaDataSet ccdMetadataSet = new MetaDataSet();
                int j = imageSet.getCCD().getSerialPosition();
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("Tag", String.valueOf(this.obsvTime));
                ccdMetadataSet.addMetaDataMap("sys", this.sysMetadata);
                ccdMetadataSet.addMetaDataMap("ccd", metadata);
                return ccdMetadataSet;
            }
            return null;
        }

        public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
            if (ImageProc.this.rebGeometry.getChildrenList().contains(imageSet.getCCD())) {
                MetaDataSet segmentMetaDataSet = new MetaDataSet();
                HashMap metadata = new HashMap();
                try {
                    ImageProc.this.analyzeImage((Segment)imageSet.getCCD().getSegments().get(extendedIndex), imageSet.getCCD().getSerialPosition(), extendedIndex, metadata);
                }
                catch (RaftException ex) {
                    ImageProc.this.log.error((Object)ex);
                }
                segmentMetaDataSet.addMetaDataMap("sys", this.sysMetadata);
                segmentMetaDataSet.addMetaDataMap("seg", metadata);
                return segmentMetaDataSet;
            }
            return null;
        }

        public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
            return null;
        }

        private void setSequenceNumber(int seqnum) {
            this.sysMetadata.put("SequenceNumber", seqnum);
        }

        private void setImageDates(long fileTime, long obsvTime) {
            this.obsvTime = obsvTime;
            Date fileDate = new Date(fileTime);
            this.sysMetadata.put("FileCreationTime", fileDate);
            Date obsDate = new Date(obsvTime);
            this.sysMetadata.put("ObservationDate", obsDate);
        }

        private void setExposureTime(double expTime) {
            this.sysMetadata.put("ExposureTime", expTime);
        }

        private void setSeqFitsMetadata(String cfgName, double expTime, double delay) {
            this.sysMetadata.put("ExposureTime", expTime);
            this.sysMetadata.put("ShutterDelay", delay);
            this.sysMetadata.put("CCDControllerConfigFile", cfgName);
        }

        private void setFitsFileName(String fitsFileName) {
            this.sysMetadata.put("OriginalFileName", fitsFileName);
        }

        private void setConstFitsMetadata(long serial) {
            this.sysMetadata.put("CCDControllerSerial", String.format("%012x", serial));
        }

        private void setFitsConditions(String filter, double temperature, double wavelength) {
            this.sysMetadata.put("FilterName", filter);
            this.sysMetadata.put("TemperatureSetPoint", temperature);
            this.sysMetadata.put("MonochromatorWavelength", wavelength);
        }

        private void setSequencerFileName(String name) {
            this.sysMetadata.put("SequencerFileName", name);
        }
    }

    private class GetImage
    implements ImageClient.Listener {
        private GetImage() {
        }

        public void processImage(Image image) {
            ImageProc.this.currImage = image;
            ImageProc.this.log.info((Object)("Received image: Reb = " + ImageProc.this.reb.getName() + ", Name = " + ImageProc.this.currImage.getName() + ", Length = " + ImageProc.this.currImage.getLength() + ", Status = " + ImageProc.this.currImage.getStatus()));
            try {
                ImageProc.access$402(ImageProc.this, ImageProc.this.splitImage());
                ImageProc.this.currImageExcp = null;
            }
            catch (RaftException e) {
                ImageProc.this.log.error((Object)e.getMessage());
                ImageProc.access$402(ImageProc.this, null);
                ImageProc.this.currImageExcp = e;
                return;
            }
            ImageProc.this.imageTime = ImageProc.this.currImage.getTimestamp() / 1000000L;
            ImageProc.this.fileNamePatternProperties.setProperty("timestamp", ImageProc.timestampString(ImageProc.this.currImage.getTimestamp()));
            ImageProc.this.readOutParameters = ImageProc.this.createReadOutParametersFromRegistersMetadata(image.getRegisters());
            ImageState iState = new ImageState(ImageProc.this.currImage.getTimestamp(), ImageProc.this.currImage.getLength());
            KeyValueData kvd = new KeyValueData("ImageState", (Serializable)iState);
            ImageProc.this.subsys.publishSubsystemDataOnStatusBus(kvd);
            try {
                if (ImageProc.this.globalVisualizationClient != null && ImageProc.this.globalVisualizationClient.isConnected()) {
                    for (int ccd = 0; ccd < ImageProc.this.numCcds; ++ccd) {
                        CCD ccdGeometry = (CCD)ImageProc.this.rebGeometry.getChild(0, ccd);
                        ByteBuffer ccdData = ByteBuffer.allocate(ImageProc.this.readOutParameters.getTotalParallelSize() * ImageProc.this.readOutParameters.getTotalSerialSize() * 16 * 4);
                        for (int adc = 0; adc < 16; ++adc) {
                            ByteBuffer buff = ImageProc.this.currImageBuffer[ccd][adc];
                            ccdData.put(buff);
                            buff.rewind();
                        }
                        ccdData.rewind();
                        ImageProc.this.log.debug((Object)("Sending image data " + image.getName()));
                        ImageProc.this.globalVisualizationClient.sendImageData(image.getMetadata(), ccdData, ccdGeometry, ImageProc.this.readOutParameters);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ImageProc.this.scanMode) {
                if (ImageProc.this.currImageBuffer[0][0].limit() % 1024 != 0) {
                    ImageProc.this.log.warning((Object)"Scan mode image data size not a multiple of 256");
                }
                IDataPointSet[] sets = new IDataPointSet[ImageProc.this.numCcds * 16];
                KeyValueDataList plots = new KeyValueDataList(ImageProc.this.reb.getName() + " scan plots");
                for (int strip = 0; strip < ImageProc.this.numCcds; ++strip) {
                    for (int amp = 0; amp < 16; ++amp) {
                        IDataPointSet points;
                        int j = 16 * strip + amp;
                        IntBuffer data = ImageProc.this.currImageBuffer[strip][amp].asIntBuffer();
                        String title = ImageProc.this.reb.getName() + ": Strip " + strip + ", Ampl " + amp;
                        sets[j] = points = ImageProc.this.dpsf.create("", title, 2);
                        for (int k = 0; k < Math.min(1024, data.limit()); ++k) {
                            IDataPoint point = points.addPoint();
                            point.coordinate(0).setValue((double)k);
                            point.coordinate(1).setValue((double)data.get());
                        }
                        try {
                            plots.addData(String.valueOf(j), (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)((IManagedObject)sets[j]))), KeyValueData.KeyValueDataType.KeyValuePlotData);
                            continue;
                        }
                        catch (IOException ex) {
                            ImageProc.this.log.warning((Object)"Error writing dataPointSet to xml", (Throwable)ex);
                        }
                    }
                }
                ImageProc.this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)plots);
            }
        }
    }
}

