/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.demo.main.DemoSubsystem;
import org.lsst.ccs.utilities.logging.Logger;

public class DemoSubsystemWithMonitoring
extends DemoSubsystem
implements Monitor.AlarmHandler {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.demo");

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        log.info((Object)("Processing alarm " + event + " " + parm + " " + alarmName));
        return false;
    }

    @Command(description="Modify the hi limit parameters for an nchan number of channels, randomly picked")
    public void setLimitHi(int nchans, double limitHi, double dbandHi) {
        int i;
        List channelNames = this.subsys.getMonitor().getChannelNames();
        int channelNumber = channelNames.size();
        if (nchans > channelNumber) {
            nchans = channelNumber;
        }
        ArrayList<Integer> randomNumbers = new ArrayList<Integer>();
        for (i = 0; i < channelNumber; ++i) {
            randomNumbers.add(i);
        }
        if (nchans != channelNumber) {
            Collections.shuffle(randomNumbers);
        }
        for (i = 0; i < nchans; ++i) {
            this.subsys.getComponentConfigurationEnvironmentByName((String)channelNames.get((Integer)randomNumbers.get(i))).submitChange("limitHi", (Object)limitHi);
            this.subsys.getComponentConfigurationEnvironmentByName((String)channelNames.get((Integer)randomNumbers.get(i))).submitChange("dbandHi", (Object)dbandHi);
        }
        this.subsys.getConfigurationService().commitBulkChange();
    }

    @Command(description="Reset limit hi for all channels to a value that will not trigger warning or alarms")
    public void resetAllLimitHi() {
        this.setLimitHi(this.subsys.getMonitor().getChannelNames().size(), 10.0, 0.0);
    }
}

