/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keyence;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keyence.KeyenceG5001;

public class TestKeyenceG5001 {
    protected KeyenceG5001 mydev;

    @Command(name="open", description="Open a network connection to the Keyence using default addr")
    public void open() throws DriverException {
        this.mydev = new KeyenceG5001();
        this.mydev.openserial("/dev/ttyS1", 38400);
    }

    @Command(name="openserial", description="Open a serial connection to the Keyence")
    public void openserial(@Argument(name="devId", description="The device ID of the device to open") String MyDevId, @Argument(name="baud", description="baud rate") int baud) throws DriverException {
        this.mydev = new KeyenceG5001();
        this.mydev.openserial(MyDevId, baud);
    }

    @Command(name="opennet", description="Open a network connection to the Keyence")
    public void opennet(@Argument(name="netaddr", description="The netaddr of the device to open - 130.199.47.172") String MyNetAddr, @Argument(name="port", description="port - 23") int port) throws DriverException {
        this.mydev = new KeyenceG5001();
        this.mydev.opennet(MyNetAddr, port);
        this.mydev.setTimeout(60.0);
    }

    @Command(name="close", description="Close the device")
    public void close() throws Exception {
        this.mydev.close();
    }

    @Command(name="commmode", description="set to communications mode")
    public void commmode() throws Exception {
        this.mydev.commmode();
    }

    @Command(name="genmode", description="set to general mode")
    public void genmode() throws Exception {
        this.mydev.genmode();
    }

    @Command(name="version", description="get the version")
    public String version() throws Exception {
        return this.mydev.getVersion();
    }

    @Command(name="read", description="get keyence head measurement")
    public String read(@Argument(name="ikey", description="keyence head number") int ikey) throws Exception {
        return "measurement: " + this.mydev.read(ikey);
    }

    @Command(name="getnsamps", description="get keyence head measurement")
    public String getnsamps() throws Exception {
        int nsamps = -1;
        this.mydev.commmode();
        nsamps = this.mydev.getnsamps();
        this.mydev.genmode();
        return "number of samples: " + nsamps;
    }

    @Command(name="setnsamps", description="get keyence head measurement")
    public void setnsamps(@Argument(name="nsamps", description="number of samples") int nsamps) throws Exception {
        this.mydev.commmode();
        this.mydev.setnsamps(nsamps);
        this.mydev.genmode();
    }

    @Command(name="measmode", description="get keyence head measurement")
    public void measmode(@Argument(name="ikey", description="keyence head number") int ikey, @Argument(name="mode", description="measurement mode") int mode) throws Exception {
        this.mydev.setmeasmode(mode);
    }
}

