/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.metrology;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

public interface AerotechDevice {
    public void abort() throws DriverException;

    public void enableAxes() throws DriverException;

    public void disableAxes() throws DriverException;

    public String getVersion() throws DriverException;

    public void rampRate(double var1) throws DriverException;

    public void setSpeed(double var1) throws DriverException;

    public void moveIncX(double var1) throws DriverException;

    public void moveIncY(double var1) throws DriverException;

    public void moveIncZ(double var1) throws DriverException;

    public void moveIncXY(double var1, double var3) throws DriverException;

    public void moveIncXYZ(double var1, double var3, double var5) throws DriverException;

    public void moveAbsX(double var1) throws DriverException;

    public void moveAbsY(double var1) throws DriverException;

    public void moveAbsZ(double var1) throws DriverException;

    public void moveAbsXY(double var1, double var3) throws DriverException;

    public void moveAbsXYZ(double var1, double var3, double var5) throws DriverException;

    public double getPosX() throws DriverException;

    public double getPosY() throws DriverException;

    public double getPosZ() throws DriverException;

    public double[] getPosXYZ() throws DriverException;

    public double getLastPosX();

    public double getLastPosY();

    public double getLastPosZ();

    public double getxOffset();

    public double getyOffset();

    public double getzOffset();

    public void setxOffset(double var1);

    public void setyOffset(double var1);

    public void setzOffset(double var1);

    public String getError() throws DriverException;

    public void reset() throws DriverException;

    public void fullreset() throws DriverException;

    public void reconnect();

    public void goHome() throws DriverException;

    public void setupHome(int var1) throws DriverException;

    public void softLowLim(String var1, int var2) throws DriverException;

    public void softHighLim(String var1, int var2) throws DriverException;

    @Deprecated
    @Command(description="move incrementally in x")
    default public void moveInc_x(@Argument(description="amount to move in user units") double dx) throws DriverException {
        this.moveIncX(dx);
    }

    @Deprecated
    @Command(description="move incrementally in y")
    default public void moveInc_y(@Argument(description="amount to move in user units") double dy) throws DriverException {
        this.moveIncY(dy);
    }

    @Deprecated
    @Command(description="move incrementally in z")
    default public void moveInc_z(@Argument(description="amount to move in user units") double dz) throws DriverException {
        this.moveIncZ(dz);
    }

    @Deprecated
    @Command(description="move incrementally in x and y")
    default public void moveInc_xy(@Argument(description="amount to move in x in user units") double dx, @Argument(description="amount to move in y in user units") double dy) throws DriverException {
        this.moveIncXY(dx, dy);
    }

    @Deprecated
    @Command(description="move incrementally in x, y and z")
    default public void moveInc_xyz(@Argument(description="amount to move in x in user units") double dx, @Argument(description="amount to move in y in user units") double dy, @Argument(description="amount to move in z in user units") double dz) throws DriverException {
        this.moveIncXYZ(dx, dy, dz);
    }

    @Deprecated
    @Command(description="move absolutely in x")
    default public void moveAbs_x(@Argument(description="x position in user units") double x) throws DriverException {
        this.moveAbsX(x);
    }

    @Deprecated
    @Command(description="move absolutely in y")
    default public void moveAbs_y(@Argument(description="y position in user units") double y) throws DriverException {
        this.moveAbsY(y);
    }

    @Deprecated
    @Command(description="move absolutely in z")
    default public void moveAbs_z(@Argument(description="z position in user units") double z) throws DriverException {
        this.moveAbsZ(z);
    }

    @Deprecated
    @Command(description="move absolutely in x and y")
    default public void moveAbs_xy(@Argument(description="x position in user units") double x, @Argument(description="y position in user units") double y) throws DriverException {
        this.moveAbsXY(x, y);
    }

    @Deprecated
    @Command(description="move absolutely in x, y and z")
    default public void moveAbs_xyz(@Argument(description="x position in user units") double x, @Argument(description="y position in user units") double y, @Argument(description="z position in user units") double z) throws DriverException {
        this.moveAbsXYZ(x, y, z);
    }

    @Deprecated
    @Command(description="returns position in x")
    default public double getPos_x() throws DriverException {
        return this.getPosX();
    }

    @Deprecated
    @Command(description="returns position in y")
    default public double getPos_y() throws DriverException {
        return this.getPosY();
    }

    @Deprecated
    @Command(description="returns position in z")
    default public double getPos_z() throws DriverException {
        return this.getPosZ();
    }

    @Deprecated
    @Command(description="returns position in x, y and z")
    default public double[] getPos_xyz() throws DriverException {
        return this.getPosXYZ();
    }

    @Deprecated
    default public double getLastPos_x() {
        return this.getLastPosX();
    }

    @Deprecated
    default public double getLastPos_y() {
        return this.getLastPosY();
    }

    @Deprecated
    default public double getLastPos_z() {
        return this.getLastPosZ();
    }
}

