/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;

public abstract class AuthenticationSource {
    private static final AuthenticationSource INSTANCE;

    public static AuthenticationSource getDefaultInstance() {
        return INSTANCE;
    }

    public abstract byte[] createChallenge(Properties var1, Type1Message var2) throws IOException;

    public abstract byte[] authenticate(Properties var1, Type2Message var2, Type3Message var3) throws IOException;

    static {
        String service = "META-INF/services/" + AuthenticationSource.class.getName();
        URL location = null;
        ClassLoader loader = AuthenticationSource.class.getClassLoader();
        if (loader != null) {
            location = loader.getResource(service);
        }
        if (location == null) {
            location = ClassLoader.getSystemResource(service);
        }
        AuthenticationSource instance = null;
        if (location != null) {
            try {
                Properties properties = new Properties();
                properties.load(location.openStream());
                Enumeration<?> classNames = properties.propertyNames();
                if (classNames.hasMoreElements()) {
                    Class<?> sourceClass = Class.forName((String)classNames.nextElement());
                    instance = (AuthenticationSource)sourceClass.newInstance();
                }
            }
            catch (Exception ex) {
                System.err.println("WARNING: Unable to instantiate source.");
                ex.printStackTrace();
            }
        }
        INSTANCE = instance;
    }
}

