/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesUtils;

class BootstrapUtils {
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final String PATH_SEPARATOR = System.getProperty("path.separator");
    protected static final String DISTRIBUTION_JARS_DIRECTORY = "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_RESOURCES_DIRECTORY = "etc" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_LIB_DIRECTORY = "lib" + (System.getProperty("sun.arch.data.model").equals("32") ? "" : System.getProperty("sun.arch.data.model")) + FILE_SEPARATOR;
    private static final String DISTRIBUTION_JNI_DIRECTORY = DISTRIBUTION_LIB_DIRECTORY + "jni" + FILE_SEPARATOR;
    static final String APPLICATION_MAINCLASS_PROPERTY = "org.lsst.ccs.application.mainClass";
    static final String APPLICATION_EXTENDS_PROPERTY = "org.lsst.ccs.application.extends";
    static final String OBSOLETE_MAINJAR_PROPERTY = "org.lsst.ccs.application.mainJar";
    private static volatile List<String> listOfApplications = null;
    private static final String envVar_str_pattern = ".*(\\$\\[env\\.(.*)\\]).*";
    private static final Pattern envVar_pattern = Pattern.compile(".*(\\$\\[env\\.(.*)\\]).*");
    private static final String CCS_RESOURCE_PATH_ENV_VAR = "CCS_RESOURCE_PATH";
    private static final String CCS_DISTRIBUTION_PATH_ENV_VAR = "CCS_DISTRIBUTION_PATH";
    private static volatile String ccsDistributionRootDirectory = null;
    private static volatile ResourcesTree resourcesTree = null;

    BootstrapUtils() {
    }

    protected static void reset() {
        resourcesTree = null;
        ccsDistributionRootDirectory = null;
        listOfApplications = null;
    }

    static synchronized ResourcesTree getBootstrapResourcesTree() {
        if (resourcesTree == null) {
            resourcesTree = new ResourcesTree();
            List<String> resourceDirectories = BootstrapUtils.getOrderedListOfResourceDirectories();
            List<String> additionalResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(BootstrapUtils.getUserProvidedResourceDirectories(), null, true);
            for (String resourceDirectory : resourceDirectories) {
                File resourceDir = new File(resourceDirectory);
                if (!resourceDir.exists()) continue;
                if (additionalResourceDirectories.contains(resourceDirectory)) {
                    resourcesTree.addUserResourceDirectory(resourceDirectory);
                    continue;
                }
                resourcesTree.addDistributionResourceDirectory(resourceDirectory);
            }
        }
        return resourcesTree;
    }

    static String getUserProvidedResourceDirectories() {
        String resourceProperty = "org.lsst." + CCS_RESOURCE_PATH_ENV_VAR.replace("_", ".").toLowerCase();
        String userProvidedResourceDirectories = System.getProperty(resourceProperty);
        return userProvidedResourceDirectories == null ? System.getenv(CCS_RESOURCE_PATH_ENV_VAR) : userProvidedResourceDirectories;
    }

    static String getUserProvidedDistributionDirectories() {
        String distributionProperty = "org.lsst." + CCS_DISTRIBUTION_PATH_ENV_VAR.replace("_", ".").toLowerCase();
        String userProvidedDistributionDirectories = System.getProperty(distributionProperty);
        return userProvidedDistributionDirectories == null ? System.getenv(CCS_DISTRIBUTION_PATH_ENV_VAR) : userProvidedDistributionDirectories;
    }

    static List<String> getOrderedListOfResourceDirectories() {
        String userProvidedResourceDirs = BootstrapUtils.getUserProvidedResourceDirectories();
        String userProvidedDistributionDirs = BootstrapUtils.getUserProvidedDistributionDirectories();
        return BootstrapUtils.getOrderedListOfResourceDirectories(userProvidedResourceDirs, userProvidedDistributionDirs, true);
    }

    static List<String> getOrderedListOfResourceDirectories(String userProvidedResourceDirs, String userProvidedDistributions, boolean checkExistance) {
        String distributionResourceDirectoriy = BootstrapUtils.getDistributionResourcesDirectory();
        List<String> additionaDistributionResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedDistributions, DISTRIBUTION_RESOURCES_DIRECTORY, checkExistance);
        List<String> additionalResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedResourceDirs, null, checkExistance);
        ArrayList<String> orderedListOfResourceDirectories = new ArrayList<String>();
        for (String dir : additionalResourceDirectories) {
            orderedListOfResourceDirectories.add(dir);
        }
        orderedListOfResourceDirectories.add(distributionResourceDirectoriy);
        for (String dir : additionaDistributionResourceDirectories) {
            orderedListOfResourceDirectories.add(dir);
        }
        return orderedListOfResourceDirectories;
    }

    static List<String> extractDirectoriesFromPath(String directoryPath, String appendDirectory, boolean checkExistance) {
        return BootstrapUtils.extractDirectoriesFromPath(BootstrapUtils.getCCSDistributionRootDirectory(), directoryPath, appendDirectory, checkExistance);
    }

    static List<String> extractDirectoriesFromPath(String root, String directoryPath, String appendDirectory, boolean checkExistance) {
        ArrayList<String> extractedDirectories = new ArrayList<String>();
        if (directoryPath != null && !"".equals(directoryPath)) {
            StringTokenizer dirsToken = new StringTokenizer(directoryPath, PATH_SEPARATOR);
            while (dirsToken.hasMoreTokens()) {
                String resourceDir = dirsToken.nextToken().trim();
                if (!resourceDir.endsWith(FILE_SEPARATOR)) {
                    resourceDir = resourceDir + FILE_SEPARATOR;
                }
                if (appendDirectory != null && !"".equals(appendDirectory)) {
                    if (!appendDirectory.endsWith(FILE_SEPARATOR)) {
                        appendDirectory = appendDirectory + FILE_SEPARATOR;
                    }
                    resourceDir = resourceDir + appendDirectory;
                }
                Path p = Paths.get(root, new String[0]);
                resourceDir = resourceDir.replace("~", System.getProperty("user.home"));
                if (!(resourceDir = p.resolve(resourceDir).normalize().toString()).endsWith(FILE_SEPARATOR)) {
                    resourceDir = resourceDir + FILE_SEPARATOR;
                }
                File dir = new File(resourceDir);
                extractedDirectories.add(resourceDir);
            }
        }
        return extractedDirectories;
    }

    static String getDistributionResourcesDirectory() {
        return BootstrapUtils.getDistributionResourcesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionResourcesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_RESOURCES_DIRECTORY;
    }

    static String getDistributionLibDirectory() {
        return BootstrapUtils.getDistributionLibDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionLibDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_LIB_DIRECTORY;
    }

    static String getDistributionJniDirectory() {
        return BootstrapUtils.getDistributionJniDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJniDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_JNI_DIRECTORY;
    }

    static String getDistributionJarFilesDirectory() {
        return BootstrapUtils.getDistributionJarFilesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJarFilesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_JARS_DIRECTORY;
    }

    static synchronized String getCCSDistributionRootDirectory() {
        if (ccsDistributionRootDirectory == null) {
            ccsDistributionRootDirectory = BootstrapUtils.getDirectoryForClass(Bootstrap.getLoaderClass());
        }
        return ccsDistributionRootDirectory;
    }

    static String getDirectoryForClass(Class clazz) {
        String tmpCcsDistributionRootDirectory;
        block5: {
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            tmpCcsDistributionRootDirectory = "";
            try {
                Path path = Paths.get(location.toURI());
                String sourceCodeLocation = path.toString();
                if (sourceCodeLocation.endsWith(".jar")) {
                    tmpCcsDistributionRootDirectory = sourceCodeLocation.substring(0, sourceCodeLocation.lastIndexOf(FILE_SEPARATOR) + 1);
                    break block5;
                }
                if (path.toFile().isDirectory()) {
                    tmpCcsDistributionRootDirectory = sourceCodeLocation + FILE_SEPARATOR;
                    break block5;
                }
                throw new RuntimeException("Could not process souce code location " + sourceCodeLocation + " It is neither a directory nor a jar file.");
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Could not process souce code location ", x);
            }
        }
        if (tmpCcsDistributionRootDirectory.endsWith(DISTRIBUTION_JARS_DIRECTORY)) {
            tmpCcsDistributionRootDirectory = tmpCcsDistributionRootDirectory.replace(DISTRIBUTION_JARS_DIRECTORY, "");
        }
        return tmpCcsDistributionRootDirectory;
    }

    static synchronized List<String> getBootstrapListOfApplications() {
        if (listOfApplications == null) {
            listOfApplications = new ArrayList<String>();
            ArrayList<String> allPropertiesInResources = new ArrayList<String>();
            for (ResourceDirectory dir : BootstrapUtils.getBootstrapResourcesTree().getResourceDirectoryList()) {
                String[] listOfResources;
                File resourceDirectoryFile = new File(dir.getResouceDirectoryPath());
                if (!resourceDirectoryFile.exists() || !resourceDirectoryFile.isDirectory()) continue;
                for (String resource : listOfResources = resourceDirectoryFile.list()) {
                    if (!resource.endsWith(".properties")) continue;
                    allPropertiesInResources.add(resource);
                }
            }
            for (String propertyFile : allPropertiesInResources) {
                try {
                    Properties props = ResourcesUtils.getMergedPropertyFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                    String mainClass = props.getProperty(APPLICATION_MAINCLASS_PROPERTY, "");
                    String extendsApp = props.getProperty(APPLICATION_EXTENDS_PROPERTY, "");
                    String applicationName = propertyFile.replace(".properties", "");
                    if (mainClass.isEmpty() && extendsApp.isEmpty() || listOfApplications.contains(applicationName)) continue;
                    listOfApplications.add(applicationName);
                }
                catch (Exception e) {
                    System.out.println("Application list is ignoring file " + propertyFile + " due to duplicate entries");
                }
            }
        }
        return listOfApplications;
    }

    static Properties getApplicationDefinitionProperties(String application) {
        if (!application.endsWith(".properties")) {
            application = application + ".properties";
        }
        return BootstrapResourceUtils.getBootstrapProperties(application);
    }

    static String parseProperty(String inputProperty) {
        String outProperty = inputProperty;
        Matcher m = envVar_pattern.matcher(outProperty);
        if (m.matches()) {
            String envVarValue = System.getenv(m.group(2));
            if (envVarValue != null) {
                outProperty = outProperty.replace(m.group(1), envVarValue);
            } else if (Bootstrap.isBootstrapEnvironment()) {
                System.out.println("[WARNING] Environment variable " + m.group(2) + " is not defined.");
            }
        }
        return outProperty;
    }
}

