/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.TempControl;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.SequencerData;
import org.lsst.ccs.subsystem.rafts.states.SequencerMainState;
import org.lsst.ccs.subsystem.rafts.states.SequencerState;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.CCDTypeUtils;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public class RaftsCommands {
    private static final Map<String, CCDType> ccdTypes = new HashMap<String, CCDType>();
    private final List<REBDevice> rebDevices;
    private final List<SequencerProc> sequencers = new ArrayList<SequencerProc>();
    private final List<ImageProc> imageProcs = new ArrayList<ImageProc>();
    private final GlobalProc globalProc;
    private final TempControl tempCtrl;
    private final Subsystem subsys;
    private CCDType ccdType = new ITLCCDType();
    private Geometry geometry;
    private String sequencerStartMain;
    private ReadOutParameters readOutParameters;

    public RaftsCommands(Subsystem subsys, List<REBDevice> rebDevices, GlobalProc globalProc, Geometry geometry, TempControl tempCtrl) {
        this.subsys = subsys;
        this.rebDevices = rebDevices;
        this.globalProc = globalProc;
        this.geometry = geometry;
        this.tempCtrl = tempCtrl;
        for (REBDevice devc : rebDevices) {
            this.sequencers.add(devc.getSequencer());
            this.imageProcs.add(devc.getImageProc());
        }
        this.updateImageProcGeometry();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the CCD type")
    public void setCcdType(@Argument(name="type", description="The CCD type") String type) {
        this.ccdType = ccdTypes.get(type);
        String cfgName = this.ccdType != null ? this.ccdType.getName() : "";
        this.subsys.getConfigurationService().loadCategories(new String[]{"RaftsLimits:" + cfgName});
        this.subsys.getConfigurationService().loadCategories(new String[]{"Rafts:" + cfgName});
        if (this.ccdType != null) {
            this.changeCcdType(type);
        }
    }

    public void changeCcdType(String type) {
        this.ccdType = ccdTypes.get(type);
        if (this.ccdType == null) {
            throw new IllegalArgumentException("Illegal CCD type: " + type + ". Must be one of : " + ccdTypes.keySet());
        }
        this.geometry = CCDTypeUtils.changeCCDTypeForGeometry((Geometry)this.geometry, (CCDType)this.ccdType);
        this.updateImageProcGeometry();
        if (this.readOutParameters == null) {
            this.readOutParameters = new ReadOutParameters(this.ccdType);
        } else {
            this.readOutParameters.setCCDType(this.ccdType);
        }
    }

    private void updateImageProcGeometry() {
        for (REBDevice rebDev : this.rebDevices) {
            rebDev.getImageProc().setRebGeometry((Reb)this.geometry.getChild(rebDev.getRebNumber(), 0));
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the control temperature")
    public void setControlTemp(@Argument(name="temp", description="Temperature value") double temp) {
        this.tempCtrl.setTemperature(temp);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the control temperature")
    public double getControlTemp() {
        return this.tempCtrl.getTemperature();
    }

    @Command(type=Command.CommandType.ACTION, description="Start temperature control")
    public void startTempControl() {
        this.tempCtrl.startLoop(0.0);
    }

    @Command(type=Command.CommandType.ACTION, description="Stop temperature control")
    public void stopTempControl() {
        this.tempCtrl.stopLoop();
    }

    @Command(type=Command.CommandType.QUERY, description="Get temperature control state")
    public boolean isTempControlActive() {
        return this.tempCtrl.isLoopActive();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the CCD type")
    public String getCcdType() {
        return this.ccdType != null ? this.ccdType.getName() : "Not defined";
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of REB devices")
    public List<String> getREBDeviceNames() {
        ArrayList<String> devList = new ArrayList<String>();
        for (Device device : this.rebDevices) {
            devList.add(device.getName());
        }
        return devList;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="Get the list of REB devices")
    public List<String> getREBDevices() {
        ArrayList<String> devList = new ArrayList<String>();
        for (Device device : this.rebDevices) {
            devList.add(device.getName());
        }
        return devList;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of REB hardware versions")
    public List<Integer> getREBHwVersions() {
        ArrayList<Integer> devList = new ArrayList<Integer>();
        for (REBDevice devc : this.rebDevices) {
            devList.add(devc.getHwVersion());
        }
        return devList;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of REB IDs")
    public List<Integer> getREBIds() {
        ArrayList<Integer> devList = new ArrayList<Integer>();
        for (REBDevice devc : this.rebDevices) {
            devList.add(devc.getId());
        }
        return devList;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of REB serial numbers")
    public List<Long> getREBSerialNumbers() {
        ArrayList<Long> devList = new ArrayList<Long>();
        for (REBDevice devc : this.rebDevices) {
            devList.add(devc.getSerialNumber());
        }
        return devList;
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the front end")
    public void resetFirmware() throws Exception {
        for (REBDevice reb : this.rebDevices) {
            reb.resetFrontEnd();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the data source")
    public List<Integer> getDataSource() throws Exception {
        ArrayList<Integer> source = new ArrayList<Integer>();
        for (REBDevice reb : this.rebDevices) {
            source.add(reb.getSequencer().getDataSource());
        }
        return source;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the data sources")
    public void setDataSource(@Argument(name="value", description="The data source value") int value) throws Exception {
        for (REBDevice reb : this.rebDevices) {
            reb.getSequencer().setDataSource(value);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the scan mode enabled states")
    public List<Boolean> isScanEnabled() throws Exception {
        ArrayList<Boolean> enabled = new ArrayList<Boolean>();
        for (REBDevice reb : this.rebDevices) {
            boolean enab = reb.getSequencer().isScanEnabled();
            reb.getImageProc().enableScan(enab);
            enabled.add(enab);
        }
        return enabled;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the scan mode enables")
    public void enableScan(@Argument(name="value", description="The scan mode enabled state") boolean value) throws Exception {
        for (REBDevice reb : this.rebDevices) {
            reb.getSequencer().enableScan(value);
            reb.getImageProc().enableScan(value);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the scan modes")
    public void resetScan() throws Exception {
        for (REBDevice reb : this.rebDevices) {
            reb.getSequencer().resetScan();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load DACs")
    public int loadDacs(@Argument(name="all", description="If true, load all DACs") boolean all) throws Exception {
        int count = 0;
        for (REBDevice reb : this.rebDevices) {
            count += reb.loadDacs(all);
        }
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear DACs")
    public void clearDacs() throws Exception {
        for (REBDevice reb : this.rebDevices) {
            reb.clearDacs();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load bias DACs")
    public int loadBiasDacs(@Argument(name="all", description="If true, load all bias DACs") boolean all) throws Exception {
        int count = 0;
        for (REBDevice reb : this.rebDevices) {
            count += reb.loadBiasDacs(all);
        }
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear bias DACs")
    public void clearBiasDacs() throws Exception {
        for (REBDevice reb : this.rebDevices) {
            reb.clearBiasDacs();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load ASPICs")
    public int loadAspics(@Argument(name="all", description="If true, load all ASPICs") boolean all) throws Exception {
        int count = 0;
        for (REBDevice reb : this.rebDevices) {
            count += reb.loadAspics(all);
        }
        return count;
    }

    @Command(type=Command.CommandType.QUERY, description="Check all ASPICs")
    public List<Integer> checkAspics() throws Exception {
        ArrayList<Integer> masks = new ArrayList<Integer>();
        for (REBDevice reb : this.rebDevices) {
            masks.add(reb.checkAspics());
        }
        return masks;
    }

    @Command(type=Command.CommandType.ACTION, description="Reset ASPICs")
    public int resetAspics() throws Exception {
        int count = 0;
        for (REBDevice reb : this.rebDevices) {
            count += reb.resetAspics();
        }
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Load all CABACs")
    public int loadCabacs() throws Exception {
        int count = 0;
        for (REBDevice reb : this.rebDevices) {
            count += reb.loadCabacs();
        }
        return count;
    }

    @Command(type=Command.CommandType.QUERY, description="Check all CABACs")
    public List<Integer> checkCabacs() throws Exception {
        ArrayList<Integer> masks = new ArrayList<Integer>();
        for (REBDevice reb : this.rebDevices) {
            masks.addAll(reb.checkCabacs());
        }
        return masks;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the REBs' system time")
    public void setTime() throws Exception {
        for (REBDevice rebd : this.rebDevices) {
            rebd.setTime();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the REBs' system times")
    public Map<String, Long> getTimes() throws Exception {
        HashMap<String, Long> times = new HashMap<String, Long>();
        for (REBDevice rebd : this.rebDevices) {
            times.put(rebd.getName(), rebd.getTime());
        }
        return times;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the REBs' system times")
    public List getTime() throws Exception {
        ArrayList<Object> times = new ArrayList<Object>();
        for (REBDevice rebd : this.rebDevices) {
            times.add(rebd.getName());
            times.add(rebd.getTime());
        }
        return times;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the back bias on states")
    public List<Boolean> isBackBiasOn() throws Exception {
        ArrayList<Boolean> state = new ArrayList<Boolean>();
        for (REBDevice reb : this.rebDevices) {
            state.add(reb.isBackBiasOn());
        }
        return state;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the back bias on states")
    public void setBackBias(@Argument(name="value", description="The back bias on state") boolean value) throws Exception {
        for (REBDevice reb : this.rebDevices) {
            reb.setBackBias(value);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load all sequencers from a file")
    public List<Integer> loadSequencer(@Argument(name="filename", description="Sequencer file name") String fileName) throws Exception, IOException {
        ArrayList<Integer> sliceCount = new ArrayList<Integer>();
        for (int j = 0; j < this.sequencers.size(); ++j) {
            SequencerProc seq = this.sequencers.get(j);
            int nSlice = seq.loadSequencer(fileName);
            String shortFileName = Paths.get(fileName, new String[0]).getFileName().toString();
            this.imageProcs.get(j).setSequencerFileName(shortFileName);
            sliceCount.add(nSlice);
        }
        this.updateReadoutParameters();
        return sliceCount;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the maps of mains")
    public List<Map<String, Integer>> getSequencerMainMap() {
        ArrayList<Map<String, Integer>> list = new ArrayList<Map<String, Integer>>();
        for (SequencerProc seq : this.sequencers) {
            list.add(seq.getMainMap());
        }
        return list;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="Get the maps of mains")
    public List<Map<String, Integer>> getMainMap() {
        return this.getSequencerMainMap();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the maps of subroutines")
    public List<Map<String, Integer>> getSequencerSubroutineMap() {
        ArrayList<Map<String, Integer>> list = new ArrayList<Map<String, Integer>>();
        for (SequencerProc seq : this.sequencers) {
            list.add(seq.getSubroutineMap());
        }
        return list;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="Get the maps of subroutines")
    public List<Map<String, Integer>> getSubroutineMap() {
        return this.getSequencerSubroutineMap();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the maps of sequencer functions")
    public List<Map<String, Integer>> getSequencerFunctionMap() {
        ArrayList<Map<String, Integer>> list = new ArrayList<Map<String, Integer>>();
        for (SequencerProc seq : this.sequencers) {
            list.add(seq.getFunctionMap());
        }
        return list;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="Get the maps of functions")
    public List<Map<String, Integer>> getFunctionMap() {
        return this.getSequencerFunctionMap();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the maps of sequencer pointers")
    public List<Map<String, Integer>> getSequencerPointers() {
        ArrayList<Map<String, Integer>> list = new ArrayList<Map<String, Integer>>();
        for (SequencerProc seq : this.sequencers) {
            list.add(seq.getPointers());
        }
        return list;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="Get the maps of pointers")
    public List<Map<String, Integer>> getPointers() {
        return this.getSequencerPointers();
    }

    @Command(type=Command.CommandType.QUERY, description="Get sequencer parameter values")
    public List<Integer> getSequencerParameter(@Argument(name="name", description="The parameter name") String name) throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (SequencerProc seq : this.sequencers) {
            list.add(seq.getParameter(name));
        }
        return list;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="Get parameter values")
    public List<Integer> getParameter(@Argument(name="name", description="The parameter name") String name) throws Exception {
        return this.getSequencerParameter(name);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a sequencer parameter value")
    public void setSequencerParameter(@Argument(name="name", description="The parameter name") String name, @Argument(name="value", description="The value to set") int value) throws Exception {
        for (SequencerProc seq : this.sequencers) {
            seq.setParameter(name, value);
        }
        if (SequencerData.imageRegs.containsValue(name)) {
            this.updateReadoutParameters();
        }
    }

    @Deprecated
    @Command(type=Command.CommandType.ACTION, description="Set a sequencer parameter value")
    public void setParameter(@Argument(name="name", description="The parameter name") String name, @Argument(name="value", description="The value to set") int value) throws Exception {
        this.setSequencerParameter(name, value);
    }

    @Command(type=Command.CommandType.ACTION, description="Set all sequencer start addresses")
    public List<Integer> setSequencerStart(@Argument(name="mainName", description="Main routine name") String mainName) throws Exception {
        ArrayList<Integer> sliceCount = new ArrayList<Integer>();
        for (SequencerProc seq : this.sequencers) {
            sliceCount.add(seq.setStart(mainName));
        }
        SequencerMainState state = SequencerMainState.OTHER;
        String loweredMainName = mainName.toLowerCase();
        if (loweredMainName.contains("clear")) {
            state = SequencerMainState.CLEAR;
        } else if (loweredMainName.contains("expose")) {
            state = SequencerMainState.INTEGRATE;
        } else if (loweredMainName.contains("acquire") || loweredMainName.contains("bias")) {
            state = SequencerMainState.READOUT;
        }
        if (!this.subsys.isInState((Enum)state)) {
            this.subsys.updateAgentState(new Enum[]{state});
        }
        this.sequencerStartMain = mainName;
        return sliceCount;
    }

    public String getSequencerStart() {
        return this.sequencerStartMain;
    }

    @Deprecated
    @Command(type=Command.CommandType.ACTION, description="Set all sequencer start addresses")
    public List<Integer> setStart(@Argument(name="mainName", description="Main routine name") String mainName) throws Exception {
        return this.setSequencerStart(mainName);
    }

    @Command(type=Command.CommandType.ACTION, description="Start the sequencers")
    public void startSequencer() throws Exception {
        for (SequencerProc seq : this.sequencers) {
            seq.resetError();
            seq.startSequencer();
        }
        this.subsys.updateAgentState(new Enum[]{SequencerState.RUNNING});
    }

    @Command(type=Command.CommandType.ACTION, description="Send a sequencer stop command")
    public void stopSequencer() throws Exception {
        for (SequencerProc seq : this.sequencers) {
            seq.sendStop();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Send a sequencer step command")
    public void stepSequencer() throws Exception {
        for (SequencerProc seq : this.sequencers) {
            seq.sendStep();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the running states of the sequencers")
    public List<Boolean> isSequencerRunning() throws Exception {
        ArrayList<Boolean> running = new ArrayList<Boolean>();
        for (SequencerProc seq : this.sequencers) {
            running.add(seq.isRunning());
        }
        return running;
    }

    @Command(type=Command.CommandType.ACTION, description="Start the sequencers")
    public void waitSequencerDone(@Argument(name="timeout", description="Timeout (ms)") int timeout) throws Exception {
        for (SequencerProc seq : this.sequencers) {
            seq.waitDone(timeout);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Start image acquisition")
    public void acquireImage() throws Exception {
        for (SequencerProc seq : this.sequencers) {
            seq.resetError();
        }
        if (this.globalProc != null) {
            this.globalProc.acquireImage();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current image as raw bytes")
    public List<String> saveImage(@Argument(name="dirname", description="The directory to use", defaultValue="") String dirName) throws RaftException, IOException {
        ArrayList<String> names = new ArrayList<String>();
        for (ImageProc imp : this.imageProcs) {
            names.add(imp.saveImage(dirName));
        }
        return names;
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current image as a FITS file")
    public List<String> saveFitsImage(@Argument(name="dirname", description="The directory to use", defaultValue="") String dirName) throws IOException, RaftException {
        return this.saveFitsImage(dirName, null);
    }

    public List<String> saveFitsImage(String dirName, FitsHeaderMetadataProvider provider) throws IOException, RaftException {
        ArrayList<String> names = new ArrayList<String>();
        for (ImageProc imp : this.imageProcs) {
            names.addAll(imp.saveFitsImage(dirName, provider));
        }
        return names;
    }

    @Command(type=Command.CommandType.ACTION, description="Set whether image data values are inverted")
    public void setImageDataInversion(@Argument(name="invert", description="Whether to invert") boolean invert) {
        for (ImageProc imp : this.imageProcs) {
            imp.setDataInversion(invert);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the default image directory")
    public void setDefaultImageDirectory(@Argument(name="dirname", description="The directory name") String dirName) {
        for (ImageProc imp : this.imageProcs) {
            imp.setDefaultImageDirectory(dirName);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the FITS file name pattern")
    public void setFitsFileNamePattern(@Argument(name="pattern", description="The file name pattern") String pattern) {
        for (ImageProc imp : this.imageProcs) {
            imp.setFitsFileNamePattern(pattern);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the raw image data file name pattern")
    public void setImageDataFileNamePattern(@Argument(name="pattern", description="The file name pattern") String pattern) {
        for (ImageProc imp : this.imageProcs) {
            imp.setImageDataFileNamePattern(pattern);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the FITS exposure time")
    public void setExposureTime(@Argument(name="exptime", description="The exposure time") double expTime) {
        for (ImageProc imp : this.imageProcs) {
            imp.setExposureTime(expTime);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set a pattern property for resolving file names and output directory")
    public void setPatternProperty(String propertyName, String propertyValue) {
        for (ImageProc imp : this.imageProcs) {
            imp.setPatternProperty(propertyName, propertyValue);
        }
    }

    public void checkSequencerState() {
        SequencerState state = SequencerState.IDLE;
        for (SequencerProc seq : this.sequencers) {
            try {
                if (!seq.isRunning()) continue;
                state = SequencerState.RUNNING;
            }
            catch (REBException ex) {
                state = SequencerState.ERROR;
            }
            break;
        }
        if (!this.subsys.isInState((Enum)state)) {
            this.subsys.updateAgentState(new Enum[]{state});
        }
    }

    public void setSequenceNumber(int sequenceNumber) {
        for (ImageProc imageProc : this.imageProcs) {
            imageProc.setExternalSequenceNumber(sequenceNumber);
        }
    }

    @Command(simulation=true)
    public void generateAlert(@Argument(name="raftAlert") RaftAlert raftAlert, @Argument(name="alertState") AlertState state) {
        this.subsys.getAlertService().raiseAlert(raftAlert.getAlert(), state, "Simulated Raft Alert");
    }

    private void updateReadoutParameters() throws REBException, Exception {
        boolean parsCreated = false;
        for (int j = 0; j < this.sequencers.size(); ++j) {
            SequencerProc seq = this.sequencers.get(j);
            if (parsCreated || this.globalProc == null) continue;
            int[] metadataRegisters = seq.getImageRegisters();
            REBDevice rebDevice = this.rebDevices.get(j);
            this.globalProc.setRegisters(rebDevice.getRebType(), metadataRegisters);
            parsCreated = true;
        }
    }

    static {
        E2VCCDType e2v = new E2VCCDType();
        ccdTypes.put(e2v.getName(), (CCDType)e2v);
        ITLCCDType itl = new ITLCCDType();
        ccdTypes.put(itl.getName(), (CCDType)itl);
    }
}

