/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.utilities.logging.Logger;

public class PowerControl
extends Control {
    private static final String VOLTAGE = "voltage";
    private static final String CURRENT = "current";
    private static final String ON_DELAY = "onDelay";
    private static final String OFF_DELAY = "offDelay";
    @ConfigurationParameter(name="voltage", category="Power")
    private double voltage;
    @ConfigurationParameter(name="current", category="Power")
    private double current;
    @ConfigurationParameter(name="onDelay", category="Power")
    private double onDelay;
    @ConfigurationParameter(name="offDelay", category="Power")
    private double offDelay;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    private String shortName;
    private PowerDevice pDevc;

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.pDevc = (PowerDevice)devc;
        try {
            if (this.hwChan < this.pDevc.getMinChannel() || this.hwChan > this.pDevc.getMaxChannel()) {
                MonitorLogUtils.reportError((Logger)this.log, (String)this.getName(), (String)"hw channel number", (Object)this.hwChan);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] parts = this.getName().split("\\.");
        this.shortName = parts[parts.length - 1];
    }

    @ConfigurationParameterChanger
    public void setVoltage(double value) {
        this.voltage = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the set voltage")
    public double getVoltage() {
        return this.voltage;
    }

    @ConfigurationParameterChanger
    public void setCurrent(double value) {
        this.current = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the set current")
    public double getCurrent() {
        return this.current;
    }

    @ConfigurationParameterChanger
    public void setOnDelay(double value) {
        this.onDelay = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the power-on delay")
    public double getOnDelay() {
        return this.onDelay;
    }

    @ConfigurationParameterChanger
    public void setOffDelay(double value) {
        this.offDelay = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the power-off delay")
    public double getOffDelay() {
        return this.offDelay;
    }

    @Command(type=Command.CommandType.ACTION, description="Changes the voltage")
    public void changeVoltage(double value) throws Exception {
        this.pDevc.writeVoltage(value, this.hwChan);
    }

    void setConfig(Power.Channel chan) throws Exception {
        ConfigurationService sce = this.subs.getConfigurationService();
        String name = this.getName();
        sce.change(name, VOLTAGE, (Object)chan.getVoltage());
        sce.change(name, CURRENT, (Object)chan.getCurrent());
        sce.change(name, ON_DELAY, (Object)chan.getOnDelay());
        sce.change(name, OFF_DELAY, (Object)chan.getOffDelay());
    }

    Power.Channel getConfig() {
        Power.Channel chan = new Power.Channel();
        chan.setName(this.shortName);
        chan.setVoltage(this.voltage);
        chan.setCurrent(this.current);
        chan.setOnDelay(this.onDelay);
        chan.setOffDelay(this.offDelay);
        return chan;
    }

    PowerChanState getState() {
        PowerChanState pwr = new PowerChanState();
        pwr.setName(this.shortName);
        try {
            pwr.setVoltage(this.readVoltage());
            pwr.setCurrent(this.readCurrent());
            pwr.setState(this.readOutput() ? 1 : 0);
        }
        catch (Exception e) {
            this.log.warning((Object)("Error reading power state: " + e));
            pwr.setVoltage(0.0);
            pwr.setCurrent(0.0);
            pwr.setState(-1);
        }
        return pwr;
    }

    void writeAll() throws Exception {
        this.writeVoltage();
        this.writeCurrent();
        this.writeOnDelay();
        this.writeOffDelay();
    }

    void writeVoltage() throws Exception {
        this.pDevc.writeVoltage(this.voltage, this.hwChan);
    }

    double readVoltage() throws Exception {
        return this.pDevc.readVoltage(this.hwChan);
    }

    void writeCurrent() throws Exception {
        this.pDevc.writeCurrent(this.current, this.hwChan);
    }

    double readCurrent() throws Exception {
        return this.pDevc.readCurrent(this.hwChan);
    }

    void writeOnDelay() throws Exception {
        this.pDevc.writeOnDelay(this.onDelay, this.hwChan);
    }

    void writeOffDelay() throws Exception {
        this.pDevc.writeOffDelay(this.offDelay, this.hwChan);
    }

    void writeOutput(boolean value) throws Exception {
        this.pDevc.writeOutput(value, this.hwChan);
    }

    boolean readOutput() throws Exception {
        return this.pDevc.readOutput(this.hwChan);
    }
}

