/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import java.awt.Component;
import java.util.Random;
import plotter.AutoRangeAxisModel;
import plotter.Axis;
import plotter.DataArea;
import plotter.DefaultAxisModel;
import plotter.Histogram1DOverlay;
import plotter.LinearAxisModel;
import plotter.PaintedPanel;
import plotter.PlotLayout;
import plotter.TestFrame;

public class AIDA1DTest {
    public static void main(String[] args) {
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory hf = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = hf.createHistogram1D("test", 40, -3.0, 3.0);
        Random r = new Random();
        for (int i = 0; i < 10000; ++i) {
            h1.fill(r.nextGaussian());
        }
        IAxis xAxis = h1.axis();
        double[] xEdges = new double[xAxis.bins() + 1];
        for (int i = 0; i < xAxis.bins(); ++i) {
            xEdges[i] = xAxis.binLowerEdge(i);
        }
        xEdges[xAxis.bins()] = xAxis.upperEdge();
        double yMin = 0.0;
        double yMax = 0.0;
        for (int i = 0; i < xAxis.bins(); ++i) {
            double y = h1.binHeight(i);
            System.out.println("y=" + y);
            if (i == 0) {
                yMin = yMax = y;
                continue;
            }
            yMin = Math.min(yMin, y);
            yMax = Math.max(yMax, y);
        }
        DefaultAxisModel xModel = new DefaultAxisModel(xEdges, false, false);
        AutoRangeAxisModel yModel = new AutoRangeAxisModel(new LinearAxisModel(yMin, yMax));
        Axis bottomAxis = new Axis(xModel, Axis.AxisPosition.BOTTOM);
        Axis leftAxis = new Axis(yModel, Axis.AxisPosition.LEFT);
        double[] data = new double[h1.axis().bins()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = h1.binHeight(i);
        }
        Histogram1DOverlay overlay = new Histogram1DOverlay(h1.title(), data, xModel, yModel);
        DataArea da = new DataArea(bottomAxis, leftAxis);
        da.add(overlay);
        PaintedPanel plotPanel = new PaintedPanel(new PlotLayout());
        plotPanel.add((Component)bottomAxis, "South");
        plotPanel.add((Component)leftAxis, "West");
        plotPanel.add((Component)da, "Center");
        new TestFrame("AIDATest", plotPanel);
    }
}

