/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FixedSizePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

public class LoaderGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 8834267363875256916L;
    private InterfaceLoaderGUI subs;
    private JPanel cameraProtectionPanel;
    private JPanel loaderKeysPanel;
    private JPanel loaderHooksPanel;
    private JPanel loaderCarrierPanel;
    private JPanel commonCommandPanel;
    private JPanel uncommonCommandPanel;
    private final JLabel loaderDockedLabel = new JLabel("Docked");
    private final String fullPathCarrierName = "loader/carrier";
    public static final String AF1 = "acAF1s";
    public static final String AF1B = "acAF1b";
    private static final DigitalSwitch DOCKEDSWITCH = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private static final DigitalSwitch AP2SWITCH = new DigitalSwitch("acAP2s", "acAP2b");
    private static final DigitalSwitch AF0SWITCH = new DigitalSwitch("acAF0s", "acAF0b");
    private static final DigitalSwitch AF1SWITCH = new DigitalSwitch("acAF1s", "acAF1b");
    private static final DigitalSwitch AF3SWITCH = new DigitalSwitch("acAF3s", "acAF3b");
    private static final DigitalSwitch NOLOCKOUTSWITCH = new DigitalSwitch("keyLockb", "keyLock");
    private static final DigitalSwitch ENGINEERINGSWITCH = new DigitalSwitch("keyEng", "keyEngb");
    private final DiamondSwitch carrierRelaySwitch = new DiamondSwitch("loaderCarrierRelayStatus");
    private final DiamondSwitch hooksRelaySwitch = new DiamondSwitch("loaderHooksRelayStatus");
    private final DiamondSwitch safetyBeltPresenceSwitch = new DiamondSwitch("loaderChainPresenceSensor");
    private final DiamondSwitch noDefaultStatusSwitch = new DiamondSwitch("loaderDefaultStatus");
    private static final DigitalSwitch FILTERPRESENCESWITCH = new DigitalSwitch("loaderFilterPresenceSensor0", "loaderFilterPresenceSensor1");
    private final JLabel clampHomingLabel = new JLabel();
    private final JLabel clampStateLabel = new JLabel();
    private final JLabel clampPositionLabel = new JLabel();
    private final JLabel forceStatusLabel = new JLabel();
    private final DigitalSwitch clampControllerSwitch = new DigitalSwitch();
    private final JPanel carrierPanel = new JPanel();
    private final JLabel carrierPositionLabel = new JLabel();
    private final JLabel carrierStatusLabel = new JLabel();
    private final JLabel carrierSpeedLabel = new JLabel();
    private final JProgressBar carrierPositionProgressBar = new JProgressBar(1, 0, 100);
    private final DigitalSwitch carrierControllerSwitch = new DigitalSwitch();
    private final JButton loadFilterButton = new JButton("Load Filter Into Bench Or Storage Box");
    private final JButton unloadFilterButton = new JButton("Unload Filter From Bench Or Storage Box");
    private final JButton moveFilterStoHButton = new JButton("Move Filter To Handoff");
    private final JButton moveFilterHtoSButton = new JButton("Move Filter To Storage");
    private final JButton openClampAndMoveEmptyToSButton = new JButton("Open Clamp And Move Empty To Storage");
    private final JButton moveEmptyToHandCloseButton = new JButton("Move Empty To Handoff And Close");
    private final DigitalSwitch[] complementarySwitches = new DigitalSwitch[]{AF0SWITCH, AF3SWITCH, AP2SWITCH, AF1SWITCH, ENGINEERINGSWITCH, NOLOCKOUTSWITCH};
    private final DigitalSwitch[] redondantSwitches = new DigitalSwitch[]{DOCKEDSWITCH, FILTERPRESENCESWITCH};
    private final DiamondSwitch[] diamondSwitchesGreenGray = new DiamondSwitch[]{this.carrierRelaySwitch, this.hooksRelaySwitch, this.safetyBeltPresenceSwitch};

    public LoaderGeneralViewPanel() {
        this.initComponents();
    }

    public LoaderGeneralViewPanel(InterfaceLoaderGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    public void updateFromSensorList(Map<String, Serializable> sensorMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sensorMap));
    }

    public void updateCarrierController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(status));
    }

    public void updateClampController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(status));
    }

    private void initComponents() {
        JPanel fakeSensorPanel = this.createFakeSensorPanel();
        this.cameraProtectionPanel = this.createCameraProtectionPanel();
        this.loaderKeysPanel = this.createLoaderKeysPanel();
        this.loaderHooksPanel = this.createLoaderHooksPanel();
        this.loaderCarrierPanel = this.createLoaderCarrierPanel();
        this.commonCommandPanel = this.createCommonCommandPanel();
        this.uncommonCommandPanel = this.createUncommonCommandPanel();
        JPanel fakeSensorAndProtectionPanel = new JPanel(new BorderLayout());
        fakeSensorAndProtectionPanel.add((Component)fakeSensorPanel, "North");
        fakeSensorAndProtectionPanel.add((Component)this.cameraProtectionPanel, "Center");
        this.loadFilterButton.addActionListener(evt -> this.loadFilterActionPerformed(evt));
        this.unloadFilterButton.addActionListener(evt -> this.unloadFilterActionPerformed(evt));
        this.moveFilterStoHButton.addActionListener(evt -> this.moveFilterStoHActionPerformed(evt));
        this.moveFilterHtoSButton.addActionListener(evt -> this.moveFilterHtoSActionPerformed(evt));
        this.openClampAndMoveEmptyToSButton.addActionListener(evt -> this.openClampAndMoveEmptyToStoSActionPerformed(evt));
        this.moveEmptyToHandCloseButton.addActionListener(evt -> this.moveEmptyToHandCloseActionPerformed(evt));
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(Tools.getGeneralPanelTitle("Loader Overview"));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)fakeSensorAndProtectionPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.loaderHooksPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.commonCommandPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.loaderKeysPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.loaderCarrierPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.uncommonCommandPanel, gbc);
        this.setDefaultValues();
    }

    private JPanel createFakeSensorPanel() {
        JPanel fakeSensorPanel = new JPanel();
        fakeSensorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Loader"), 2), ""));
        fakeSensorPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        fakeSensorPanel.add((Component)this.loaderDockedLabel, gbc1);
        ++gbc1.gridx;
        fakeSensorPanel.add((Component)DOCKEDSWITCH, gbc1);
        return fakeSensorPanel;
    }

    private JPanel createLoaderCarrierPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Loader"), 2), "Carrier"));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel controllerPanel = new JPanel();
        controllerPanel.setBorder(BorderFactory.createEtchedBorder());
        controllerPanel.setLayout(new GridBagLayout());
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        controllerPanel.add((Component)new JLabel("Controller Status"), gbc);
        ++gbc.gridy;
        controllerPanel.add((Component)this.carrierControllerSwitch, gbc);
        this.carrierControllerSwitch.setSize(50);
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        contentPane.add((Component)new JLabel("Carrier Position"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Carrier Status"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Carrier Speed"), gbc);
        ++gbc.gridy;
        int y2 = gbc.gridy;
        contentPane.add((Component)controllerPanel, gbc);
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.anchor = 22;
        contentPane.add((Component)this.carrierPositionLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.carrierStatusLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.carrierSpeedLabel, gbc);
        gbc.gridy = y2;
        gbc.gridx = 1;
        gbc.gridheight = 2;
        gbc.anchor = 10;
        this.carrierPositionProgressBar.setBorderPainted(true);
        this.carrierPositionProgressBar.setBackground(Tools.greenColor);
        this.carrierPositionProgressBar.setStringPainted(true);
        contentPane.add((Component)this.carrierPositionProgressBar, gbc);
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BoxLayout(internalPanel, 0));
        internalPanel.add(new VerticalTextComponent("Loader"));
        internalPanel.add(contentPane);
        this.loaderCarrierPanel = new JPanel();
        this.loaderCarrierPanel.setLayout(new CardLayout());
        this.loaderCarrierPanel.add(internalPanel);
        this.loaderCarrierPanel.add(Tools.getPanelPlaceHolder("loader_pane"));
        return this.loaderCarrierPanel;
    }

    private JPanel createLoaderHooksPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Loader"), 2), "Hooks"));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel clampControllerPanel = new JPanel();
        clampControllerPanel.setBorder(BorderFactory.createEtchedBorder());
        clampControllerPanel.setLayout(new GridBagLayout());
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        clampControllerPanel.add((Component)new JLabel("Controller Status"), gbc);
        ++gbc.gridy;
        clampControllerPanel.add((Component)this.clampControllerSwitch, gbc);
        this.clampControllerSwitch.setSize(40);
        JPanel filterPresencePanel = new JPanel();
        filterPresencePanel.setBorder(BorderFactory.createEtchedBorder());
        filterPresencePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        filterPresencePanel.add((Component)new JLabel("Filter Presence"), gbc);
        ++gbc.gridy;
        filterPresencePanel.add((Component)FILTERPRESENCESWITCH, gbc);
        FILTERPRESENCESWITCH.setSize(40);
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        contentPane.add((Component)new JLabel("Homing:"), gbc);
        ++gbc.gridx;
        gbc.anchor = 22;
        contentPane.add((Component)this.clampHomingLabel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.anchor = 21;
        contentPane.add((Component)clampControllerPanel, gbc);
        ++gbc.gridx;
        contentPane.add((Component)filterPresencePanel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.anchor = 21;
        int y = gbc.gridy++;
        contentPane.add((Component)new JLabel("Hooks Status"), gbc);
        contentPane.add((Component)new JLabel("Hooks Position"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Clamped Force Status"), gbc);
        gbc.gridy = y;
        ++gbc.gridx;
        gbc.anchor = 10;
        contentPane.add((Component)this.clampStateLabel, gbc);
        ++gbc.gridy;
        gbc.anchor = 22;
        contentPane.add((Component)this.clampPositionLabel, gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        contentPane.add((Component)this.forceStatusLabel, gbc);
        ++gbc.gridy;
        contentPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("autochanger_status")), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new FixedSizePanel(Tools.getPlaceHolder("autochanger_status")), gbc);
        this.loaderHooksPanel = new JPanel();
        this.loaderHooksPanel.setLayout(new BoxLayout(this.loaderHooksPanel, 0));
        this.loaderHooksPanel.add((Component)new VerticalTextComponent("Loader"), "Before");
        this.loaderHooksPanel.add((Component)contentPane, "Center");
        return this.loaderHooksPanel;
    }

    private JPanel createLoaderKeysPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Loader"), 2), ""));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        contentPane.add((Component)new JLabel("No Lockout"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Engineering key"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Carrier relay"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Hooks relay"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Safety belt presence"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("No Default status"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        contentPane.add((Component)NOLOCKOUTSWITCH, gbc);
        ++gbc.gridy;
        contentPane.add((Component)ENGINEERINGSWITCH, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.carrierRelaySwitch, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.hooksRelaySwitch, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.safetyBeltPresenceSwitch, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.noDefaultStatusSwitch, gbc);
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BoxLayout(internalPanel, 0));
        internalPanel.add(new VerticalTextComponent("PLC Loader"));
        internalPanel.add(contentPane);
        this.loaderKeysPanel = new JPanel();
        this.loaderKeysPanel.setLayout(new CardLayout());
        this.loaderKeysPanel.add(internalPanel);
        this.loaderKeysPanel.add(Tools.getPanelPlaceHolder("loader_pane"));
        return this.loaderKeysPanel;
    }

    private JPanel createCameraProtectionPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Autochanger"), 2), "Camera protection"));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        contentPane.add((Component)new JLabel("AP2 (AC at handoff)"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("AF0 (AC latches opened)"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("AF1 (Filter detected in AC)"), gbc);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("AF3 (Filter engaged and Latches closed)"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        contentPane.add((Component)AP2SWITCH, gbc);
        ++gbc.gridy;
        contentPane.add((Component)AF0SWITCH, gbc);
        ++gbc.gridy;
        contentPane.add((Component)AF1SWITCH, gbc);
        ++gbc.gridy;
        contentPane.add((Component)AF3SWITCH, gbc);
        this.cameraProtectionPanel = new JPanel();
        this.cameraProtectionPanel.setLayout(new BoxLayout(this.cameraProtectionPanel, 0));
        this.cameraProtectionPanel.add((Component)new VerticalTextComponent("PLC Autochanger"), "Before");
        this.cameraProtectionPanel.add((Component)contentPane, "Center");
        return this.cameraProtectionPanel;
    }

    private JPanel createCommonCommandPanel() {
        this.commonCommandPanel = new JPanel();
        this.commonCommandPanel.setBorder(BorderFactory.createTitledBorder("High level commands for standalone mode"));
        this.commonCommandPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.commonCommandPanel.add((Component)this.loadFilterButton, gbc0);
        ++gbc0.gridy;
        this.commonCommandPanel.add((Component)this.unloadFilterButton, gbc0);
        return this.commonCommandPanel;
    }

    private JPanel createUncommonCommandPanel() {
        this.uncommonCommandPanel = new JPanel();
        this.uncommonCommandPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        this.uncommonCommandPanel.add((Component)this.moveFilterStoHButton, gbc0);
        ++gbc0.gridy;
        this.uncommonCommandPanel.add((Component)this.moveFilterHtoSButton, gbc0);
        ++gbc0.gridy;
        this.uncommonCommandPanel.add((Component)this.openClampAndMoveEmptyToSButton, gbc0);
        ++gbc0.gridy;
        this.uncommonCommandPanel.add((Component)this.moveEmptyToHandCloseButton, gbc0);
        return this.uncommonCommandPanel;
    }

    private void setDefaultValues() {
        DOCKEDSWITCH.setColor(Color.gray);
        AP2SWITCH.setColor(Color.gray);
        AF0SWITCH.setColor(Color.gray);
        AF1SWITCH.setColor(Color.gray);
        AF3SWITCH.setColor(Color.gray);
        NOLOCKOUTSWITCH.setColor(Color.gray);
        ENGINEERINGSWITCH.setColor(Color.gray);
        this.carrierRelaySwitch.setColor(Color.gray);
        this.hooksRelaySwitch.setColor(Color.gray);
        this.safetyBeltPresenceSwitch.setColor(Color.gray);
        this.noDefaultStatusSwitch.setColor(Color.gray);
        this.clampHomingLabel.setText("NOT DONE");
        this.clampHomingLabel.setForeground(Tools.greenColor);
        FILTERPRESENCESWITCH.setColor(Color.gray);
        this.clampControllerSwitch.setColor(Color.gray);
        this.clampStateLabel.setText("UNKNOWN");
        this.clampPositionLabel.setText("0.0");
        this.forceStatusLabel.setText("UNKNOWN");
        this.carrierPositionLabel.setText("0.0");
        this.carrierStatusLabel.setText("UNKNOWN");
        this.carrierControllerSwitch.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void loadFilterActionPerformed(ActionEvent evt) {
        this.subs.loLoadFilterIntoBenchOrStorageBox();
    }

    private void unloadFilterActionPerformed(ActionEvent evt) {
        this.subs.loUnloadFilterFromBenchOrStorageBox();
    }

    private void moveFilterStoHActionPerformed(ActionEvent evt) {
        this.subs.loMoveFilterStoH();
    }

    private void moveFilterHtoSActionPerformed(ActionEvent evt) {
        this.subs.loMoveFilterHtoS();
    }

    private void moveEmptyToHandCloseActionPerformed(ActionEvent evt) {
        this.subs.loMoveEmptyToHandClose();
    }

    private void openClampAndMoveEmptyToStoSActionPerformed(ActionEvent evt) {
        this.subs.loOpenClampAndMoveEmptyToS();
    }

    @Override
    public String toString() {
        return "Overview";
    }

    public static void main(String[] args) {
        LoaderGeneralViewPanel d = new LoaderGeneralViewPanel();
        JFrame frame = new JFrame("LoaderGeneralViewPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForCarrier = this.configInfo.getCurrentValuesFor("loader/carrier");
            int handoffPosition = Tools.toInt(configForCarrier, "handoffPosition");
            int storagePosition = Tools.toInt(configForCarrier, "storagePosition");
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setMinimum(-handoffPosition);
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setMaximum(-storagePosition);
            LoaderGeneralViewPanel.this.carrierPositionProgressBar.setValue(0);
        }
    }

    private class UpdateClamp
    implements Runnable {
        private final StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("DONE");
            } else {
                LoaderGeneralViewPanel.this.clampHomingLabel.setText("--");
            }
            Color clampStateColor = this.s.getClampState().getColor();
            LoaderGeneralViewPanel.this.clampStateLabel.setText(this.s.getClampState().getText());
            LoaderGeneralViewPanel.this.clampStateLabel.setForeground(clampStateColor);
            LoaderGeneralViewPanel.this.forceStatusLabel.setText(this.s.getForceStatus().toString());
            LoaderGeneralViewPanel.this.clampControllerSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isAtStorage()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("STORAGE");
            } else if (this.s.isAtEngaged()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("ENGAGED");
            } else if (this.s.isAtHandoff()) {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("HANDOFF");
            } else {
                LoaderGeneralViewPanel.this.carrierStatusLabel.setText("IN_TRAVEL");
            }
            LoaderGeneralViewPanel.this.carrierControllerSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DigitalSwitch digitalSwitch : LoaderGeneralViewPanel.this.redondantSwitches) {
                digitalSwitch.updateColorRedondantSensor(this.sensorMap);
            }
            for (DigitalSwitch digitalSwitch : LoaderGeneralViewPanel.this.complementarySwitches) {
                digitalSwitch.updateColorComplementary(this.sensorMap);
            }
            for (JComponent jComponent : LoaderGeneralViewPanel.this.diamondSwitchesGreenGray) {
                ((DiamondSwitch)jComponent).updateColorGreenGray(this.sensorMap);
            }
            LoaderGeneralViewPanel.this.noDefaultStatusSwitch.updateColorDefaultRedGreen(this.sensorMap);
        }
    }

    public class UpdateCarrierController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                LoaderGeneralViewPanel.this.carrierPositionLabel.setText(Integer.toString(this.s.getPosition()));
                LoaderGeneralViewPanel.this.carrierSpeedLabel.setText(Integer.toString(this.s.getVelocity()));
                LoaderGeneralViewPanel.this.carrierPositionProgressBar.setValue(-this.s.getPosition());
                LoaderGeneralViewPanel.this.carrierPositionProgressBar.setForeground(Color.PINK);
            }
        }
    }

    public class UpdateClampController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isBooted() && this.s.getState() != null) {
                LoaderGeneralViewPanel.this.clampPositionLabel.setText(Integer.toString(this.s.getPosition()));
            }
        }
    }
}

