/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.twistorr;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class TwisTorr
extends Ascii {
    private static final Logger LOG = Logger.getLogger(TwisTorr.class.getName());
    private final int BAUD_RATE = 9600;
    private final int TIMEOUT = 100;
    private final int LATENCY = 35;
    private final int ISLEEP = 10;
    private static final int ACK_RESP_LEN = 6;
    private static final int DATA_OFFSET = 6;
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final byte ADDR = (byte)-128;
    private static final String[] errtypes = new String[]{"no_connection", "pump_overTemp", "controller_overTemp", "unused", "unused", "overVoltage", "shortCircuit", "overload"};
    private static final String Lbl = "TwisTorr: ";
    private static int FS74OB = CntlrModels.FS74OB.getModelMask();
    private static int FS84OB = CntlrModels.FS84OB.getModelMask();
    private static int FS304OB = CntlrModels.FS304OB.getModelMask();
    private static int FS305OB = CntlrModels.FS305OB.getModelMask();
    private static int ALLMODELS = FS74OB | FS84OB | FS304OB | FS305OB;
    private static int NONE = 0;

    public static String decodeError(int errcode) {
        if (errcode == 0) {
            return "  no error";
        }
        String result = "";
        int code = errcode;
        int i = 0;
        while (i < 8) {
            if ((code & 1) != 0) {
                result = result + "  " + errtypes[i];
            }
            ++i;
            code >>>= 1;
        }
        return result;
    }

    public TwisTorr() {
        super(Ascii.Option.NO_NET);
    }

    @Override
    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, baudRate == 0 ? 9600 : baudRate, 0);
        this.setTimeout(100);
        try {
            this.writeBool(CmndBool.REMOTE, Boolean.FALSE);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(String serialName) throws DriverException {
        this.openSerial(serialName, 9600);
    }

    public boolean readBool(CmndBool cmnd) throws DriverException {
        String cmndText;
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr: Read not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(0);
        byte[] response = this.respToCommand(cmndBody, cmndText = "Read " + cmnd.toString(), 10);
        String str = new String(response, 6, 1);
        int istr = Integer.parseInt(str);
        if (istr == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void writeBool(CmndBool cmnd, boolean bdata) throws DriverException {
        if (!cmnd.writeAllowed) {
            throw new DriverException("TwisTorr: Write not allowed for " + cmnd.toString());
        }
        int data = 0;
        if (bdata) {
            data = 1;
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(1) + String.valueOf(data);
        String cmndText = "Write " + cmnd.toString();
        this.respToCommand(cmndBody, cmndText, 6);
    }

    public int readNumeric(CmndNumeric cmnd) throws DriverException {
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr: Read not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(0);
        String cmndText = "Read " + cmnd.toString();
        byte[] response = this.respToCommand(cmndBody, cmndText, 15);
        String str = new String(response, 6, 6);
        return Integer.parseInt(str);
    }

    public void writeNumeric(CmndNumeric cmnd, int ndata) throws DriverException {
        if (!cmnd.writeAllowed) {
            throw new DriverException("TwisTorr: Write not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(1) + String.format("%06d", ndata);
        String cmndText = "Write " + cmnd.toString();
        this.respToCommand(cmndBody, cmndText, 6);
    }

    public String readAlpha(CmndAlpha cmnd) throws DriverException {
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr: Read not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(0);
        String cmndText = "Read " + cmnd.toString();
        byte[] response = this.respToCommand(cmndBody, cmndText, 19);
        String str = new String(response, 6, 10);
        return str;
    }

    public void writeAlpha(CmndAlpha cmnd, String adata) throws DriverException {
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr: Write not allowed for " + cmnd.toString());
        }
        if (adata.length() > 10) {
            throw new DriverException("TwisTorr: String exceeds 10 characters " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(1) + String.format("%-10s", adata);
        String cmndText = "Write " + cmnd.toString();
        this.respToCommand(cmndBody, cmndText, 6);
    }

    private synchronized byte[] respToCommand(String commandBody, String cmndText, int expRespLen) throws DriverException {
        String status;
        byte[] command = new byte[commandBody.length() + 5];
        System.arraycopy(commandBody.getBytes(), 0, command, 2, commandBody.length());
        command[0] = 2;
        command[1] = -128;
        command[command.length - 3] = 3;
        byte[] commandCRC = this.computeCRC(command, 1, 2);
        System.arraycopy(commandCRC, 0, command, command.length - 2, 2);
        this.flush();
        long startTime = System.currentTimeMillis();
        this.writeBytes(command);
        try {
            Thread.sleep(35L);
        }
        catch (InterruptedException ex) {
            LOG.log(Level.INFO, () -> String.format("Unexpected interrupt while waiting for sleep to end", new Object[0]));
        }
        byte[] response = this.read(expRespLen);
        if ((response.length == 6 || response[3] == 3) && (status = ConResp.decode(response[2])) != ConResp.ACK.toString()) {
            throw new DriverException("TwisTorr: error response " + status + " to " + cmndText);
        }
        long dt = System.currentTimeMillis() - startTime;
        LOG.log(Level.FINER, () -> String.format("response to %s took %s ms", cmndText, dt));
        if (dt >= 60L) {
            LOG.log(Level.FINE, () -> String.format("response to %s took %s ms", cmndText, dt));
        }
        return response;
    }

    private byte[] read(int respLen) throws DriverException {
        byte[] buff = new byte[respLen];
        int curr = 0;
        int timeout_count = 0;
        while (true) {
            try {
                curr += this.readBytes(buff, curr);
            }
            catch (DriverTimeoutException e) {
                int ncurr = curr;
                LOG.log(Level.FINE, () -> {
                    StringBuilder dbg = new StringBuilder();
                    dbg.append(String.format("%s ** Response (size = %d of %d expected): ", e, ncurr, respLen));
                    for (int ib = 0; ib < buff.length; ++ib) {
                        dbg.append(String.format(" %02x", buff[ib]));
                    }
                    return dbg.toString();
                });
                if (timeout_count > 0) {
                    throw new DriverTimeoutException((Object)((Object)e) + String.format(" -- after %d of %d bytes read", curr, respLen));
                }
                ++timeout_count;
                continue;
            }
            if ((curr == respLen || curr == 6) && buff[curr - 3] == 3) {
                byte[] crcByte = this.computeCRC(buff, 1, respLen - curr + 2);
                if (crcByte[0] == buff[curr - 2] && crcByte[1] == buff[curr - 1]) {
                    return buff;
                }
                throw new DriverException("TwisTorr: incorrect CRC");
            }
            if (curr >= Math.max(respLen, 6)) {
                try {
                    Thread.sleep(35L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.INFO, () -> String.format("Unexpected interrupt while waiting for sleep to end", new Object[0]));
                }
                this.flush();
                throw new DriverException("TwisTorr: response too long");
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException ex) {
                LOG.log(Level.INFO, () -> String.format("Unexpected interrupt while waiting for sleep to end", new Object[0]));
                continue;
            }
            break;
        }
    }

    private byte[] computeCRC(byte[] array, int omitFirst, int omitLast) {
        byte CRC = 0;
        int length = array.length;
        if (length - omitFirst - omitLast > 0) {
            for (int i = omitFirst; i < array.length - omitLast; ++i) {
                CRC = (byte)(CRC ^ array[i]);
            }
        }
        String crcString = String.format("%02X", CRC);
        byte[] crcBytes = crcString.getBytes();
        return crcBytes;
    }

    static /* synthetic */ int access$000() {
        return ALLMODELS;
    }

    static /* synthetic */ int access$100() {
        return FS84OB;
    }

    static /* synthetic */ int access$200() {
        return FS305OB;
    }

    static /* synthetic */ int access$300() {
        return FS74OB;
    }

    static /* synthetic */ int access$400() {
        return FS304OB;
    }

    static /* synthetic */ int access$500() {
        return NONE;
    }

    public static enum CmndBool {
        START_STOP("000", true, true, TwisTorr.access$000()),
        LOW_SPEED_MODE("001", true, true, TwisTorr.access$100() | TwisTorr.access$200()),
        REMOTE("008", true, true, TwisTorr.access$000()),
        SOFT_START_MODE("100", true, true, TwisTorr.access$000()),
        SETPOINT_ACTIVE("104", true, true, TwisTorr.access$000()),
        WATER_COOLING("106", true, true, TwisTorr.access$300() | TwisTorr.access$100() | TwisTorr.access$400()),
        ACTIVE_STOP_MODE("107", true, true, TwisTorr.access$300() | TwisTorr.access$100() | TwisTorr.access$400()),
        RESET_CYCLE_TIME("109", false, true, TwisTorr.access$000()),
        INTERLOCK_TYPE("110", true, true, TwisTorr.access$000()),
        VENTVALVE_OPEN("122", true, true, TwisTorr.access$000()),
        VENTVALVE_BY_CMND("125", true, true, TwisTorr.access$000()),
        VENTVALVE_TYPE("140", true, true, TwisTorr.access$200()),
        EXT_FAN_SETTING("144", true, true, TwisTorr.access$000()),
        GAS_TYPE_ARGON("157", true, true, TwisTorr.access$300() | TwisTorr.access$100()),
        SPEED_READ_ACTIVATE("167", true, true, TwisTorr.access$000()),
        SERIAL_TYPE("504", true, false, TwisTorr.access$000());

        public static final int DATA_LENGTH = 1;
        public static final int READ_RESP_LEN = 10;
        public static final int WRITE_RESP_LEN = 6;
        private String window;
        private boolean readAllowed;
        private boolean writeAllowed;
        private int models;

        private CmndBool(String window, boolean readAllowed, boolean writeAllowed, int models) {
            this.window = window;
            this.readAllowed = readAllowed;
            this.writeAllowed = writeAllowed;
            this.models = models;
        }

        public String getWindow() {
            return this.window;
        }

        public int getModels() {
            return this.models;
        }
    }

    public static enum CmndNumeric {
        SETPOINT_TYPE("101", true, true, TwisTorr.access$000()),
        SETPOINT_THRESH("102", true, true, TwisTorr.access$000()),
        SETPOINT_DELAY("103", true, true, TwisTorr.access$000()),
        SETPOINT_HYST("105", true, true, TwisTorr.access$000()),
        BAUD_RATE("108", true, true, TwisTorr.access$000()),
        ANALOG_OUTPUT("111", true, true, TwisTorr.access$000()),
        ROTFREQ_LOW("117", true, true, TwisTorr.access$100()),
        ROTFREQ_SET("120", true, true, TwisTorr.access$000()),
        ROTFREQ_MAX("121", true, true, TwisTorr.access$400() | TwisTorr.access$200()),
        VENT_DELAY("126", true, true, TwisTorr.access$000()),
        EXT_FAN_CONFIG("143", true, true, TwisTorr.access$000()),
        VENT_OPENTIME("147", true, true, TwisTorr.access$300() | TwisTorr.access$100()),
        MAXPOWER("155", true, false, TwisTorr.access$300() | TwisTorr.access$100()),
        GAS_TYPE("157", true, true, TwisTorr.access$200()),
        PRESSURE_FACTOR("161", true, true, TwisTorr.access$500()),
        PRESSURE_UNIT("163", true, true, TwisTorr.access$500()),
        CURRENT("200", true, false, TwisTorr.access$000()),
        VOLTAGE("201", true, false, TwisTorr.access$000()),
        POWER("202", true, false, TwisTorr.access$000()),
        DRIVEFREQ("203", true, false, TwisTorr.access$000()),
        PUMP_TEMP("204", true, false, TwisTorr.access$000()),
        STATUS("205", true, false, TwisTorr.access$000()),
        ERRCODE("206", true, false, TwisTorr.access$000()),
        CONT_TEMP_SINK("211", true, false, TwisTorr.access$300() | TwisTorr.access$100()),
        CONT_TEMP_AIR("216", true, false, TwisTorr.access$300() | TwisTorr.access$100()),
        RPM("226", true, false, TwisTorr.access$300() | TwisTorr.access$100()),
        CYCLE_TIME("300", true, false, TwisTorr.access$000()),
        CYCLE_NUMBER("301", true, false, TwisTorr.access$000()),
        PUMP_HOURS("302", true, false, TwisTorr.access$000()),
        RS485_ADDR("503", true, false, TwisTorr.access$500());

        public static final int DATA_LENGTH = 6;
        public static final int READ_RESP_LEN = 15;
        public static final int WRITE_RESP_LEN = 6;
        private String window;
        private boolean readAllowed;
        private boolean writeAllowed;
        private int models;

        private CmndNumeric(String window, boolean readAllowed, boolean writeAllowed, int models) {
            this.window = window;
            this.readAllowed = readAllowed;
            this.writeAllowed = writeAllowed;
            this.models = models;
        }

        public String getWindow() {
            return this.window;
        }

        public int getModels() {
            return this.models;
        }
    }

    public static enum CmndAlpha {
        PRESSURE_SET("162", true, true, TwisTorr.access$500()),
        PRESSURE("224", true, false, TwisTorr.access$500());

        public static final int DATA_LENGTH = 10;
        public static final int READ_RESP_LEN = 19;
        public static final int WRITE_RESP_LEN = 6;
        private String window;
        private boolean readAllowed;
        private boolean writeAllowed;
        private int models;

        private CmndAlpha(String window, boolean readAllowed, boolean writeAllowed, int models) {
            this.window = window;
            this.readAllowed = readAllowed;
            this.writeAllowed = writeAllowed;
            this.models = models;
        }

        public String getWindow() {
            return this.window;
        }

        public int getModels() {
            return this.models;
        }
    }

    public static enum ConResp {
        ACK(6),
        NACK(21),
        BAD_WINDOW(50),
        BAD_DATA_TYPE(51),
        OUT_OF_RANGE(52),
        DISABLED(53);

        private byte response;

        private ConResp(byte response) {
            this.response = response;
        }

        public static String decode(byte code) throws DriverException {
            ConResp[] con = ConResp.values();
            int n = con.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (con[i].response != code) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("TwisTorr: invalid response code");
            }
            return con[found].toString();
        }
    }

    public static enum CntlrModels {
        FS74OB(1),
        FS84OB(2),
        FS304OB(4),
        FS305OB(8);

        private int modelMask;

        private CntlrModels(int modelMask) {
            this.modelMask = modelMask;
        }

        public int getModelMask() {
            return this.modelMask;
        }
    }

    public static enum PumpStatus {
        STOP(0),
        WAIT_INTLK(1),
        STARTING(2),
        AUTO_TUNING(3),
        BRAKING(4),
        NORMAL(5),
        FAIL(6);

        private int status;

        private PumpStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static String decode(int code) throws DriverException {
            return PumpStatus.decodeStatus(code).toString();
        }

        public static PumpStatus decodeStatus(int code) throws DriverException {
            PumpStatus[] stat = PumpStatus.values();
            int n = stat.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (stat[i].status != code) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("TwisTorr: invalid status code");
            }
            return stat[found];
        }
    }
}

