/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.data.MonitorTask;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class MonitorTaskLine
extends JPanel
implements UiUtilities.ActionHandler {
    private static final int horzInset = UiUtilities.getLabelSize((String)"M").width / 2;
    private final CommandSender sender;
    private final String node;
    private final UiUtilities uiUtils;
    private JLabel taskNameLabel;
    private TextFieldX periodTextField;
    private JCheckBox periodCheckbox;
    private static final long serialVersionUID = 1L;

    public MonitorTaskLine(CommandSender sender, String node, int nameSize) {
        this.sender = sender;
        this.node = node;
        this.uiUtils = new UiUtilities(this);
        this.initComponents(nameSize);
        this.disablePanel();
    }

    public void updatePanel(MonitorTask task) {
        this.taskNameLabel.setEnabled(true);
        this.taskNameLabel.setText(task.getName());
        this.periodTextField.update((double)task.getPeriod() / 1000.0, true);
        this.periodCheckbox.setEnabled(true);
        this.periodCheckbox.setSelected(task.isActive());
    }

    public void disablePanel() {
        this.taskNameLabel.setEnabled(false);
        this.periodTextField.setDisabled();
        this.periodCheckbox.setEnabled(false);
    }

    private void initComponents(int nameSize) {
        this.taskNameLabel = UiUtilities.newLabel("XXX", nameSize);
        this.periodTextField = this.uiUtils.newTextFieldX("99999.9", "", 2, true);
        this.periodCheckbox = this.uiUtils.newCheckBox("", "");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(0, horzInset, -3, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        this.add((Component)UiUtilities.newLabel("Task:  ", 0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 0;
        this.add((Component)this.taskNameLabel, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.add((Component)UiUtilities.newLabel("Period:  ", 0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 0;
        gbh.insets.top -= 2;
        this.add((Component)this.periodTextField, gbh);
        ++gbh.gridx;
        gbh.insets.left = horzInset;
        gbh.insets.top += 2;
        this.add((Component)UiUtilities.newLabel("sec", 0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.add((Component)UiUtilities.newLabel("Active: ", 0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 0;
        this.add((Component)this.periodCheckbox, gbh);
    }

    @Override
    public void handleTextFieldX(String name, Object value) {
        this.sender.sendCommand(this.node, "setTaskPeriod", this.taskNameLabel.getText(), (int)(1000.0 * (Double)value));
    }

    @Override
    public void handleCheckBox(String name, boolean selected) {
        this.sender.sendCommand(this.node, "setTaskActive", this.taskNameLabel.getText(), selected);
    }
}

